/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.equalitymode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.drools.testcoverage.common.util.EngineTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class AccumulateCepEqualityModeTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public AccumulateCepEqualityModeTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseConfigurations((EngineTestConfiguration[])new EngineTestConfiguration[]{EngineTestConfiguration.EQUALITY_MODE, EngineTestConfiguration.STREAM_MODE, EngineTestConfiguration.ALPHA_NETWORK_COMPILER_FALSE, EngineTestConfiguration.EXECUTABLE_MODEL_OFF, EngineTestConfiguration.EXECUTABLE_MODEL_FLOW, EngineTestConfiguration.EXECUTABLE_MODEL_PATTERN});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testManySlidingWindows() {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"accumulate-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package com.sample;\n\nglobal java.util.List list; \ndeclare Fakt\n  @role( event ) \n  id : int \nend\n \nrule Init \nwhen \n  $i : Integer() \nthen \n  insert( new Fakt( $i ) ); \nend\nrule \"Test\"\nwhen\n   accumulate ( $d : Fakt( id > 10 ) over window:length(2), $tot1 : count( $d ) ) \n   accumulate ( $d : Fakt( id < 50 ) over window:length(5), $tot2 : count( $d ) ) \nthen\n  list.clear();\n   list.add( $tot1.intValue() ); \n  list.add( $tot2.intValue() ); \nend\n\n"});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)new Integer(20));
            ksession.fireAllRules();
            Assert.assertEquals(Arrays.asList(1, 1), list);
            ksession.insert((Object)new Integer(20));
            ksession.fireAllRules();
            Assert.assertEquals(Arrays.asList(1, 1), list);
            ksession.insert((Object)new Integer(20));
            ksession.fireAllRules();
            Assert.assertEquals(Arrays.asList(1, 1), list);
            ksession.insert((Object)new Integer(2));
            ksession.fireAllRules();
            Assert.assertEquals(Arrays.asList(1, 2), list);
            ksession.insert((Object)new Integer(2));
            ksession.fireAllRules();
            Assert.assertEquals(Arrays.asList(1, 2), list);
            ksession.insert((Object)new Integer(2));
            ksession.fireAllRules();
            Assert.assertEquals(Arrays.asList(1, 2), list);
        }
        finally {
            ksession.dispose();
        }
    }
}

