/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.operators;

import java.util.ArrayList;
import java.util.Collection;
import org.drools.testcoverage.common.model.PersonWithSpecificEquals;
import org.drools.testcoverage.common.model.Primitives;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class EqualsTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public EqualsTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEqualitySupport() {
        String drl = "package org.drools.compiler.integrationtests.operators\nimport " + PersonWithSpecificEquals.class.getCanonicalName() + " ;\nglobal java.util.List results;\n\nrule \"test equality support\"\n    salience 10\nwhen\n    $p : PersonWithSpecificEquals( name == \"bob\" )\nthen\n    $p.setName( \"mark\" );\n    results.add( $p.getName() );\n    update( $p );\nend\n\nrule \"test 2\"\nwhen\n    $p : PersonWithSpecificEquals( name == \"bob\" )\nthen\n    results.add( \"This rule should NEVER fire\" );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"equals-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            ksession.setGlobal("results", results);
            PersonWithSpecificEquals person = new PersonWithSpecificEquals("bob", 30);
            ksession.insert((Object)person);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertEquals((Object)"mark", results.get(0));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNotEqualsOperator() {
        String str = "package org.drools.compiler.integrationtests.operators\nimport " + Primitives.class.getCanonicalName() + " ;\nrule NotEquals\nwhen\n    Primitives( booleanPrimitive != booleanWrapper )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"equals-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        try {
            Primitives p = new Primitives();
            p.setBooleanPrimitive(true);
            p.setBooleanWrapper(Boolean.FALSE);
            ksession.insert((Object)p);
            int rules = ksession.fireAllRules();
            ksession.dispose();
            Assert.assertEquals((long)1L, (long)rules);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCharComparisons() {
        String drl = "package org.drools.compiler.integrationtests.operators\nimport " + Primitives.class.getCanonicalName() + " ;\nglobal java.util.List results;\n\nrule \"test chars 1\"\n    salience 100\nwhen\n    Primitives( charPrimitive == 'a' ) \nthen\n    results.add( \"1\" );\nend\n\nrule \"test chars 2\"\n    salience 90\nwhen\n    Primitives( $c1: charPrimitive == 'a' ) \n    Primitives( charPrimitive != $c1 )\nthen\n    results.add( \"2\" );\nend\n\nrule \"test chars 3\"\n    salience 80\nwhen\n    Primitives( $c1: stringAttribute == 'a' ) \n    Primitives( charPrimitive == $c1 )\nthen\n    results.add( \"3\" );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"equals-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            ksession.setGlobal("results", results);
            Primitives p1 = new Primitives();
            p1.setCharPrimitive('a');
            p1.setStringAttribute("b");
            Primitives p2 = new Primitives();
            p2.setCharPrimitive('b');
            p2.setStringAttribute("a");
            ksession.insert((Object)p1);
            ksession.insert((Object)p2);
            ksession.fireAllRules();
            Assert.assertEquals((long)3L, (long)results.size());
            Assert.assertEquals((Object)"1", results.get(0));
            Assert.assertEquals((Object)"2", results.get(1));
            Assert.assertEquals((Object)"3", results.get(2));
        }
        finally {
            ksession.dispose();
        }
    }
}

