/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.drools.testcoverage.common.model.Primitives;
import org.drools.testcoverage.common.model.TestParam;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

@RunWith(value=Parameterized.class)
public class ArrayTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public ArrayTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEqualsOnIntArray() {
        String drl = "package org.drools.compiler;\nimport " + Primitives.class.getCanonicalName() + ";\nglobal java.util.List list;\nrule \"contains in array\"\n     salience 10\n     when\n         Primitives( primitiveIntArray[0] == 1 )\n     then\n        list.add( \"ok1\" );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"array-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            Primitives p1 = new Primitives();
            p1.setPrimitiveIntArray(new int[]{1, 2});
            ksession.insert((Object)p1);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContainsBooleanArray() {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"array-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{this.getDrl("Boolean", false, "true")});
        KieSession kieSession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            this.addGlobalsToSession(kieSession, list, true, new Boolean[]{true, false});
            Primitives p1 = new Primitives();
            p1.setPrimitiveBooleanArray(new boolean[]{true, false});
            p1.setBooleanPrimitive(false);
            Primitives p2 = new Primitives();
            p2.setPrimitiveBooleanArray(new boolean[]{true, false});
            p2.setBooleanPrimitive(true);
            this.testArrayContains(kieSession, p1, p2, list);
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNotContainsBooleanArray() {
        String drl = "package org.drools.compiler;\nimport " + Primitives.class.getCanonicalName() + ";\nglobal java.util.List list;\nglobal Boolean nGlobal;\nglobal Object arrayGlobal;\nrule \"contains in array\"\n     salience 10\n     when\n         Primitives( $b : booleanPrimitive, intPrimitive == 10, $array1 :  primitiveBooleanArray ) \n         Primitives( booleanPrimitive == false, intPrimitive != 10, $array2 : primitiveBooleanArray not contains nGlobal,  primitiveBooleanArray not contains $b,                      booleanPrimitive not memberOf $array2, booleanPrimitive not memberOf $array1, booleanPrimitive not memberOf arrayGlobal )\n     then\n        list.add( \"ok1\" );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"array-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            this.addGlobalsToSession(kieSession, list, false, new Boolean[]{true, true});
            Primitives p1 = new Primitives();
            p1.setIntPrimitive(10);
            p1.setPrimitiveBooleanArray(new boolean[]{true, true});
            p1.setBooleanPrimitive(false);
            Primitives p2 = new Primitives();
            p2.setPrimitiveBooleanArray(new boolean[]{true, true});
            p2.setBooleanPrimitive(false);
            this.testArrayContains(kieSession, p1, p2, list);
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContainsByteArray() {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"array-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{this.getDrl("Byte", false, "1")});
        KieSession kieSession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            this.addGlobalsToSession(kieSession, list, (byte)1, new Byte[]{(byte)1, (byte)2, (byte)3});
            Primitives p1 = new Primitives();
            p1.setPrimitiveByteArray(new byte[]{1, 2, 3});
            p1.setBytePrimitive((byte)2);
            Primitives p2 = new Primitives();
            p2.setPrimitiveByteArray(new byte[]{1, 2, 3});
            p2.setBytePrimitive((byte)1);
            this.testArrayContains(kieSession, p1, p2, list);
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNotContainsByteArray() {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"array-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{this.getDrl("Byte", true, "1")});
        KieSession kieSession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            this.addGlobalsToSession(kieSession, list, (byte)1, new Byte[]{(byte)4, (byte)5, (byte)6});
            Primitives p1 = new Primitives();
            p1.setPrimitiveByteArray(new byte[]{4, 5, 6});
            p1.setBytePrimitive((byte)2);
            Primitives p2 = new Primitives();
            p2.setPrimitiveByteArray(new byte[]{4, 5, 6});
            p2.setBytePrimitive((byte)1);
            this.testArrayContains(kieSession, p1, p2, list);
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContainsShortArray() {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"array-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{this.getDrl("Short", false, "1")});
        KieSession kieSession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            this.addGlobalsToSession(kieSession, list, (short)1, new Short[]{(short)1, (short)2, (short)3});
            Primitives p1 = new Primitives();
            p1.setPrimitiveShortArray(new short[]{1, 2, 3});
            p1.setShortPrimitive((short)2);
            Primitives p2 = new Primitives();
            p2.setPrimitiveShortArray(new short[]{1, 2, 3});
            p2.setShortPrimitive((short)1);
            this.testArrayContains(kieSession, p1, p2, list);
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNotContainsShortArray() {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"array-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{this.getDrl("Short", true, "1")});
        KieSession kieSession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            this.addGlobalsToSession(kieSession, list, (short)1, new Short[]{(short)4, (short)5, (short)6});
            Primitives p1 = new Primitives();
            p1.setPrimitiveShortArray(new short[]{4, 5, 6});
            p1.setShortPrimitive((short)2);
            Primitives p2 = new Primitives();
            p2.setPrimitiveShortArray(new short[]{4, 5, 6});
            p2.setShortPrimitive((short)1);
            this.testArrayContains(kieSession, p1, p2, list);
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContainsCharArray() {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"array-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{this.getDrl("Character", false, "'c'")});
        KieSession kieSession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            this.addGlobalsToSession(kieSession, list, Character.valueOf('c'), new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')});
            Primitives p1 = new Primitives();
            p1.setPrimitiveCharArray(new char[]{'a', 'b', 'c'});
            p1.setCharPrimitive('a');
            Primitives p2 = new Primitives();
            p2.setPrimitiveCharArray(new char[]{'a', 'b', 'c'});
            p2.setCharPrimitive('c');
            this.testArrayContains(kieSession, p1, p2, list);
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNotContainsCharArray() {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"array-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{this.getDrl("Character", true, "'c'")});
        KieSession kieSession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            this.addGlobalsToSession(kieSession, list, Character.valueOf('c'), new Character[]{Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f')});
            Primitives p1 = new Primitives();
            p1.setPrimitiveCharArray(new char[]{'d', 'e', 'f'});
            p1.setCharPrimitive('a');
            Primitives p2 = new Primitives();
            p2.setPrimitiveCharArray(new char[]{'d', 'e', 'f'});
            p2.setCharPrimitive('c');
            this.testArrayContains(kieSession, p1, p2, list);
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContainsIntArray() {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"array-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{this.getDrl("Integer", false, "10")});
        KieSession kieSession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            this.addGlobalsToSession(kieSession, list, 10, new Integer[]{5, 10, 20});
            Primitives p1 = new Primitives();
            p1.setPrimitiveIntArray(new int[]{5, 10, 20});
            p1.setIntPrimitive(5);
            Primitives p2 = new Primitives();
            p2.setPrimitiveIntArray(new int[]{5, 10, 20});
            p2.setIntPrimitive(10);
            this.testArrayContains(kieSession, p1, p2, list);
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNotContainsIntArray() {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"array-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{this.getDrl("Integer", true, "10")});
        KieSession kieSession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            this.addGlobalsToSession(kieSession, list, 10, new Integer[]{40, 50, 60});
            Primitives p1 = new Primitives();
            p1.setPrimitiveIntArray(new int[]{40, 50, 60});
            p1.setIntPrimitive(5);
            Primitives p2 = new Primitives();
            p2.setPrimitiveIntArray(new int[]{40, 50, 60});
            p2.setIntPrimitive(10);
            this.testArrayContains(kieSession, p1, p2, list);
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContainsLongArray() {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"array-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{this.getDrl("Long", false, "10")});
        KieSession kieSession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            this.addGlobalsToSession(kieSession, list, 10L, new Long[]{5L, 10L, 20L});
            Primitives p1 = new Primitives();
            p1.setPrimitiveLongArray(new long[]{5L, 10L, 20L});
            p1.setLongPrimitive(5L);
            Primitives p2 = new Primitives();
            p2.setLongPrimitive(10L);
            p2.setPrimitiveLongArray(new long[]{5L, 10L, 20L});
            this.testArrayContains(kieSession, p1, p2, list);
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNotContainsLongArray() {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"array-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{this.getDrl("Long", true, "10")});
        KieSession kieSession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            this.addGlobalsToSession(kieSession, list, 10L, new Long[]{40L, 50L, 60L});
            Primitives p1 = new Primitives();
            p1.setPrimitiveLongArray(new long[]{40L, 50L, 60L});
            p1.setLongPrimitive(5L);
            Primitives p2 = new Primitives();
            p2.setLongPrimitive(10L);
            p2.setPrimitiveLongArray(new long[]{40L, 50L, 60L});
            this.testArrayContains(kieSession, p1, p2, list);
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContainsFloatArray() {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"array-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{this.getDrl("Float", false, "10f")});
        KieSession kieSession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            this.addGlobalsToSession(kieSession, list, Float.valueOf(10.0f), new Float[]{Float.valueOf(5.0f), Float.valueOf(10.0f), Float.valueOf(20.0f)});
            Primitives p1 = new Primitives();
            p1.setFloatPrimitive(5.0f);
            p1.setPrimitiveFloatArray(new float[]{5.0f, 10.0f, 20.0f});
            Primitives p2 = new Primitives();
            p2.setFloatPrimitive(10.0f);
            p2.setPrimitiveFloatArray(new float[]{5.0f, 10.0f, 20.0f});
            this.testArrayContains(kieSession, p1, p2, list);
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNotContainsFloatArray() {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"array-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{this.getDrl("Float", true, "10f")});
        KieSession kieSession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            this.addGlobalsToSession(kieSession, list, Float.valueOf(10.0f), new Float[]{Float.valueOf(40.0f), Float.valueOf(50.0f), Float.valueOf(60.0f)});
            Primitives p1 = new Primitives();
            p1.setFloatPrimitive(5.0f);
            p1.setPrimitiveFloatArray(new float[]{40.0f, 50.0f, 60.0f});
            Primitives p2 = new Primitives();
            p2.setFloatPrimitive(10.0f);
            p2.setPrimitiveFloatArray(new float[]{40.0f, 50.0f, 60.0f});
            this.testArrayContains(kieSession, p1, p2, list);
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContainsDoubleArray() {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"array-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{this.getDrl("Double", false, "10")});
        KieSession kieSession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            this.addGlobalsToSession(kieSession, list, 10.0, new Double[]{5.0, 10.0, 20.0});
            Primitives p1 = new Primitives();
            p1.setPrimitiveDoubleArray(new double[]{5.0, 10.0, 20.0});
            p1.setDoublePrimitive(5.0);
            Primitives p2 = new Primitives();
            p2.setDoublePrimitive(10.0);
            p2.setPrimitiveDoubleArray(new double[]{5.0, 10.0, 20.0});
            this.testArrayContains(kieSession, p1, p2, list);
        }
        finally {
            kieSession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNotContainsDoubleArray() {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"array-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{this.getDrl("Double", true, "10")});
        KieSession kieSession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            this.addGlobalsToSession(kieSession, list, 10.0, new Double[]{40.0, 50.0, 60.0});
            Primitives p1 = new Primitives();
            p1.setPrimitiveDoubleArray(new double[]{40.0, 50.0, 60.0});
            p1.setDoublePrimitive(5.0);
            Primitives p2 = new Primitives();
            p2.setDoublePrimitive(10.0);
            p2.setPrimitiveDoubleArray(new double[]{40.0, 50.0, 60.0});
            this.testArrayContains(kieSession, p1, p2, list);
        }
        finally {
            kieSession.dispose();
        }
    }

    private String getDrl(String type, boolean testNot, String primitiveTestValue) {
        String primitiveName = this.getPrimitiveAttributeName(type);
        String primitiveArrayName = this.getPrimitiveArrayName(type);
        String notString = testNot ? " not " : "";
        return "package org.drools.compiler;\nimport " + Primitives.class.getCanonicalName() + "\nglobal java.util.List list;\nglobal " + type + " nGlobal;\nglobal Object arrayGlobal;\nrule \"contains in array\"\n     salience 10\n     when\n         Primitives( $d : " + primitiveName + " == " + primitiveTestValue + ", $array1 :  " + primitiveArrayName + " ) \n         Primitives( " + primitiveName + " != " + primitiveTestValue + ", $array2 : " + primitiveArrayName + notString + " contains nGlobal,  " + primitiveArrayName + notString + " contains $d, \n                     " + primitiveName + notString + " memberOf $array2, " + primitiveName + notString + " memberOf $array1, " + primitiveName + notString + " memberOf arrayGlobal )\n     then\n        list.add( \"ok1\" );\nend\n";
    }

    private String getPrimitiveAttributeName(String type) {
        if ("Character".equals(type)) {
            return "charPrimitive";
        }
        if ("Integer".equals(type)) {
            return "intPrimitive";
        }
        return type.toLowerCase() + "Primitive";
    }

    private String getPrimitiveArrayName(String type) {
        if ("Character".equals(type)) {
            return "primitiveCharArray";
        }
        if ("Integer".equals(type)) {
            return "primitiveIntArray";
        }
        return "primitive" + type + "Array";
    }

    private void addGlobalsToSession(KieSession kieSession, List list, Object dGlobal, Object[] dArrayGlobal) {
        kieSession.setGlobal("list", (Object)list);
        kieSession.setGlobal("nGlobal", dGlobal);
        kieSession.setGlobal("arrayGlobal", (Object)dArrayGlobal);
    }

    private void testArrayContains(KieSession kieSession, Primitives p1, Primitives p2, List resultsList) {
        FactHandle p1h = kieSession.insert((Object)p1);
        kieSession.insert((Object)p2);
        kieSession.fireAllRules();
        Assert.assertEquals((long)1L, (long)resultsList.size());
        kieSession.delete(p1h);
        kieSession.insert((Object)p1);
        kieSession.fireAllRules();
        Assert.assertEquals((long)2L, (long)resultsList.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPrimitiveArray() {
        String drl = "package org.drools.compiler\nimport " + Primitives.class.getCanonicalName() + "\nglobal java.util.List result;\n\nfunction boolean testNonEmptyArray(int[] elements) {\n   return elements != null && elements.length > 0;\n}\n\nfunction boolean isNonEmptyObjectArray(Object[] elements) {\n   return elements != null && elements.length > 0;\n}\n\nrule \"Primitive elements in function\" salience 20\n  when\n    Primitives( $elements : primitiveIntArray )\n    eval( testNonEmptyArray($elements) )\n  then\n     result.add( new Integer( $elements.length ) );\nend\n\nrule \"Primitive Array with Object in function\" salience 10\n when\n   Primitives( $sArray : arrayAttribute )\n   eval( isNonEmptyObjectArray($sArray) )\n then\n     result.add( new Integer( $sArray.length ) );\nend\n\nrule \"Test Array\" salience 0\n  when\n    Primitives( $elements : primitiveIntArray, eval(($elements != null) && ($elements.length > 0)))\n  then\n    result.add( new Integer( $elements.length ) );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"array-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession session = kbase.newKieSession();
        try {
            ArrayList result = new ArrayList();
            session.setGlobal("result", result);
            Primitives p1 = new Primitives();
            p1.setPrimitiveIntArray(new int[]{1, 2, 3});
            p1.setArrayAttribute((Object[])new String[]{"a", "b"});
            session.insert((Object)p1);
            session.fireAllRules();
            Assert.assertEquals((long)3L, (long)result.size());
            Assert.assertEquals((long)3L, (long)((Integer)result.get(0)).intValue());
            Assert.assertEquals((long)2L, (long)((Integer)result.get(1)).intValue());
            Assert.assertEquals((long)3L, (long)((Integer)result.get(2)).intValue());
        }
        finally {
            session.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArrayUsage() {
        String drl = "import " + TestParam.class.getCanonicalName() + "\nglobal java.util.List list;\n\nrule \"Intercept\"\nwhen\n    TestParam( value1 == \"extract\", $args : elements )\n    $s : String( this == $args[$s.length() - $s.length()] )\n    $s1 : String( this == $args[0] )\n    $s2 : String( this == $args[1] )\n    Integer( this == 2 ) from $args.length\n    $s3 : String( this == $args[$args.length - $args.length  + 1] )\nthen\n    delete( $s1 );  \n    delete( $s2 );  \n    list.add( $s1 ); \n    list.add( $s2 ); \nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"array-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            int N = 2;
            for (int j = 0; j < 2; ++j) {
                TestParam o = new TestParam();
                o.setValue1("extract");
                o.setElements(new Object[]{"x1_" + j, "x2_" + j});
                ksession.insert((Object)("x1_" + j));
                ksession.insert((Object)("x2_" + j));
                ksession.insert((Object)o);
                ksession.fireAllRules();
            }
            Assert.assertEquals((long)4L, (long)list.size());
            Assert.assertTrue((boolean)list.contains("x1_0"));
            Assert.assertTrue((boolean)list.contains("x1_1"));
            Assert.assertTrue((boolean)list.contains("x2_0"));
            Assert.assertTrue((boolean)list.contains("x2_1"));
        }
        finally {
            ksession.dispose();
        }
    }
}

