/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.DroolsQuery;
import org.drools.core.common.DoubleNonIndexSkipBetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.SingleBetaConstraints;
import org.drools.core.common.TripleNonIndexSkipBetaConstraints;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.CompositeObjectSinkAdapter;
import org.drools.core.reteoo.JoinNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.NotNode;
import org.drools.core.reteoo.ObjectSinkNodeList;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.ReteDumper;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.util.DroolsTestUtil;
import org.drools.core.util.Entry;
import org.drools.core.util.FastIterator;
import org.drools.core.util.index.TupleIndexHashTable;
import org.drools.core.util.index.TupleList;
import org.drools.testcoverage.common.model.Cheese;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.definition.rule.Rule;
import org.kie.api.definition.type.FactType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.Row;
import org.kie.api.runtime.rule.Variable;
import org.kie.api.runtime.rule.ViewChangedEventListener;

@RunWith(value=Parameterized.class)
public class IndexingTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public IndexingTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAlphaNodeSharing() {
        String drl = "package org.drools.compiler.test\nimport " + Person.class.getCanonicalName() + "\nrule r1\nwhen\n   Person(name == \"Mark\")\nthen\nend\nrule r2\nwhen\n   Person(name == \"Mark\", age == 40)\nthen\nend\nrule r3\nwhen\n   Person(name == \"Mark\", age == 50)\nthen\nend\nrule r4\nwhen\n   Person(name == \"John\", age == 60)\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"indexing-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        try {
            Map rules = DroolsTestUtil.rulestoMap((KieBase)kbase);
            ObjectTypeNode otn = KieUtil.getObjectTypeNode((KieBase)kbase, Person.class);
            Assert.assertNotNull((Object)otn);
            Assert.assertEquals((long)2L, (long)otn.getObjectSinkPropagator().size());
            AlphaNode a1 = (AlphaNode)otn.getObjectSinkPropagator().getSinks()[0];
            Assert.assertEquals((long)3L, (long)a1.getObjectSinkPropagator().size());
            Assert.assertEquals((long)3L, (long)a1.getAssociationsSize());
            Assert.assertTrue((boolean)a1.isAssociatedWith((Rule)rules.get("r1")));
            Assert.assertTrue((boolean)a1.isAssociatedWith((Rule)rules.get("r2")));
            Assert.assertTrue((boolean)a1.isAssociatedWith((Rule)rules.get("r3")));
            AlphaNode a2 = (AlphaNode)otn.getObjectSinkPropagator().getSinks()[1];
            Assert.assertEquals((long)1L, (long)a2.getAssociationsSize());
            Assert.assertEquals((long)1L, (long)a2.getObjectSinkPropagator().size());
            Assert.assertTrue((boolean)a2.isAssociatedWith((Rule)rules.get("r4")));
        }
        finally {
            wm.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testBuildsIndexedAlphaNodes() {
        String drl = "package org.drools.compiler.test\nimport " + Person.class.getCanonicalName() + "\nrule test1\nwhen\n   Person(name == \"Mark\", age == 37)\n   Person(name == \"Mark\", happy == true)\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"indexing-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        try {
            ObjectTypeNode otn = KieUtil.getObjectTypeNode((KieBase)kbase, Person.class);
            Assert.assertNotNull((Object)otn);
            AlphaNode alphaNode1 = (AlphaNode)otn.getObjectSinkPropagator().getSinks()[0];
            CompositeObjectSinkAdapter sinkAdapter = (CompositeObjectSinkAdapter)alphaNode1.getObjectSinkPropagator();
            ObjectSinkNodeList hashableSinks = sinkAdapter.getHashableSinks();
            Assert.assertNotNull((Object)hashableSinks);
            Assert.assertEquals((long)2L, (long)hashableSinks.size());
            AlphaNode alphaNode2 = (AlphaNode)alphaNode1.getObjectSinkPropagator().getSinks()[0];
            Assert.assertSame((Object)hashableSinks.getFirst(), (Object)alphaNode2);
            AlphaNode alphaNode3 = (AlphaNode)alphaNode1.getObjectSinkPropagator().getSinks()[1];
            Assert.assertSame((Object)hashableSinks.getLast(), (Object)alphaNode3);
        }
        finally {
            wm.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testBuildsIndexedMemory() {
        String drl = "package org.drools.compiler.test\nimport " + Person.class.getCanonicalName() + "\nglobal java.util.List list\nrule test1\nwhen\n   $p1  : Person($name : name )\n   $p2 : Person(name == $name)\n   $p3 : Person(name == $p1.name)\n   $p4 : Person(address.street == $p1.address.street)\n   $p5 : Person(address.street == $p1.name)\n   $p6 : Person(addresses[0].street == $p1.name)\n   $p7 : Person(name == $p1.address.street)\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"indexing-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        try {
            ObjectTypeNode node = KieUtil.getObjectTypeNode((KieBase)kbase, Person.class);
            Assert.assertNotNull((Object)node);
            LeftInputAdapterNode liaNode = (LeftInputAdapterNode)node.getObjectSinkPropagator().getSinks()[0];
            JoinNode j2 = (JoinNode)liaNode.getSinkPropagator().getSinks()[0];
            JoinNode j3 = (JoinNode)j2.getSinkPropagator().getSinks()[0];
            JoinNode j4 = (JoinNode)j3.getSinkPropagator().getSinks()[0];
            JoinNode j5 = (JoinNode)j4.getSinkPropagator().getSinks()[0];
            JoinNode j6 = (JoinNode)j5.getSinkPropagator().getSinks()[0];
            JoinNode j7 = (JoinNode)j6.getSinkPropagator().getSinks()[0];
            SingleBetaConstraints c = (SingleBetaConstraints)j2.getRawConstraints();
            Assert.assertTrue((boolean)c.isIndexed());
            BetaMemory bm = (BetaMemory)wm.getNodeMemory((MemoryFactory)j2);
            Assert.assertTrue((boolean)(bm.getLeftTupleMemory() instanceof TupleIndexHashTable));
            Assert.assertTrue((boolean)(bm.getRightTupleMemory() instanceof TupleIndexHashTable));
            c = (SingleBetaConstraints)j3.getRawConstraints();
            Assert.assertTrue((boolean)c.isIndexed());
            bm = (BetaMemory)wm.getNodeMemory((MemoryFactory)j3);
            Assert.assertTrue((boolean)(bm.getLeftTupleMemory() instanceof TupleIndexHashTable));
            Assert.assertTrue((boolean)(bm.getRightTupleMemory() instanceof TupleIndexHashTable));
            c = (SingleBetaConstraints)j4.getRawConstraints();
            Assert.assertFalse((boolean)c.isIndexed());
            bm = (BetaMemory)wm.getNodeMemory((MemoryFactory)j4);
            Assert.assertTrue((boolean)(bm.getLeftTupleMemory() instanceof TupleList));
            Assert.assertTrue((boolean)(bm.getRightTupleMemory() instanceof TupleList));
            c = (SingleBetaConstraints)j5.getRawConstraints();
            Assert.assertTrue((boolean)c.isIndexed());
            bm = (BetaMemory)wm.getNodeMemory((MemoryFactory)j5);
            Assert.assertTrue((boolean)(bm.getLeftTupleMemory() instanceof TupleIndexHashTable));
            Assert.assertTrue((boolean)(bm.getRightTupleMemory() instanceof TupleIndexHashTable));
            c = (SingleBetaConstraints)j6.getRawConstraints();
            Assert.assertTrue((boolean)c.isIndexed());
            bm = (BetaMemory)wm.getNodeMemory((MemoryFactory)j6);
            Assert.assertTrue((boolean)(bm.getLeftTupleMemory() instanceof TupleIndexHashTable));
            Assert.assertTrue((boolean)(bm.getRightTupleMemory() instanceof TupleIndexHashTable));
            c = (SingleBetaConstraints)j7.getRawConstraints();
            Assert.assertFalse((boolean)c.isIndexed());
            bm = (BetaMemory)wm.getNodeMemory((MemoryFactory)j7);
            Assert.assertTrue((boolean)(bm.getLeftTupleMemory() instanceof TupleList));
            Assert.assertTrue((boolean)(bm.getRightTupleMemory() instanceof TupleList));
        }
        finally {
            wm.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testIndexingOnQueryUnification() {
        String drl = "package org.drools.compiler.test  \nimport " + Person.class.getCanonicalName() + "\nquery peeps( String $name, String $likes, String $street) \n    $p : Person( $name := name, $likes := likes, $street := address.street ) \nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"indexing-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        InternalWorkingMemory wm = (InternalWorkingMemory)kbase.newKieSession();
        try {
            List nodes = ((KnowledgeBaseImpl)kbase).getRete().getObjectTypeNodes();
            ObjectTypeNode node = null;
            for (ObjectTypeNode n : nodes) {
                if (((ClassObjectType)n.getObjectType()).getClassType() != DroolsQuery.class) continue;
                node = n;
                break;
            }
            Assert.assertNotNull(node);
            AlphaNode alphanode = (AlphaNode)node.getObjectSinkPropagator().getSinks()[0];
            LeftInputAdapterNode liaNode = (LeftInputAdapterNode)alphanode.getObjectSinkPropagator().getSinks()[0];
            JoinNode j = (JoinNode)liaNode.getSinkPropagator().getSinks()[0];
            TripleNonIndexSkipBetaConstraints c = (TripleNonIndexSkipBetaConstraints)j.getRawConstraints();
            Assert.assertTrue((boolean)c.isIndexed());
            BetaMemory bm = (BetaMemory)wm.getNodeMemory((MemoryFactory)j);
            Assert.assertTrue((boolean)(bm.getLeftTupleMemory() instanceof TupleIndexHashTable));
            Assert.assertTrue((boolean)(bm.getRightTupleMemory() instanceof TupleIndexHashTable));
        }
        finally {
            wm.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testIndexingOnQueryUnificationWithNot() {
        String drl = "package org.drools.compiler.test  \nimport " + Person.class.getCanonicalName() + "\nquery peeps( String $name, int $age ) \n    not $p2 : Person( $name := name, age > $age ) \nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"indexing-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        StatefulKnowledgeSessionImpl wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        ReteDumper.dumpRete((KieSession)wm);
        try {
            InternalFactHandle fh;
            Person p;
            int i;
            List nodes = ((KnowledgeBaseImpl)kbase).getRete().getObjectTypeNodes();
            ObjectTypeNode node = null;
            for (ObjectTypeNode n : nodes) {
                if (((ClassObjectType)n.getObjectType()).getClassType() != DroolsQuery.class) continue;
                node = n;
                break;
            }
            Assert.assertNotNull(node);
            AlphaNode alphanode = (AlphaNode)node.getObjectSinkPropagator().getSinks()[0];
            LeftInputAdapterNode liaNode = (LeftInputAdapterNode)alphanode.getObjectSinkPropagator().getSinks()[0];
            NotNode n = (NotNode)liaNode.getSinkPropagator().getSinks()[0];
            DoubleNonIndexSkipBetaConstraints c = (DoubleNonIndexSkipBetaConstraints)n.getRawConstraints();
            Assert.assertTrue((boolean)c.isIndexed());
            BetaMemory bm = (BetaMemory)wm.getNodeMemory((MemoryFactory)n);
            Assert.assertTrue((boolean)(bm.getLeftTupleMemory() instanceof TupleIndexHashTable));
            Assert.assertTrue((boolean)(bm.getRightTupleMemory() instanceof TupleIndexHashTable));
            final HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("inserted", 0);
            map.put("deleted", 0);
            map.put("updated", 0);
            wm.openLiveQuery("peeps", new Object[]{Variable.v, 99}, new ViewChangedEventListener(){

                public void rowInserted(Row row) {
                    Integer integer = (Integer)map.get("inserted");
                    map.put("inserted", integer + 1);
                }

                public void rowDeleted(Row row) {
                    Integer integer = (Integer)map.get("deleted");
                    map.put("deleted", integer + 1);
                }

                public void rowUpdated(Row row) {
                    Integer integer = (Integer)map.get("updated");
                    map.put("updated", integer + 1);
                }
            });
            HashMap<String, InternalFactHandle> peeps = new HashMap<String, InternalFactHandle>();
            int max = 3;
            this.assertInsertedUpdatedDeleted(map, 1, 0, 0);
            for (i = 0; i < 3; ++i) {
                p = new Person("x" + i, 100);
                fh = (InternalFactHandle)wm.insert((Object)p);
                wm.fireAllRules();
                peeps.put(p.getName(), fh);
            }
            this.assertInsertedUpdatedDeleted(map, 1, 0, 1);
            for (i = 0; i < 2; ++i) {
                fh = (InternalFactHandle)peeps.get("x" + i);
                p = (Person)fh.getObject();
                p.setAge(90);
                wm.update((FactHandle)fh, (Object)p);
                wm.fireAllRules();
                Assert.assertEquals((String)("i=" + i), (long)1L, (long)((Integer)map.get("inserted")).intValue());
            }
            this.assertInsertedUpdatedDeleted(map, 1, 0, 1);
            for (i = 0; i < 2; ++i) {
                fh = (InternalFactHandle)peeps.get("x" + i);
                p = (Person)fh.getObject();
                p.setAge(102);
                wm.update((FactHandle)fh, (Object)p);
                wm.fireAllRules();
                Assert.assertEquals((String)("i=" + i), (long)1L, (long)((Integer)map.get("inserted")).intValue());
            }
            this.assertInsertedUpdatedDeleted(map, 1, 0, 1);
            for (i = 1; i >= 0; --i) {
                fh = (InternalFactHandle)peeps.get("x" + i);
                p = (Person)fh.getObject();
                p.setAge(90);
                wm.update((FactHandle)fh, (Object)p);
                wm.fireAllRules();
                Assert.assertEquals((String)("i=" + i), (long)1L, (long)((Integer)map.get("inserted")).intValue());
            }
            fh = (InternalFactHandle)peeps.get("x2");
            p = (Person)fh.getObject();
            p.setAge(90);
            wm.update((FactHandle)fh, (Object)p);
            wm.fireAllRules();
            Assert.assertEquals((long)2L, (long)((Integer)map.get("inserted")).intValue());
        }
        finally {
            wm.dispose();
        }
    }

    private void assertInsertedUpdatedDeleted(Map<String, Integer> insertUpdateDeleteMap, int expectedInserted, int expectedUpdated, int expectedDeleted) {
        Assert.assertEquals((long)expectedInserted, (long)insertUpdateDeleteMap.get("inserted").intValue());
        Assert.assertEquals((long)expectedUpdated, (long)insertUpdateDeleteMap.get("updated").intValue());
        Assert.assertEquals((long)expectedDeleted, (long)insertUpdateDeleteMap.get("deleted").intValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testFullFastIteratorResume() {
        String drl = "package org.drools.compiler.test  \nimport " + Person.class.getCanonicalName() + "\nquery peeps( String $name, int $age ) \n    not $p2 : Person( $name := name, age > $age ) \nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"indexing-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        StatefulKnowledgeSessionImpl wm = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        try {
            List nodes = ((KnowledgeBaseImpl)kbase).getRete().getObjectTypeNodes();
            ObjectTypeNode node = null;
            for (ObjectTypeNode n : nodes) {
                if (((ClassObjectType)n.getObjectType()).getClassType() != DroolsQuery.class) continue;
                node = n;
                break;
            }
            Assert.assertNotNull(node);
            AlphaNode alphanode = (AlphaNode)node.getObjectSinkPropagator().getSinks()[0];
            LeftInputAdapterNode liaNode = (LeftInputAdapterNode)alphanode.getObjectSinkPropagator().getSinks()[0];
            NotNode n = (NotNode)liaNode.getSinkPropagator().getSinks()[0];
            DoubleNonIndexSkipBetaConstraints c = (DoubleNonIndexSkipBetaConstraints)n.getRawConstraints();
            Assert.assertTrue((boolean)c.isIndexed());
            BetaMemory bm = (BetaMemory)wm.getNodeMemory((MemoryFactory)n);
            Assert.assertTrue((boolean)(bm.getLeftTupleMemory() instanceof TupleIndexHashTable));
            Assert.assertTrue((boolean)(bm.getRightTupleMemory() instanceof TupleIndexHashTable));
            wm.openLiveQuery("peeps", new Object[]{Variable.v, 99}, new ViewChangedEventListener(){

                public void rowInserted(Row row) {
                }

                public void rowDeleted(Row row) {
                }

                public void rowUpdated(Row row) {
                }
            });
            Person p = new Person("x0", 100);
            wm.insert((Object)p);
            for (int i = 1; i < 100; ++i) {
                p = new Person("x" + i, 101);
                wm.insert((Object)p);
                wm.fireAllRules();
            }
            ArrayList<RightTuple> list = new ArrayList<RightTuple>(100);
            FastIterator it = n.getRightIterator(bm.getRightTupleMemory());
            RightTuple rt = n.getFirstRightTuple(null, bm.getRightTupleMemory(), null, it);
            while (rt != null) {
                list.add(rt);
                rt = (RightTuple)it.next((Entry)rt);
            }
            Assert.assertEquals((long)100L, (long)list.size());
            for (int i = 0; i < 100; ++i) {
                RightTuple rightTuple = (RightTuple)list.get(i);
                it = n.getRightIterator(bm.getRightTupleMemory(), rightTuple);
                int j = i + 1;
                RightTuple rt2 = (RightTuple)it.next((Entry)rightTuple);
                while (rt2 != null) {
                    Assert.assertSame(list.get(j), (Object)rt2);
                    ++j;
                    rt2 = (RightTuple)it.next((Entry)rt2);
                }
            }
        }
        finally {
            wm.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testRangeIndex() {
        String drl = "import " + Cheese.class.getCanonicalName() + ";\nrule R1\nwhen\n   $s : String()   exists Cheese( type > $s )\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"indexing-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.insert((Object)"cheddar");
            ksession.insert((Object)"gorgonzola");
            ksession.insert((Object)"stilton");
            ksession.insert((Object)new Cheese("gorgonzola", 10));
            Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testRangeIndex2() {
        String drl = "import " + Cheese.class.getCanonicalName() + ";\nrule R1\nwhen\n   $s : String()   exists Cheese( type < $s )\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"indexing-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.insert((Object)"gorgonzola");
            ksession.insert((Object)new Cheese("cheddar", 10));
            ksession.insert((Object)new Cheese("gorgonzola", 10));
            ksession.insert((Object)new Cheese("stilton", 10));
            Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testNotNode() {
        String drl = "import " + Cheese.class.getCanonicalName() + ";\nimport " + Person.class.getCanonicalName() + ";\nrule R1 salience 10\nwhen\n   Person( $age : age )   not Cheese( price < $age )\nthen\nend\nrule R2 salience 1\nwhen\n   $p : Person( age == 10 )then\n   modify($p) { setAge(15); }\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"indexing-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.insert((Object)new Person("mario", 10));
            ksession.insert((Object)new Cheese("gorgonzola", 20));
            Assert.assertEquals((long)3L, (long)ksession.fireAllRules());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testNotNodeModifyRight() {
        String drl = "import " + Cheese.class.getCanonicalName() + ";\nimport " + Person.class.getCanonicalName() + ";\nrule R1 salience 10 when\n   Person( $age : age )\n   not Cheese( price < $age )\nthen\nend\nrule R3 salience 5 when\n   $c : Cheese( price == 8 )\nthen\n   modify($c) { setPrice(15); }\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"indexing-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.insert((Object)new Person("A", 10));
            ksession.insert((Object)new Cheese("C1", 20));
            ksession.insert((Object)new Cheese("C2", 8));
            Assert.assertEquals((long)2L, (long)ksession.fireAllRules());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testRange() {
        String drl = "import " + Cheese.class.getCanonicalName() + ";\nimport " + Person.class.getCanonicalName() + ";\nrule R1 salience 10 when\n   Person( $age : age, $doubleAge : doubleAge )\n   not Cheese( price > $age && < $doubleAge )\nthen\nend\nrule R3 salience 5 when\n   $c : Cheese( price == 15 )\nthen\n   modify($c) { setPrice(8); }\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"indexing-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.insert((Object)new Person("A", 10));
            ksession.insert((Object)new Cheese("C1", 30));
            ksession.insert((Object)new Cheese("C2", 15));
            Assert.assertEquals((long)2L, (long)ksession.fireAllRules());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testRange2() throws IllegalAccessException, InstantiationException {
        String drl = "package org.drools.compiler.test\ndeclare A\n    a: int\nend\ndeclare B\n    b: int\nend\ndeclare C\n    c: int\nend\nrule R1 when\n   A( $a : a )\n   B( $b : b )\n   exists C( c > $a && < $b )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"indexing-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler.test\ndeclare A\n    a: int\nend\ndeclare B\n    b: int\nend\ndeclare C\n    c: int\nend\nrule R1 when\n   A( $a : a )\n   B( $b : b )\n   exists C( c > $a && < $b )\nthen\nend"});
        KieSession ksession = kbase.newKieSession();
        try {
            FactType aType = kbase.getFactType("org.drools.compiler.test", "A");
            FactType bType = kbase.getFactType("org.drools.compiler.test", "B");
            FactType cType = kbase.getFactType("org.drools.compiler.test", "C");
            Object a1 = aType.newInstance();
            aType.set(a1, "a", (Object)5);
            ksession.insert(a1);
            Object a2 = aType.newInstance();
            aType.set(a2, "a", (Object)11);
            ksession.insert(a2);
            Object b1 = bType.newInstance();
            bType.set(b1, "b", (Object)10);
            ksession.insert(b1);
            Object b2 = bType.newInstance();
            bType.set(b2, "b", (Object)6);
            ksession.insert(b2);
            Object c = cType.newInstance();
            cType.set(c, "c", (Object)7);
            ksession.insert(c);
            ksession.fireAllRules();
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHashingAfterRemoveRightTuple() {
        String drl = "package " + this.getClass().getPackage().getName() + ";\nimport " + MyPojo.class.getCanonicalName() + "\nglobal java.util.List list;\nrule R1\nwhen\n    $my: MyPojo(\n        vBoolean == true,\n        $s : vString != \"y\",\n        $l : vLong\n    )\n    not MyPojo(\n        vBoolean == true,\n        vString == $s,\n        vLong != $l\n    )\nthen\n    list.add($my.getName());\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"indexing-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession session = kbase.newKieSession();
        try {
            ArrayList check = new ArrayList();
            session.setGlobal("list", check);
            MyPojo a = new MyPojo("A", true, "x", 0L);
            MyPojo b = new MyPojo("B", true, "x", 7L);
            MyPojo c = new MyPojo("C", false, "y", 7L);
            session.insert((Object)a);
            FactHandle fh_b = session.insert((Object)b);
            FactHandle fh_c = session.insert((Object)c);
            session.fireAllRules();
            Assert.assertFalse((boolean)check.contains("A"));
            c.setVBoolean(true);
            c.setVString("x");
            session.update(fh_c, (Object)c);
            b.setVBoolean(false);
            b.setVString("y");
            session.update(fh_b, (Object)b);
            session.fireAllRules();
            Assert.assertFalse((boolean)check.contains("A"));
        }
        finally {
            session.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRequireLeftReorderingWithRangeIndex() {
        String drl = "import " + Queen.class.getCanonicalName() + ";\nrule \"multipleQueensHorizontal\"\nwhen\n    Queen($id : id, row != null, $i : rowIndex)\n    Queen(id > $id, rowIndex == $i)\nthen\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"indexing-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession kieSession = kbase.newKieSession();
        try {
            Queen queen1 = new Queen(1);
            Queen queen2 = new Queen(2);
            Integer row1 = 1;
            Integer row2 = 2;
            FactHandle fq1 = kieSession.insert((Object)queen1);
            FactHandle fq2 = kieSession.insert((Object)queen2);
            Assert.assertEquals((long)0L, (long)kieSession.fireAllRules());
            kieSession.update(fq1, (Object)queen1.setRow(row1));
            Assert.assertEquals((long)0L, (long)kieSession.fireAllRules());
            kieSession.update(fq1, (Object)queen1.setRow(row2));
            Assert.assertEquals((long)0L, (long)kieSession.fireAllRules());
            kieSession.update(fq2, (Object)queen2.setRow(row2));
            Assert.assertEquals((long)1L, (long)kieSession.fireAllRules());
        }
        finally {
            kieSession.dispose();
        }
    }

    public static class Queen {
        private final int id;
        private Integer row;

        public Queen(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public Integer getRow() {
            return this.row;
        }

        public Queen setRow(Integer row) {
            this.row = row;
            return this;
        }

        public int getRowIndex() {
            if (this.row == null) {
                return Integer.MIN_VALUE;
            }
            return this.row;
        }
    }

    public static class MyPojo {
        private final String name;
        private boolean vBoolean;
        private String vString;
        private long vLong;

        public MyPojo(String name, boolean vBoolean, String vString, long vLong) {
            this.name = name;
            this.vBoolean = vBoolean;
            this.vString = vString;
            this.vLong = vLong;
        }

        public String getName() {
            return this.name;
        }

        public boolean isVBoolean() {
            return this.vBoolean;
        }

        public String getVString() {
            return this.vString;
        }

        public long getVLong() {
            return this.vLong;
        }

        public void setVBoolean(boolean vBoolean) {
            this.vBoolean = vBoolean;
        }

        public void setVString(String vString) {
            this.vString = vString;
        }

        public void setVLong(long vLong) {
            this.vLong = vLong;
        }

        public String toString() {
            return "MyPojo: " + this.name;
        }
    }
}

