/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.operators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.drools.testcoverage.common.model.MyFact;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.ReleaseId;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class EnabledTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public EnabledTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEnabledExpression() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport " + Person.class.getCanonicalName() + ";\nglobal java.util.List results;\n\nrule \"Test enabled expression 1\"\n    @ruleID(1234)\n    // arbitrary expression using a rule metadata\n    enabled ( rule.metaData[\"ruleID\"] == \"1234\" )\n  when\n    Person(name == \"Michael\")\n  then\n    results.add( \"1\" );\nend\n\nrule \"Test enabled expression 2\"\n    @ruleID(1234)\n    // using bound variables\n    enabled ( \"Michael\".equals( $name ) )\n  when\n    Person( $name : name )\n  then\n    results.add( \"2\" );\nend\n\nrule \"Test enabled expression 3\"\n    @ruleID(1234)\n    // using simple expressions\n    enabled ( 1 + 1 == 2 )\n  when\n    Person( $name : name )\n  then\n    results.add( \"3\" );\nend\n\nrule \"Test enabled expression 4\"\n    @ruleID(1234)\n    // using a false expression\n    enabled ( 1 + 1 == 5 )\n  when\n    Person( $name : name )\n  then\n    results.add( \"4\" );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"enabled-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession session = kbase.newKieSession();
        try {
            List results = new ArrayList();
            session.setGlobal("results", results);
            session.insert((Object)new Person("Michael"));
            results = (List)session.getGlobal("results");
            session.fireAllRules();
            Assert.assertEquals((long)3L, (long)results.size());
            Assert.assertTrue((boolean)results.contains("1"));
            Assert.assertTrue((boolean)results.contains("2"));
            Assert.assertTrue((boolean)results.contains("3"));
        }
        finally {
            session.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEnabledExpression2() {
        String drl = "import " + MyFact.class.getName() + ";\nrule R1\n    enabled( rule.name == $f.name )when\n   $f : MyFact()\nthen end\nrule R2\nwhen\n   MyFact( name == \"R2\" )\nthen end\n";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "test-enabled", "1.0.0");
        KieModule km = KieUtil.getKieModuleFromDrls((ReleaseId)releaseId1, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieContainer kc = ks.newKieContainer(km.getReleaseId());
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        KieSession ksession = kc.newKieSession();
        try {
            ksession.addEventListener(ael);
            ksession.insert((Object)new MyFact("R1", null));
            Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
            ksession.dispose();
            ArgumentCaptor event = ArgumentCaptor.forClass(AfterMatchFiredEvent.class);
            ((AgendaEventListener)Mockito.verify((Object)ael)).afterMatchFired((AfterMatchFiredEvent)event.capture());
            Assert.assertEquals((Object)"R1", (Object)((AfterMatchFiredEvent)event.getValue()).getMatch().getRule().getName());
            ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
            ksession.dispose();
            ksession = kc.newKieSession();
            ksession.addEventListener(ael);
            ksession.insert((Object)new MyFact("R2", null));
            Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
            ksession.dispose();
            event = ArgumentCaptor.forClass(AfterMatchFiredEvent.class);
            ((AgendaEventListener)Mockito.verify((Object)ael)).afterMatchFired((AfterMatchFiredEvent)event.capture());
            Assert.assertEquals((Object)"R2", (Object)((AfterMatchFiredEvent)event.getValue()).getMatch().getRule().getName());
        }
        finally {
            ksession.dispose();
        }
    }
}

