/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.util.Collection;
import java.util.HashSet;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class AlphaNodeSharingWithDiffPackageNameTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private static final String rule1 = "package com.test.rule1;\r\n\r\nimport " + TypeA.class.getCanonicalName() + ";\r\nimport " + TypeB.class.getCanonicalName() + ";\r\nimport " + TypeC.class.getCanonicalName() + ";\r\n           \r\nrule R1\r\nwhen\r\n   $c : TypeC()\r\n   $b : TypeB(parentId == $c.Id)\r\n   $a : TypeA( parentId == $b.Id, firings not contains \"R1 Fired\")\r\nthen\r\n   $a.setAlphaNode(\"value contains TypeD TypeE data type\");\r\n   $a.getFirings().add(\"R1 Fired\");\r\n   update($a);\r\nend";
    private static final String rule2 = "package com.test.rule2;\r\n\r\nimport " + TypeA.class.getCanonicalName() + ";\r\nimport " + TypeB.class.getCanonicalName() + ";\r\nimport " + TypeC.class.getCanonicalName() + ";\r\n\r\nrule R2 \r\nwhen\r\n   $c : TypeC()\r\n   $b : TypeB(parentId == $c.Id)\r\n   $a : TypeA(parentId == $b.Id, \r\n               alphaNode==\"value contains TypeD TypeE data type\", \r\n               firings not contains \"R2 Fired\")\r\nthen\r\n       $a.getFirings().add(\"R2 Fired\");\r\n       update($a);\r\nend";
    private static final String rule3 = "package com.test.rule3;\r\n\r\nimport " + TypeA.class.getCanonicalName() + ";\r\nimport " + TypeB.class.getCanonicalName() + ";\r\nimport " + TypeC.class.getCanonicalName() + ";\r\nimport " + TypeD.class.getCanonicalName() + ";\r\n\r\nrule R3 \r\nwhen\r\n   $d : TypeD()\r\n   $c : TypeC()\r\n   $b : TypeB(parentId == $c.Id)\r\n   $a : TypeA( parentId == $b.Id,\r\n               alphaNode==\"value contains TypeD TypeE data type\", \r\n               firings not contains \"R3 Fired\")\r\nthen\r\n   $a.getFirings().add(\"R3 Fired\");\r\n   update($a);\r\nend;";
    private static final String rule4 = "package com.test.rule4;\r\n\r\nimport " + TypeA.class.getCanonicalName() + ";\r\nimport " + TypeB.class.getCanonicalName() + ";\r\nimport " + TypeC.class.getCanonicalName() + ";\r\nimport " + TypeE.class.getCanonicalName() + ";\r\n\r\nrule R4 \r\nwhen\r\n   $e : TypeE()\r\n   $c : TypeC()\r\n   $b : TypeB(parentId == $c.Id)\r\n   $a : TypeA( parentId == $b.Id,\r\n               alphaNode==\"value contains TypeD TypeE data type\", \r\n               firings not contains \"R4 Fired\")\r\nthen\r\n   $a.getFirings().add(\"R4 Fired\");\r\n   update($a);\r\nend;";

    public AlphaNodeSharingWithDiffPackageNameTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAlphaNode() {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"alpha-node-sharing-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{rule1, rule2, rule3, rule4});
        KieSession ksession = kbase.newKieSession();
        try {
            TypeC c = new TypeC();
            TypeB b = new TypeB();
            TypeA a = new TypeA();
            TypeD d = new TypeD();
            TypeE e = new TypeE();
            ksession.insert((Object)a);
            ksession.insert((Object)b);
            ksession.insert((Object)c);
            ksession.insert((Object)d);
            ksession.insert((Object)e);
            ksession.fireAllRules();
            Assert.assertTrue((boolean)a.getFirings().contains("R1 Fired"));
            Assert.assertTrue((boolean)a.getFirings().contains("R2 Fired"));
            Assert.assertTrue((boolean)a.getFirings().contains("R3 Fired"));
            Assert.assertTrue((boolean)a.getFirings().contains("R4 Fired"));
        }
        finally {
            ksession.dispose();
        }
    }

    public static class TypeE {
    }

    public static class TypeD {
    }

    public static class TypeC {
        private final int parentId = 0;
        private final int id = 1;

        public int getParentId() {
            return 0;
        }

        public int getId() {
            return 1;
        }
    }

    public static class TypeB {
        private final int parentId = 1;
        private final int id = 2;

        public int getParentId() {
            return 1;
        }

        public int getId() {
            return 2;
        }
    }

    public static class TypeA {
        private final int parentId = 2;
        private final int id = 3;
        private String alphaNode;
        private HashSet<String> firings = new HashSet();
        private final String data = "AlphaNodeHashingThreshold Data";

        public int getParentId() {
            return 2;
        }

        public int getId() {
            return 3;
        }

        public HashSet<String> getFirings() {
            if (this.firings == null) {
                this.firings = new HashSet();
            }
            return this.firings;
        }

        public void setFirings(HashSet<String> x) {
            this.firings = x;
        }

        public String getData() {
            return "AlphaNodeHashingThreshold Data";
        }

        public String getAlphaNode() {
            return this.alphaNode;
        }

        public void setAlphaNode(String alphaNode) {
            this.alphaNode = alphaNode;
        }
    }
}

