/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.operators;

import java.util.ArrayList;
import java.util.Collection;
import org.drools.testcoverage.common.model.AFact;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

@RunWith(value=Parameterized.class)
public class NotTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public NotTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLastMemoryEntryNotBug() {
        String drl = "package org.drools.compiler.integrationtests.operators \nimport " + AFact.class.getCanonicalName() + "\nglobal java.util.List list \nrule x1 \nwhen \n    $s : String( this == 'x1' ) \n    not AFact( this != null ) \nthen \n  list.add(\"fired x1\"); \nend  \nrule x2 \nwhen \n    $s : String( this == 'x2' ) \n    not AFact( field1 == $s, this != null ) \nthen \n  list.add(\"fired x2\"); \nend  \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"not-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.insert((Object)"x1");
            ksession.insert((Object)"x2");
            AFact a1 = new AFact("x1", null);
            AFact a2 = new AFact("x2", null);
            FactHandle fa1 = ksession.insert((Object)a1);
            FactHandle fa2 = ksession.insert((Object)a2);
            ksession.update(fa1, (Object)a1);
            ksession.update(fa2, (Object)a2);
            ksession.fireAllRules();
            Assert.assertEquals((long)0L, (long)list.size());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNegatedConstaintInNot() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport " + Person.class.getCanonicalName() + ";\n\nrule R1 when\n    not( Person( !(age > 18) ) )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"negated-not-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.insert((Object)new Person("Mario", 45));
            Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        }
        finally {
            ksession.dispose();
        }
    }
}

