/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.drl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.model.Cheese;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.builder.KieBuilder;
import org.kie.api.event.rule.ObjectUpdatedEvent;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
public class BindTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public BindTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFactBindings() {
        String drl = "package org.drools.compiler.integrationtests.drl;\nimport " + Cheese.class.getCanonicalName() + ";\nimport " + Person.class.getCanonicalName() + ";\n \nrule \"simple rule\"\n    no-loop true\n    when\n        $person : Person( name == \"big cheese\", $cheese : cheese )\n    then\n        update( $cheese );\n        update( $person );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"bind-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            RuleRuntimeEventListener wmel = (RuleRuntimeEventListener)Mockito.mock(RuleRuntimeEventListener.class);
            ksession.addEventListener(wmel);
            Person bigCheese = new Person("big cheese");
            Cheese cheddar = new Cheese("cheddar", 15);
            bigCheese.setCheese(cheddar);
            FactHandle bigCheeseHandle = ksession.insert((Object)bigCheese);
            FactHandle cheddarHandle = ksession.insert((Object)cheddar);
            ksession.fireAllRules();
            ArgumentCaptor arg = ArgumentCaptor.forClass(ObjectUpdatedEvent.class);
            ((RuleRuntimeEventListener)Mockito.verify((Object)wmel, (VerificationMode)Mockito.times((int)2))).objectUpdated((ObjectUpdatedEvent)arg.capture());
            ObjectUpdatedEvent event = (ObjectUpdatedEvent)arg.getAllValues().get(0);
            Assert.assertSame((Object)cheddarHandle, (Object)event.getFactHandle());
            Assert.assertSame((Object)cheddar, (Object)event.getOldObject());
            Assert.assertSame((Object)cheddar, (Object)event.getObject());
            event = (ObjectUpdatedEvent)arg.getAllValues().get(1);
            Assert.assertSame((Object)bigCheeseHandle, (Object)event.getFactHandle());
            Assert.assertSame((Object)bigCheese, (Object)event.getOldObject());
            Assert.assertSame((Object)bigCheese, (Object)event.getObject());
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testBindingToMissingField() {
        String drl = "package org.drools.compiler.integrationtests.drl;\nrule rule1\nwhen\n    Integer( $i : noSuchField ) \n    eval( $i > 0 )\nthen \nend\n";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{"package org.drools.compiler.integrationtests.drl;\nrule rule1\nwhen\n    Integer( $i : noSuchField ) \n    eval( $i > 0 )\nthen \nend\n"});
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).isNotEmpty();
    }

    @Test
    public void testFieldBindingOnWrongFieldName() {
        String drl = "package org.drools.compiler.integrationtests.drl;\nimport " + Person.class.getCanonicalName() + ";\nglobal java.util.List mlist\nrule rule1 \nwhen\n   Person( $f : invalidFieldName, eval( $f != null ) )\nthen\nend\n";
        this.testBingWrongFieldName(drl);
        drl = "package org.drools.compiler.integrationtests.drl;\nimport " + Person.class.getCanonicalName() + ";\nglobal java.util.List mlist\nrule rule1 \nwhen\n   Person( $f : invalidFieldName, name == ( $f ) )\nthen\nend\n";
        this.testBingWrongFieldName(drl);
    }

    private void testBingWrongFieldName(String drl) {
        try {
            KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl});
            Assertions.assertThat((List)kieBuilder.getResults().getMessages()).isNotEmpty();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Exception should not be thrown ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBindingsOnConnectiveExpressions() {
        String drl = "package org.drools.compiler.integrationtests.drl;\nimport " + Cheese.class.getCanonicalName() + ";\nglobal java.util.List results;\nrule \"bindings\"\nwhen\n    Cheese( $p : price, $t : type, type == \"stilton\" || price == 10 )\nthen\n    results.add( $t );\n    results.add( new Integer( $p ) );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"bind-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            ksession.setGlobal("results", results);
            ksession.insert((Object)new Cheese("stilton", 15));
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)results.size());
            Assert.assertEquals((Object)"stilton", results.get(0));
            Assert.assertEquals((Object)15, results.get(1));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAutomaticBindings() {
        String drl = "package org.drools.compiler.integrationtests.drl;\nimport " + Cheese.class.getCanonicalName() + ";\nimport " + Person.class.getCanonicalName() + ";\nglobal java.util.List results;\nrule \"test auto bindings 1\"\nwhen\n    $p : Person();\n    $c : Cheese( type == $p.likes, price == $c.price  )\nthen\n    results.add( $p );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"bind-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("results", list);
            Person bob = new Person("bob");
            bob.setLikes("stilton");
            Cheese stilton = new Cheese("stilton", 12);
            ksession.insert((Object)bob);
            ksession.insert((Object)stilton);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((Object)bob, list.get(0));
        }
        finally {
            ksession.dispose();
        }
    }
}

