/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import org.drools.testcoverage.common.model.Cheese;
import org.drools.testcoverage.common.model.Cheesery;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.conf.ShareAlphaNodesOption;

@RunWith(value=Parameterized.class)
public class AlphaTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public AlphaTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAlphaExpression() {
        String drl = "package org.drools.compiler\nimport " + Person.class.getCanonicalName() + ";\nrule \"alpha\"\nwhen\n    Person( 5 < 6 )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"alpha-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.insert((Object)new Person("mark", 50));
            int rules = ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)rules);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAlphaNodeSharing() {
        String drl = "package org.drools.compiler\nimport " + Person.class.getCanonicalName() + ";\nglobal java.util.List results;\n\nrule \"First\"\nsalience 10\n when\n  c: Person(age <= 10)\n then\n  results.add(\"1\");\nend\n \nrule \"Second\"\nsalience 5\n when\n     c: Person(age <= 10)\n then\n  results.add(\"2\");\nend ";
        this.kieBaseTestConfiguration.setAdditionalKieBaseOptions(new KieBaseOption[]{ShareAlphaNodesOption.YES});
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"alpha-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            ksession.setGlobal("results", results);
            Person p1 = new Person("bob", 5);
            ksession.insert((Object)p1);
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)results.size());
            Assert.assertEquals((Object)"1", results.get(0));
            Assert.assertEquals((Object)"2", results.get(1));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAlphaCompositeConstraints() {
        String drl = "package org.drools.compiler\nimport " + Person.class.getCanonicalName() + ";\nglobal java.util.List results;\n\nrule \"test alpha composite constraints\"\nwhen\n    Person( eval( age == 25 ) || ( eval( name.equals( \"bob\" ) ) && eval( age == 30 ) ) )\nthen\n    results.add( \"OK\" );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"alpha-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("results", list);
            Person bob = new Person("bob", 30);
            ksession.insert((Object)bob);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAlphaHashingWithConstants() {
        String drl = "import " + Person.class.getName() + ";\nrule R1 when\n   $p : Person( age == 38 )\nthen end\nrule R2 when\n   $p : Person( age == 37+1 )\nthen end\nrule R3 when\n   $p : Person( age == 36+2 )\nthen end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"alpha-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.insert((Object)new Person("Mario", 38));
            Assert.assertEquals((long)3L, (long)ksession.fireAllRules());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNPEOnMVELAlphaPredicates() {
        String drl = "package org.drools.compiler\nimport " + Cheese.class.getCanonicalName() + ";\nimport " + Person.class.getCanonicalName() + ";\nglobal java.util.List results;\n\nrule \"test NPE on mvel predicate\"\nwhen\n    $p : Person( cheese.type != null )\n    $q : Cheese( ) from $p.cheese\nthen\n    results.add( $q );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"alpha-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession session = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            session.setGlobal("results", list);
            Cheese cheese = new Cheese("stilton", 10);
            Cheesery cheesery = new Cheesery();
            cheesery.addCheese(cheese);
            Person bob = new Person("bob", "stilton");
            Cheese cheese2 = new Cheese();
            bob.setCheese(cheese2);
            FactHandle p = session.insert((Object)bob);
            session.insert((Object)cheesery);
            session.fireAllRules();
            Assert.assertEquals((String)"should not have fired", (long)0L, (long)list.size());
            cheese2.setType("stilton");
            session.update(p, (Object)bob);
            session.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
        }
        finally {
            session.dispose();
        }
    }
}

