/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.operators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.drools.core.common.InternalFactHandle;
import org.drools.testcoverage.common.model.Cheese;
import org.drools.testcoverage.common.model.FactA;
import org.drools.testcoverage.common.model.FactB;
import org.drools.testcoverage.common.model.Order;
import org.drools.testcoverage.common.model.OrderItem;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.builder.KieBuilder;
import org.kie.api.definition.type.FactType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

@RunWith(value=Parameterized.class)
public class OrTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public OrTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOr() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport " + Cheese.class.getCanonicalName() + ";\nglobal java.util.List list;\n\nrule \"literal test rule\"\n    when\n        Cheese(type == \"stilton\" ) or Cheese(type == \"cheddar\")\n    then\n        list.add(\"got cheese\");\nend   \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"or-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession session = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            session.setGlobal("list", list);
            Cheese cheddar = new Cheese("cheddar", 5);
            FactHandle h = session.insert((Object)cheddar);
            session.fireAllRules();
            Assert.assertEquals((Object)"got cheese", list.get(0));
            Assert.assertEquals((long)1L, (long)list.size());
            session.delete(h);
            session.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            session.insert((Object)new Cheese("stilton", 5));
            session.fireAllRules();
            Assert.assertEquals((long)2L, (long)((List)session.getGlobal("list")).size());
        }
        finally {
            session.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrCE() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport " + Cheese.class.getCanonicalName() + ";\nimport " + Person.class.getCanonicalName() + ";\nglobal java.util.List results;\nrule \"test or CE\"\nwhen\n    $c : Cheese( type == \"stilton\" )\n    or\n    (\n        $c2 : Cheese( type == \"brie\" )\n        and\n        (\n            $p : Person( likes == \"stilton\" )\n            or\n            $p : Person( name == \"bob\" )\n        )\n    ) \nthen\n    results.add(\" OK \" );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"or-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("results", list);
            ksession.insert((Object)new Cheese("brie", 10));
            ksession.insert((Object)new Person("bob"));
            ksession.fireAllRules();
            Assert.assertEquals((String)"should have fired once", (long)1L, (long)list.size());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrCEFollowedByEval() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport " + FactA.class.getCanonicalName() + ";\nimport " + FactB.class.getCanonicalName() + ";\nglobal java.util.List results;\n\nrule \"test eval with OR\"\nwhen\n    FactA( $a : field1 )\n    $f : FactB( $b : f1 ) or $f : FactB( $b : f1 == \"X\" )\n    eval( $a.equals( $b ) ) \nthen\n    results.add( $f );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"or-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("results", list);
            ksession.insert((Object)new FactA("X"));
            InternalFactHandle b = (InternalFactHandle)ksession.insert((Object)new FactB("X"));
            ksession.fireAllRules();
            Assert.assertEquals((String)"should have fired", (long)2L, (long)list.size());
            Assert.assertTrue((boolean)list.contains(b.getObject()));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrWithAndUsingNestedBindings() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport " + Person.class.getCanonicalName() + ";\nglobal java.util.List mlist\nglobal java.util.List jlist\nrule rule1 dialect \"mvel\" \nwhen\n$a : Person( name == \"a\" )\n  (or $b : Person( name == \"b1\" )\n      (and $p : Person( name == \"p2\" )\n           $b : Person( name == \"b2\" ) )\n      (and $p : Person( name == \"p3\" )\n           $b : Person( name == \"b3\" ) )\n   )\n then\n   mlist.add( $b );\nend\nrule rule2 dialect \"java\" \nwhen\n$a : Person( name == \"a\" )\n  (or $b : Person( name == \"b1\" )\n      (and $p : Person( name == \"p2\" )\n           $b : Person( name == \"b2\" ) )\n      (and $p : Person( name == \"p3\" )\n           $b : Person( name == \"b3\" ) )\n   )\n then\n   jlist.add( $b );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"or-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        ArrayList mlist = new ArrayList();
        ArrayList jlist = new ArrayList();
        Person a = new Person("a");
        Person b1 = new Person("b1");
        Person p2 = new Person("p2");
        Person b2 = new Person("b2");
        Person p3 = new Person("p3");
        Person b3 = new Person("b3");
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.setGlobal("mlist", mlist);
            ksession.setGlobal("jlist", jlist);
            ksession.insert((Object)a);
            ksession.insert((Object)b1);
            ksession.fireAllRules();
            Assert.assertEquals((Object)b1, mlist.get(0));
            Assert.assertEquals((Object)b1, jlist.get(0));
        }
        finally {
            ksession.dispose();
        }
        ksession = kbase.newKieSession();
        try {
            ksession.setGlobal("mlist", mlist);
            ksession.setGlobal("jlist", jlist);
            ksession.insert((Object)a);
            ksession.insert((Object)b2);
            ksession.insert((Object)p2);
            ksession.fireAllRules();
            Assert.assertEquals((Object)b2, mlist.get(1));
            Assert.assertEquals((Object)b2, jlist.get(1));
        }
        finally {
            ksession.dispose();
        }
        ksession = kbase.newKieSession();
        try {
            ksession.setGlobal("mlist", mlist);
            ksession.setGlobal("jlist", jlist);
            ksession.insert((Object)a);
            ksession.insert((Object)b3);
            ksession.insert((Object)p3);
            ksession.fireAllRules();
            Assert.assertEquals((Object)b3, mlist.get(2));
            Assert.assertEquals((Object)b3, jlist.get(2));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrWithBinding() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport " + Cheese.class.getCanonicalName() + ";\nimport " + Person.class.getCanonicalName() + ";\nglobal java.util.List results\n\nrule \"MyRule\"\n    when\n        c : (Cheese( type == \"stilton\") or\n             Cheese( type == \"brie\" ) or\n             Cheese( type == \"muzzarella\" ) )\n        p : Person()\n    then\n        results.add(c);\n        results.add(p);\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"or-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("results", list);
            Person hola = new Person("hola");
            ksession.insert((Object)hola);
            ksession.fireAllRules();
            Assert.assertEquals((long)0L, (long)list.size());
            Cheese brie = new Cheese("brie");
            ksession.insert((Object)brie);
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)list.size());
            Assert.assertTrue((boolean)list.contains(hola));
            Assert.assertTrue((boolean)list.contains(brie));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrWithFrom() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport " + Order.class.getCanonicalName() + ";\nimport " + OrderItem.class.getCanonicalName() + ";\nrule NotContains\nwhen\n    $oi1 : OrderItem( )\n    $o1  : Order(number == 1) from $oi1.order; \n    ( eval(true) or eval(true) )\n    $oi2 : OrderItem( )\n    $o2  : Order(number == 2) from $oi2.order; \nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"or-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            Order order1 = new Order(1, "XYZ");
            Order order2 = new Order(2, "ABC");
            OrderItem item11 = new OrderItem(order1, 1);
            order1.addItem(item11);
            OrderItem item21 = new OrderItem(order2, 1);
            order2.addItem(item21);
            ksession.insert((Object)order1);
            ksession.insert((Object)order2);
            ksession.insert((Object)item11);
            ksession.insert((Object)item21);
            int rules = ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)rules);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrWithReturnValueRestriction() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport " + Cheese.class.getCanonicalName() + ";\n \nrule \"r1\"\nwhen\n    Cheese( type == \"brie\", $price : price )\n    Cheese( type == \"stilton\", price == 10 || == ( $price % 10 ) )\nthen\n    // noop\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"or-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.insert((Object)new Cheese("brie", 18));
            ksession.insert((Object)new Cheese("stilton", 8));
            ksession.insert((Object)new Cheese("brie", 28));
            int fired = ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)fired);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBindingsWithOr() throws InstantiationException, IllegalAccessException {
        String drl = "package org.drools.compiler.integrationtests.operators;\ndeclare Assignment\n    source : int\n    target : int\nend\nrule ValueIsTheSame1\nwhen\n    Assignment( $t: target == 10 || target == source )\nthen\nend\nrule ValueIsTheSame2\nwhen\n    Assignment( $t: target == source || target == 10 )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"or-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler.integrationtests.operators;\ndeclare Assignment\n    source : int\n    target : int\nend\nrule ValueIsTheSame1\nwhen\n    Assignment( $t: target == 10 || target == source )\nthen\nend\nrule ValueIsTheSame2\nwhen\n    Assignment( $t: target == source || target == 10 )\nthen\nend"});
        KieSession ksession = kbase.newKieSession();
        try {
            FactType asgType = kbase.getFactType("org.drools.compiler.integrationtests.operators", "Assignment");
            Object asg = asgType.newInstance();
            asgType.set(asg, "source", (Object)10);
            asgType.set(asg, "target", (Object)10);
            ksession.insert(asg);
            int rules = ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)rules);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConstraintConnectorOr() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport " + Person.class.getCanonicalName() + ";\nglobal java.util.List results\n\nrule \"Simple || operator\"\n    when\n        $person : Person( alive == true || happy == true )\n    then\n        results.add( $person );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"or-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            ksession.setGlobal("results", results);
            Person mark = new Person("Mark");
            mark.setAlive(true);
            mark.setHappy(true);
            Person bush = new Person("Bush");
            bush.setAlive(true);
            bush.setHappy(false);
            Person conan = new Person("Conan");
            conan.setAlive(false);
            conan.setHappy(true);
            Person nero = new Person("Nero");
            nero.setAlive(false);
            nero.setHappy(false);
            ksession.insert((Object)mark);
            ksession.insert((Object)bush);
            ksession.insert((Object)conan);
            ksession.insert((Object)nero);
            ksession.fireAllRules();
            Assert.assertEquals((long)3L, (long)results.size());
            Assert.assertTrue((boolean)results.contains(mark));
            Assert.assertTrue((boolean)results.contains(bush));
            Assert.assertTrue((boolean)results.contains(conan));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVariableBindingWithOR() throws Exception {
        String drl1 = "package org.drools.compiler.integrationtests.operators; \ndeclare A\nend\ndeclare B\n   field : int\nend\ndeclare C\n   field : int\nend\nrule R when\n(    A( ) and ( B( $bField : field ) or C( $cField : field ) ) )\nthen\n    System.out.println($bField);\nend\n";
        KieBuilder kbuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{"package org.drools.compiler.integrationtests.operators; \ndeclare A\nend\ndeclare B\n   field : int\nend\ndeclare C\n   field : int\nend\nrule R when\n(    A( ) and ( B( $bField : field ) or C( $cField : field ) ) )\nthen\n    System.out.println($bField);\nend\n"});
        Assert.assertFalse((boolean)kbuilder.getResults().getMessages().isEmpty());
        String drl2 = "package org.drools.compiler.integrationtests.operators; \nglobal java.util.List results\ndeclare A\nend\ndeclare B\n   field : int\nend\ndeclare C\n   field : int\nend\nrule R when\n(    A( ) and ( B( $field : field ) or C( $field : field ) ) )\nthen\n    results.add($field); end\n";
        kbuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{"package org.drools.compiler.integrationtests.operators; \nglobal java.util.List results\ndeclare A\nend\ndeclare B\n   field : int\nend\ndeclare C\n   field : int\nend\nrule R when\n(    A( ) and ( B( $field : field ) or C( $field : field ) ) )\nthen\n    results.add($field); end\n"});
        Assert.assertTrue((boolean)kbuilder.getResults().getMessages().isEmpty());
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"or-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler.integrationtests.operators; \nglobal java.util.List results\ndeclare A\nend\ndeclare B\n   field : int\nend\ndeclare C\n   field : int\nend\nrule R when\n(    A( ) and ( B( $field : field ) or C( $field : field ) ) )\nthen\n    results.add($field); end\n"});
        KieSession ksession = kbase.newKieSession();
        try {
            FactType aType = kbase.getFactType("org.drools.compiler.integrationtests.operators", "A");
            Object aInstance = aType.newInstance();
            ksession.insert(aInstance);
            FactType cType = kbase.getFactType("org.drools.compiler.integrationtests.operators", "C");
            Object cInstance = cType.newInstance();
            cType.set(cInstance, "field", (Object)5);
            ksession.insert(cInstance);
            ArrayList results = new ArrayList();
            ksession.setGlobal("results", results);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertTrue((boolean)results.contains(5));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestrictionsWithOr() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport " + Cheese.class.getCanonicalName() + ";\nrule \"test\"\nwhen\n    Cheese( price == (1 + 1) );\n    (or eval(true);\n        eval(true);\n    )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"or-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.insert((Object)new Cheese("Stilton", 2));
            int rules = ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)rules);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmptyIdentifier() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport " + Cheese.class.getCanonicalName() + ";\nimport " + Person.class.getCanonicalName() + ";\nglobal java.util.List results;\nrule \"Or condition followed by fact\"\n  when\n    Cheese( type == \"stilton\" ) or Cheese( type == \"brie\" )\n    Person( )\n  then\n    results.add(\"Or condition followed by fact is ok\");\nend\n\nrule \"Fact followed by or condition\"\n  when\n    Person( )\n    Cheese( type == \"stilton\" ) or Cheese( type == \"brie\" )\n  then\n    results.add(\"Fact followed by or condition is ok\");\nend\n\nrule \"Single fact\"\n  when\n    Person( )\n  then\n    results.add(\"Single fact is ok\");\nend\n\nrule \"Single or\"\n  when\n    Cheese( type == \"stilton\" ) or Cheese( type == \"brie\" )\n  then\n    results.add(\"Single or is ok\");\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"or-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList result = new ArrayList();
            ksession.setGlobal("results", result);
            Person person = new Person("bob");
            Cheese cheese = new Cheese("brie", 10);
            ksession.insert((Object)person);
            ksession.insert((Object)cheese);
            ksession.fireAllRules();
            Assert.assertEquals((long)4L, (long)result.size());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIndexAfterOr() {
        String drl = "import " + Person.class.getCanonicalName() + ";global java.util.List list\nrule R when\n  $p : Person(name == \"Mark\") or\n  ( $mark : Person(name == \"Mark\")\n    and\n    $p : Person(age > $mark.age) )\n  $s: String(this == $p.name)then\n  list.add($s);\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"or-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.insert((Object)"Mario");
            ksession.insert((Object)"Edson");
            ksession.insert((Object)new Person("Mark", 37));
            ksession.insert((Object)new Person("Edson", 35));
            ksession.insert((Object)new Person("Mario", 40));
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertEquals((Object)"Mario", list.get(0));
        }
        finally {
            ksession.dispose();
        }
    }
}

