/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.incrementalcompilation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.drools.compiler.integrationtests.incrementalcompilation.AddRemoveTestCases;
import org.drools.compiler.integrationtests.incrementalcompilation.ConstraintsPair;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.kie.test.testcategory.TurtleTestCategory;

@Category(value={TurtleTestCategory.class})
public abstract class AbstractAddRemoveGenerated2RulesTest {
    private final String rule1;
    private final String rule2;

    public AbstractAddRemoveGenerated2RulesTest(ConstraintsPair constraintsPair) {
        String rule1 = "package com.rules;global java.util.List list\nrule R1 \n when \n ${constraints} then\n list.add('R1'); \nend\n";
        String rule2 = "package com.rules;global java.util.List list\nrule R2 \n when \n ${constraints} then\n list.add('R2'); \nend\n";
        this.rule1 = "package com.rules;global java.util.List list\nrule R1 \n when \n ${constraints} then\n list.add('R1'); \nend\n".replace("${constraints}", constraintsPair.getConstraints1());
        this.rule2 = "package com.rules;global java.util.List list\nrule R2 \n when \n ${constraints} then\n list.add('R2'); \nend\n".replace("${constraints}", constraintsPair.getConstraints2());
    }

    public static Collection<ConstraintsPair[]> generateRulesConstraintsCombinations(String constraint1, String constraint2, String constraint3) {
        HashSet<ConstraintsPair> constraintsPairs = new HashSet<ConstraintsPair>();
        ArrayList<ConstraintsPair[]> result = new ArrayList<ConstraintsPair[]>();
        ArrayList<String> constraintsList = new ArrayList<String>();
        constraintsList.add(constraint1);
        constraintsList.add(constraint2);
        constraintsList.add(constraint3);
        List<String> constraintsCombinations = AbstractAddRemoveGenerated2RulesTest.getConstraintsCombinations(constraintsList);
        for (String constraintsRule1 : constraintsCombinations) {
            for (String constraintsRule2 : constraintsCombinations) {
                ConstraintsPair constraintsPair = new ConstraintsPair(constraintsRule1, constraintsRule2);
                if (!constraintsPairs.add(constraintsPair)) continue;
                result.add(new ConstraintsPair[]{constraintsPair});
            }
        }
        return result;
    }

    private static List<String> getConstraintsCombinations(List<String> constraintsList) {
        ArrayList<String> ruleConstraintsCombinations = new ArrayList<String>();
        for (String constraint : constraintsList) {
            for (String constraint2 : constraintsList) {
                for (String constraint3 : constraintsList) {
                    ruleConstraintsCombinations.add(constraint.replace("${variableNamePlaceholder}", "$i") + constraint2.replace("${variableNamePlaceholder}", "$j") + constraint3.replace("${variableNamePlaceholder}", "$k"));
                }
            }
        }
        return ruleConstraintsCombinations;
    }

    @Test(timeout=40000L)
    public void testInsertFactsFireRulesRemoveRules() {
        AddRemoveTestCases.insertFactsFireRulesRemoveRules1(this.rule1, this.rule2, "R1", "R2", null, this.getFacts());
        AddRemoveTestCases.insertFactsFireRulesRemoveRules2(this.rule1, this.rule2, "R1", "R2", null, this.getFacts());
        AddRemoveTestCases.insertFactsFireRulesRemoveRules3(this.rule1, this.rule2, "R1", "R2", null, this.getFacts());
    }

    @Test(timeout=40000L)
    public void testInsertFactsFireRulesRemoveRulesRevertedRules() {
        AddRemoveTestCases.insertFactsFireRulesRemoveRules1(this.rule2, this.rule1, "R2", "R1", null, this.getFacts());
        AddRemoveTestCases.insertFactsFireRulesRemoveRules2(this.rule2, this.rule1, "R2", "R1", null, this.getFacts());
        AddRemoveTestCases.insertFactsFireRulesRemoveRules3(this.rule2, this.rule1, "R2", "R1", null, this.getFacts());
    }

    @Test(timeout=40000L)
    public void testFireRulesInsertFactsFireRulesRemoveRules() {
        AddRemoveTestCases.fireRulesInsertFactsFireRulesRemoveRules1(this.rule1, this.rule2, "R1", "R2", null, this.getFacts());
        AddRemoveTestCases.fireRulesInsertFactsFireRulesRemoveRules2(this.rule1, this.rule2, "R1", "R2", null, this.getFacts());
        AddRemoveTestCases.fireRulesInsertFactsFireRulesRemoveRules3(this.rule1, this.rule2, "R1", "R2", null, this.getFacts());
    }

    @Test(timeout=40000L)
    public void testFireRulesInsertFactsFireRulesRemoveRulesRevertedRules() {
        AddRemoveTestCases.fireRulesInsertFactsFireRulesRemoveRules1(this.rule2, this.rule1, "R2", "R1", null, this.getFacts());
        AddRemoveTestCases.fireRulesInsertFactsFireRulesRemoveRules2(this.rule2, this.rule1, "R2", "R1", null, this.getFacts());
        AddRemoveTestCases.fireRulesInsertFactsFireRulesRemoveRules3(this.rule2, this.rule1, "R2", "R1", null, this.getFacts());
    }

    @Test(timeout=40000L)
    public void testInsertFactsRemoveRulesFireRulesRemoveRules() {
        AddRemoveTestCases.insertFactsRemoveRulesFireRulesRemoveRules1(this.rule1, this.rule2, "R1", "R2", null, this.getFacts());
        AddRemoveTestCases.insertFactsRemoveRulesFireRulesRemoveRules2(this.rule1, this.rule2, "R1", "R2", null, this.getFacts());
        AddRemoveTestCases.insertFactsRemoveRulesFireRulesRemoveRules3(this.rule1, this.rule2, "R1", "R2", null, this.getFacts());
    }

    @Test(timeout=40000L)
    public void testInsertFactsRemoveRulesFireRulesRemoveRulesRevertedRules() {
        AddRemoveTestCases.insertFactsRemoveRulesFireRulesRemoveRules1(this.rule2, this.rule1, "R2", "R1", null, this.getFacts());
        AddRemoveTestCases.insertFactsRemoveRulesFireRulesRemoveRules2(this.rule2, this.rule1, "R2", "R1", null, this.getFacts());
        AddRemoveTestCases.insertFactsRemoveRulesFireRulesRemoveRules3(this.rule2, this.rule1, "R2", "R1", null, this.getFacts());
    }

    @Test(timeout=40000L)
    public void testInsertFactsFireRulesRemoveRulesReinsertRules() {
        AddRemoveTestCases.insertFactsFireRulesRemoveRulesReinsertRules1(this.rule1, this.rule2, "R1", "R2", null, this.getFacts());
        AddRemoveTestCases.insertFactsFireRulesRemoveRulesReinsertRules2(this.rule1, this.rule2, "R1", "R2", null, this.getFacts());
        AddRemoveTestCases.insertFactsFireRulesRemoveRulesReinsertRules3(this.rule1, this.rule2, "R1", "R2", null, this.getFacts());
    }

    @Test(timeout=40000L)
    public void testInsertFactsFireRulesRemoveRulesReinsertRulesRevertedRules() {
        AddRemoveTestCases.insertFactsFireRulesRemoveRulesReinsertRules1(this.rule2, this.rule1, "R2", "R1", null, this.getFacts());
        AddRemoveTestCases.insertFactsFireRulesRemoveRulesReinsertRules2(this.rule2, this.rule1, "R2", "R1", null, this.getFacts());
        AddRemoveTestCases.insertFactsFireRulesRemoveRulesReinsertRules3(this.rule2, this.rule1, "R2", "R1", null, this.getFacts());
    }

    private Object[] getFacts() {
        HashMap<Object, String> mapFact = new HashMap<Object, String>(1);
        mapFact.put(new Object(), "1");
        return new Object[]{1, 2, 3, "1", mapFact};
    }
}

