/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import org.drools.core.base.BaseEvaluator;
import org.drools.core.base.ValueType;
import org.drools.core.base.evaluators.EvaluatorDefinition;
import org.drools.core.base.evaluators.Operator;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.rule.VariableRestriction;
import org.drools.core.spi.Evaluator;
import org.drools.core.spi.FieldValue;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.testcoverage.common.model.Address;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class CustomOperatorTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public CustomOperatorTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testCustomOperatorCombiningConstraints() {
        String drl = "declare GN\n   gNo : Double\nend\n\ndeclare t547147\n   c547148 : String\n   c547149 : String\nend\n\ndeclare Tra48\n   gNo : Double\n   postCode : String\n   name : String\n   cnt : String\nend\n\nrule \"r548695.1\"\nno-loop true\ndialect \"mvel\"\nwhen\n   gnId : GN()\n   la : t547147( )\n   v1717 : Tra48( gnId.gNo == gNo, name F_str[startsWith] la.c547148 || postCode F_str[contains] la.c547149 )\nthen\nend\n";
        System.setProperty("drools.evaluator.str", F_StrEvaluatorDefinition.class.getName());
        try {
            KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"custom-operator-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"declare GN\n   gNo : Double\nend\n\ndeclare t547147\n   c547148 : String\n   c547149 : String\nend\n\ndeclare Tra48\n   gNo : Double\n   postCode : String\n   name : String\n   cnt : String\nend\n\nrule \"r548695.1\"\nno-loop true\ndialect \"mvel\"\nwhen\n   gnId : GN()\n   la : t547147( )\n   v1717 : Tra48( gnId.gNo == gNo, name F_str[startsWith] la.c547148 || postCode F_str[contains] la.c547149 )\nthen\nend\n"});
        }
        finally {
            System.clearProperty("drools.evaluator.str");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomOperatorUsingCollections() {
        String drl = "import " + Address.class.getCanonicalName() + ";\nimport " + Person.class.getCanonicalName() + ";\nrule R when\n    $alice : Person(name == \"Alice\")\n    $bob : Person(name == \"Bob\", addresses supersetOf $alice.addresses)\nthen\nend\n";
        System.setProperty("drools.evaluator.supersetOf", SupersetOfEvaluatorDefinition.class.getName());
        try {
            KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"custom-operator-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
            KieSession ksession = kbase.newKieSession();
            try {
                Person alice = new Person("Alice", 30);
                alice.addAddress(new Address("Large Street", "BigTown", "12345"));
                Person bob = new Person("Bob", 30);
                bob.addAddress(new Address("Large Street", "BigTown", "12345"));
                bob.addAddress(new Address("Long Street", "SmallTown", "54321"));
                ksession.insert((Object)alice);
                ksession.insert((Object)bob);
                Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
            }
            finally {
                ksession.dispose();
            }
        }
        finally {
            System.clearProperty("drools.evaluator.supersetOf");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomOperatorOnKieModule() {
        String drl = "import " + Address.class.getCanonicalName() + ";\nimport " + Person.class.getCanonicalName() + ";\nrule R when\n    $alice : Person(name == \"Alice\")\n    $bob : Person(name == \"Bob\", addresses supersetOf $alice.addresses)\nthen\nend\n";
        System.setProperty("drools.evaluator.supersetOf", SupersetOfEvaluatorDefinition.class.getName());
        try {
            KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"custom-operator-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
            KieSession ksession = kbase.newKieSession();
            try {
                Person alice = new Person("Alice", 30);
                alice.addAddress(new Address("Large Street", "BigTown", "12345"));
                Person bob = new Person("Bob", 30);
                bob.addAddress(new Address("Large Street", "BigTown", "12345"));
                bob.addAddress(new Address("Long Street", "SmallTown", "54321"));
                ksession.insert((Object)alice);
                ksession.insert((Object)bob);
                Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
            }
            finally {
                ksession.dispose();
            }
        }
        finally {
            System.clearProperty("drools.evaluator.supersetOf");
        }
    }

    public static class SupersetOfEvaluator
    extends BaseEvaluator {
        public SupersetOfEvaluator(ValueType type, boolean isNegated) {
            super(type, isNegated ? SupersetOfEvaluatorDefinition.NOT_SUPERSET_OF : SupersetOfEvaluatorDefinition.SUPERSET_OF);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, InternalFactHandle factHandle, FieldValue value) {
            Object objectValue = extractor.getValue(workingMemory, (Object)factHandle);
            return this.evaluateAll((Collection)value.getValue(), (Collection)objectValue);
        }

        public boolean evaluate(InternalWorkingMemory iwm, InternalReadAccessor ira, InternalFactHandle left, InternalReadAccessor ira1, InternalFactHandle right) {
            return this.evaluateAll((Collection)left.getObject(), (Collection)right.getObject());
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, InternalFactHandle right) {
            Object valRight = context.extractor.getValue(workingMemory, right.getObject());
            return this.evaluateAll((Collection)((VariableRestriction.ObjectVariableContextEntry)context).left, (Collection)valRight);
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, InternalFactHandle left) {
            Object varLeft = context.declaration.getExtractor().getValue(workingMemory, (Object)left);
            return this.evaluateAll((Collection)varLeft, (Collection)((VariableRestriction.ObjectVariableContextEntry)context).right);
        }

        public boolean evaluateAll(Collection leftCollection, Collection rightCollection) {
            return rightCollection.containsAll(leftCollection);
        }
    }

    public static class SupersetOfEvaluatorDefinition
    implements EvaluatorDefinition {
        public static final Operator SUPERSET_OF = Operator.addOperatorToRegistry((String)"supersetOf", (boolean)false);
        public static final Operator NOT_SUPERSET_OF = Operator.addOperatorToRegistry((String)"supersetOf", (boolean)true);
        private static final String[] SUPPORTED_IDS = new String[]{SUPERSET_OF.getOperatorString()};
        private Evaluator[] evaluator;

        public String[] getEvaluatorIds() {
            return SUPPORTED_IDS;
        }

        public boolean isNegatable() {
            return true;
        }

        public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText, EvaluatorDefinition.Target leftTarget, EvaluatorDefinition.Target rightTarget) {
            return new SupersetOfEvaluator(type, isNegated);
        }

        public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
            return this.getEvaluator(type, operatorId, isNegated, parameterText, EvaluatorDefinition.Target.FACT, EvaluatorDefinition.Target.FACT);
        }

        public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
            return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), parameterText);
        }

        public Evaluator getEvaluator(ValueType type, Operator operator) {
            return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), null);
        }

        public boolean supportsType(ValueType vt) {
            return true;
        }

        public EvaluatorDefinition.Target getTarget() {
            return EvaluatorDefinition.Target.FACT;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.evaluator);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.evaluator = (Evaluator[])in.readObject();
        }
    }

    public static class F_StrEvaluator
    extends BaseEvaluator {
        private F_StrEvaluatorDefinition.Operations parameter;

        public void setParameterText(String parameterText) {
            this.parameter = F_StrEvaluatorDefinition.Operations.valueOf(parameterText);
        }

        public F_StrEvaluatorDefinition.Operations getParameter() {
            return this.parameter;
        }

        public F_StrEvaluator(ValueType type, boolean isNegated) {
            super(type, isNegated ? F_StrEvaluatorDefinition.NOT_STR_COMPARE : F_StrEvaluatorDefinition.STR_COMPARE);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, InternalFactHandle factHandle, FieldValue value) {
            Object objectValue = extractor.getValue(workingMemory, (Object)factHandle);
            String objectValueString = (String)objectValue;
            return this.evaluateAll((String)value.getValue(), objectValueString);
        }

        public boolean evaluate(InternalWorkingMemory iwm, InternalReadAccessor ira, InternalFactHandle left, InternalReadAccessor ira1, InternalFactHandle right) {
            return this.evaluateAll((String)left.getObject(), (String)right.getObject());
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, InternalFactHandle right) {
            Object valRight = context.extractor.getValue(workingMemory, (Object)right);
            return this.evaluateAll((String)((VariableRestriction.ObjectVariableContextEntry)context).left, (String)valRight);
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, InternalFactHandle left) {
            Object varLeft = context.declaration.getExtractor().getValue(workingMemory, (Object)left);
            return this.evaluateAll((String)varLeft, (String)((VariableRestriction.ObjectVariableContextEntry)context).right);
        }

        public boolean evaluateAll(String leftString, String rightString) {
            boolean result;
            boolean bl = result = leftString != null && rightString != null;
            if (result) {
                switch (this.parameter) {
                    case startsWith: {
                        result = this.getOperator().isNegated() ^ leftString.startsWith(rightString);
                        return result;
                    }
                    case endsWith: {
                        result = this.getOperator().isNegated() ^ leftString.endsWith(rightString);
                        return result;
                    }
                }
            }
            return result;
        }
    }

    public static class F_StrEvaluatorDefinition
    implements EvaluatorDefinition {
        public static final Operator STR_COMPARE = Operator.addOperatorToRegistry((String)"F_str", (boolean)false);
        public static final Operator NOT_STR_COMPARE = Operator.addOperatorToRegistry((String)"F_str", (boolean)true);
        private static final String[] SUPPORTED_IDS = new String[]{STR_COMPARE.getOperatorString()};
        private Evaluator[] evaluator;

        public String[] getEvaluatorIds() {
            return SUPPORTED_IDS;
        }

        public boolean isNegatable() {
            return true;
        }

        public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText, EvaluatorDefinition.Target leftTarget, EvaluatorDefinition.Target rightTarget) {
            F_StrEvaluator evaluatorLocal = new F_StrEvaluator(type, isNegated);
            evaluatorLocal.setParameterText(parameterText);
            return evaluatorLocal;
        }

        public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
            return this.getEvaluator(type, operatorId, isNegated, parameterText, EvaluatorDefinition.Target.FACT, EvaluatorDefinition.Target.FACT);
        }

        public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
            return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), parameterText);
        }

        public Evaluator getEvaluator(ValueType type, Operator operator) {
            return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), null);
        }

        public boolean supportsType(ValueType vt) {
            return true;
        }

        public EvaluatorDefinition.Target getTarget() {
            return EvaluatorDefinition.Target.FACT;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.evaluator);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.evaluator = (Evaluator[])in.readObject();
        }

        public static enum Operations {
            startsWith,
            endsWith,
            length,
            contains,
            bidicontains;

        }
    }
}

