/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.drl;

import java.util.Collection;
import org.drools.core.common.InternalAgenda;
import org.drools.testcoverage.common.model.Cheese;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class RuleFlowGroupTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public RuleFlowGroupTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRuleFlowGroupWithLockOnActivate() {
        String drl = "import " + Person.class.getCanonicalName() + ";\nimport " + Cheese.class.getCanonicalName() + ";\nrule R1\nruleflow-group \"group1\"\nlock-on-active true\nwhen\n   $p : Person()\nthen\n   $p.setName(\"John\");\n   update ($p);\nend\nrule R2\nruleflow-group \"group1\"\nlock-on-active true\nwhen\n   $p : Person( name == null )\n   forall ( Cheese ( type == \"cheddar\" ))\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"ruleflowgroup-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.insert((Object)new Person());
            ksession.insert((Object)new Cheese("gorgonzola"));
            ((InternalAgenda)ksession.getAgenda()).activateRuleFlowGroup("group1");
            Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        }
        finally {
            ksession.dispose();
        }
    }
}

