/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.operators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.drools.testcoverage.common.model.Cheese;
import org.drools.testcoverage.common.model.Person;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class MatchesTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public MatchesTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMatchesMVEL() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport java.util.Map;\nglobal java.util.List results;\nrule \"Matches mvel\"\nwhen\n    Map( this[\"content\"] matches \"hello ;=\" )\nthen\n    results.add( \"OK\" );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"matches-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"package org.drools.compiler.integrationtests.operators;\nimport java.util.Map;\nglobal java.util.List results;\nrule \"Matches mvel\"\nwhen\n    Map( this[\"content\"] matches \"hello ;=\" )\nthen\n    results.add( \"OK\" );\nend"});
        KieSession session = kbase.newKieSession();
        try {
            ArrayList results = new ArrayList();
            session.setGlobal("results", results);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("content", "hello ;=");
            session.insert(map);
            session.fireAllRules();
            Assert.assertEquals((long)1L, (long)results.size());
        }
        finally {
            session.dispose();
        }
    }

    private String getMatchesDRL() {
        return "package org.drools.compiler.integrationtests.operators;\nimport java.util.Map;\nrule \"Matches mvel\"\nwhen\n    Map( this[\"content\"] matches \".*\\\\..*\\\\(.*\" )\nthen\n    // succeeded\nend\nrule \"Matches mvel 2\"\nwhen\n    Map( this[\"content\"] matches \"[^\\\\.]*\\\\(.*\" )\nthen\n    // succeeded\nend\nrule \"Matches mvel 3\"\nwhen\n    Map( this[\"content\"] matches \"(?i).*(ROUTINE).*\" )\nthen\n    // succeeded\nend";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMatchesMVEL2() {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"matches-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{this.getMatchesDRL()});
        KieSession ksession = kbase.newKieSession();
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("content", "String with . and (routine)");
            ksession.insert(map);
            int fired = ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)fired);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMatchesMVEL3() {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"matches-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{this.getMatchesDRL()});
        KieSession ksession = kbase.newKieSession();
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("content", "String with . and ()");
            ksession.insert(map);
            int fired = ksession.fireAllRules();
            Assert.assertEquals((long)1L, (long)fired);
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMatchesNotMatchesCheese() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport " + Cheese.class.getCanonicalName() + ";\nglobal java.util.List list;\n\nrule \"Cheese matches stilton\"\n    salience 10\n    when\n        stilton : Cheese( type matches \"[Ss]tilto[^0-9]\" )\n    then\n        list.add( stilton );\nend   \n\nrule \"Cheese not matches\"\n    when\n        brie : Cheese( type not matches \"(stil.*|mu\\\\w*|brie\\\\d|aged.*|.*prov.*)\" )\n    then\n        list.add( brie );\nend   \n\nrule \"Cheese matches with space\"\n    salience -10\n    when\n        stilton : Cheese( type matches \"aged stilton\" )\n    then\n        list.add( stilton );\nend   \n\nrule \"Cheese matches with ^ and escaped s\"\n    salience -20\n    when\n        prov : Cheese( type matches \"^provolone\\\\s*\" )\n    then\n        list.add( prov );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"matches-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            Cheese stilton = new Cheese("stilton", 12);
            Cheese stilton2 = new Cheese("stilton2", 12);
            Cheese agedStilton = new Cheese("aged stilton", 12);
            Cheese brie = new Cheese("brie", 10);
            Cheese brie2 = new Cheese("brie2", 10);
            Cheese muzzarella = new Cheese("muzzarella", 10);
            Cheese muzzarella2 = new Cheese("muzzarella2", 10);
            Cheese provolone = new Cheese("provolone", 10);
            Cheese provolone2 = new Cheese("another cheese (provolone)", 10);
            ksession.insert((Object)stilton);
            ksession.insert((Object)stilton2);
            ksession.insert((Object)agedStilton);
            ksession.insert((Object)brie);
            ksession.insert((Object)brie2);
            ksession.insert((Object)muzzarella);
            ksession.insert((Object)muzzarella2);
            ksession.insert((Object)provolone);
            ksession.insert((Object)provolone2);
            ksession.fireAllRules();
            Assert.assertEquals((long)4L, (long)list.size());
            Assert.assertEquals((Object)stilton, list.get(0));
            Assert.assertEquals((Object)brie, list.get(1));
            Assert.assertEquals((Object)agedStilton, list.get(2));
            Assert.assertEquals((Object)provolone, list.get(3));
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testNotMatchesSucceeds() {
        this.testMatchesSuccessFail("-..x..xrwx", 0);
    }

    @Test
    public void testNotMatchesFails() {
        this.testMatchesSuccessFail("d..x..xrwx", 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testMatchesSuccessFail(String personName, int expectedFireCount) {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport " + Person.class.getCanonicalName() + ";\nrule NotMatches\nwhen\n    Person( name == null || (name != null && name not matches \"-.{2}x.*\" ) )\nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"matches-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            Person p = new Person(personName);
            ksession.insert((Object)p);
            int rules = ksession.fireAllRules();
            Assert.assertEquals((long)expectedFireCount, (long)rules);
        }
        finally {
            ksession.dispose();
        }
    }
}

