/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import org.drools.mvel.compiler.Message;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class KnowledgeContextTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public KnowledgeContextTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Test
    public void testKnowledgeContextJava() {
        this.testKnowledgeContext("test_KnowledgeContextJava.drl");
    }

    @Test
    public void testKnowledgeContextMVEL() {
        this.testKnowledgeContext("test_KnowledgeContextMVEL.drl");
    }

    private void testKnowledgeContext(String drlResourceName) {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drlResourceName});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Message());
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"Hello World", list.get(0));
    }
}

