/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler;

import java.util.ArrayList;
import org.drools.mvel.CommonTestMethodBase;
import org.drools.mvel.compiler.Address;
import org.drools.mvel.compiler.LongAddress;
import org.drools.mvel.compiler.Person;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

public class InlineCastTest
extends CommonTestMethodBase {
    @Test
    public void testInlineCast() throws Exception {
        String str = "import org.drools.mvel.compiler.*;\nrule R1 when\n   Person( name == \"mark\", address#LongAddress.country == \"uk\" )\nthen\nend\n";
        KieBase kbase = this.loadKnowledgeBaseFromString(str);
        KieSession ksession = kbase.newKieSession();
        Person mark1 = new Person("mark");
        mark1.setAddress(new LongAddress("uk"));
        ksession.insert((Object)mark1);
        Person mark2 = new Person("mark");
        ksession.insert((Object)mark2);
        Person mark3 = new Person("mark");
        mark3.setAddress(new Address());
        ksession.insert((Object)mark3);
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        ksession.dispose();
    }

    @Test
    public void testInlineCastWithBinding() throws Exception {
        String str = "import org.drools.mvel.compiler.*;\nrule R1 when\n   Person( name == \"mark\", $country : address#LongAddress.country == \"uk\" )\nthen\nend\n";
        KieBase kbase = this.loadKnowledgeBaseFromString(str);
        KieSession ksession = kbase.newKieSession();
        Person mark1 = new Person("mark");
        mark1.setAddress(new LongAddress("uk"));
        ksession.insert((Object)mark1);
        Person mark2 = new Person("mark");
        ksession.insert((Object)mark2);
        Person mark3 = new Person("mark");
        mark3.setAddress(new Address());
        ksession.insert((Object)mark3);
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        ksession.dispose();
    }

    @Test
    public void testInlineCastOnlyBinding() throws Exception {
        String str = "import org.drools.mvel.compiler.*;\nrule R1 when\n   Person( name == \"mark\", $country : address#LongAddress.country )\nthen\nend\n";
        KieBase kbase = this.loadKnowledgeBaseFromString(str);
        KieSession ksession = kbase.newKieSession();
        Person mark1 = new Person("mark");
        mark1.setAddress(new LongAddress("uk"));
        ksession.insert((Object)mark1);
        Person mark2 = new Person("mark");
        ksession.insert((Object)mark2);
        Person mark3 = new Person("mark");
        mark3.setAddress(new Address());
        ksession.insert((Object)mark3);
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        ksession.dispose();
    }

    @Test
    public void testInlineCastWithFQN() throws Exception {
        String str = "import org.drools.mvel.compiler.Person;\nrule R1 when\n   Person( name == \"mark\", address#org.drools.mvel.compiler.LongAddress.country == \"uk\" )\nthen\nend\n";
        KieBase kbase = this.loadKnowledgeBaseFromString(str);
        KieSession ksession = kbase.newKieSession();
        Person mark1 = new Person("mark");
        mark1.setAddress(new LongAddress("uk"));
        ksession.insert((Object)mark1);
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        ksession.dispose();
    }

    @Test
    public void testInlineCastOnRightOperand() throws Exception {
        String str = "import org.drools.mvel.compiler.*;\nrule R1 when\n   $person : Person( )\n   String( this == $person.address#LongAddress.country )\nthen\nend\n";
        KieBase kbase = this.loadKnowledgeBaseFromString(str);
        KieSession ksession = kbase.newKieSession();
        Person mark1 = new Person("mark");
        mark1.setAddress(new LongAddress("uk"));
        ksession.insert((Object)mark1);
        ksession.insert((Object)"uk");
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        ksession.dispose();
    }

    @Test
    public void testInlineCastOnRightOperandWithFQN() throws Exception {
        String str = "import org.drools.mvel.compiler.Person;\nrule R1 when\n   $person : Person( )\n   String( this == $person.address#org.drools.mvel.compiler.LongAddress.country )\nthen\nend\n";
        KieBase kbase = this.loadKnowledgeBaseFromString(str);
        KieSession ksession = kbase.newKieSession();
        Person mark1 = new Person("mark");
        mark1.setAddress(new LongAddress("uk"));
        ksession.insert((Object)mark1);
        ksession.insert((Object)"uk");
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        ksession.dispose();
    }

    @Test
    public void testInferredCast() throws Exception {
        String str = "import org.drools.mvel.compiler.*;\nrule R1 when\n   Person( name == \"mark\", address instanceof LongAddress, address.country == \"uk\" )\nthen\nend\n";
        KieBase kbase = this.loadKnowledgeBaseFromString(str);
        KieSession ksession = kbase.newKieSession();
        Person mark1 = new Person("mark");
        mark1.setAddress(new LongAddress("uk"));
        ksession.insert((Object)mark1);
        Person mark2 = new Person("mark");
        ksession.insert((Object)mark2);
        Person mark3 = new Person("mark");
        mark3.setAddress(new Address());
        ksession.insert((Object)mark3);
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        ksession.dispose();
    }

    @Test
    public void testInlineTypeCast() throws Exception {
        String str = "import org.drools.mvel.compiler.*;\nrule R1 when\n Person( name == \"mark\", address#LongAddress )\nthen\nend\n";
        KieBase kbase = this.loadKnowledgeBaseFromString(str);
        KieSession ksession = kbase.newKieSession();
        Person mark1 = new Person("mark");
        mark1.setAddress(new LongAddress("uk"));
        ksession.insert((Object)mark1);
        Person mark2 = new Person("mark");
        ksession.insert((Object)mark2);
        Person mark3 = new Person("mark");
        mark3.setAddress(new Address());
        ksession.insert((Object)mark3);
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        ksession.dispose();
    }

    @Test
    public void testInlineCastWithNestedAccces() throws Exception {
        String str = "import org.drools.mvel.compiler.*;\nrule R1 when\n   Person( name == \"mark\", address#LongAddress.country.length == 2 )\nthen\nend\n";
        KieBase kbase = this.loadKnowledgeBaseFromString(str);
        KieSession ksession = kbase.newKieSession();
        Person mark1 = new Person("mark");
        mark1.setAddress(new LongAddress("uk"));
        ksession.insert((Object)mark1);
        Person mark2 = new Person("mark");
        ksession.insert((Object)mark2);
        Person mark3 = new Person("mark");
        mark3.setAddress(new Address());
        ksession.insert((Object)mark3);
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        ksession.dispose();
    }

    @Test
    public void testInlineCastWithNestedAcccesAndNullSafeDereferencing() throws Exception {
        String str = "import org.drools.mvel.compiler.*;\nrule R1 when\n Person( name == \"mark\", address#LongAddress.country!.length == 2 )\nthen\nend\n";
        KieBase kbase = this.loadKnowledgeBaseFromString(str);
        KieSession ksession = kbase.newKieSession();
        Person mark1 = new Person("mark");
        mark1.setAddress(new LongAddress("uk"));
        ksession.insert((Object)mark1);
        Person mark2 = new Person("mark");
        ksession.insert((Object)mark2);
        Person mark3 = new Person("mark");
        mark3.setAddress(new LongAddress(null));
        ksession.insert((Object)mark3);
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        ksession.dispose();
    }

    @Test
    public void testInlineCastWithNestedAcccesAndNullSafeDereferencing2() throws Exception {
        String str = "import org.drools.mvel.compiler.*;\nrule R1 when\n Person(  name == \"mark\",  name == \"john\" || address#LongAddress.country!.length == 2 )\nthen\nend\n";
        KieBase kbase = this.loadKnowledgeBaseFromString(str);
        KieSession ksession = kbase.newKieSession();
        Person mark1 = new Person("mark");
        mark1.setAddress(new LongAddress("uk"));
        ksession.insert((Object)mark1);
        Person mark2 = new Person("mark");
        ksession.insert((Object)mark2);
        Person mark3 = new Person("mark");
        mark3.setAddress(new LongAddress(null));
        ksession.insert((Object)mark3);
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        ksession.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSuperclass() {
        String drl = "package org.drools.mvel.compiler.integrationtests\nimport org.drools.mvel.compiler.*;\nrule R1\n when\n Person( address#LongAddress.country str[startsWith] \"United\" )\n then\nend\n";
        KieBase kbase = this.loadKnowledgeBaseFromString(drl);
        KieSession ksession = kbase.newKieSession();
        try {
            Person mark1 = new Person("mark");
            mark1.setAddress(new Address());
            ksession.insert((Object)mark1);
            Person mark2 = new Person("mark");
            mark2.setAddress(new LongAddress("United Kingdom"));
            ksession.insert((Object)mark2);
            Person mark3 = new Person("mark");
            mark3.setAddress(new LongAddress("Czech Republic"));
            ksession.insert((Object)mark3);
            Assert.assertEquals((String)"wrong number of rules fired", (long)1L, (long)ksession.fireAllRules());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGroupedAccess() {
        String drl = "package org.drools.mvel.compiler.integrationtests\nimport org.drools.mvel.compiler.*;\nrule R1\n when\n Person( address#LongAddress.(country == \"United States\" || country == \"United Kingdom\") )\n then\nend\n";
        KieBase kbase = this.loadKnowledgeBaseFromString(drl);
        KieSession ksession = kbase.newKieSession();
        try {
            Person mark1 = new Person("mark");
            mark1.setAddress(new LongAddress("United States"));
            ksession.insert((Object)mark1);
            Person mark2 = new Person("mark");
            mark2.setAddress(new LongAddress("United Kingdom"));
            ksession.insert((Object)mark2);
            Person mark3 = new Person("mark");
            mark3.setAddress(new LongAddress("Czech Republic"));
            ksession.insert((Object)mark3);
            Assert.assertEquals((String)"wrong number of rules fired", (long)2L, (long)ksession.fireAllRules());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMatchesOperator() {
        String drl = "package org.drools.mvel.compiler.integrationtests\nimport org.drools.mvel.compiler.*;\nrule R1\n when\n Person( address#LongAddress.country matches \"[Uu]nited.*\" )\n then\nend\n";
        KieBase kbase = this.loadKnowledgeBaseFromString(drl);
        KieSession ksession = kbase.newKieSession();
        try {
            Person mark1 = new Person("mark");
            mark1.setAddress(new LongAddress("United States"));
            ksession.insert((Object)mark1);
            Person mark2 = new Person("mark");
            mark2.setAddress(new LongAddress("United Kingdom"));
            ksession.insert((Object)mark2);
            Person mark3 = new Person("mark");
            mark3.setAddress(new LongAddress("Czech Republic"));
            ksession.insert((Object)mark3);
            Assert.assertEquals((String)"wrong number of rules fired", (long)2L, (long)ksession.fireAllRules());
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInlineCastWithThis() {
        String drl = "package org.drools.mvel.compiler.integrationtests import org.drools.compiler.*; rule R1  when  Object( this#String matches \"[Uu]nited.*\" )  then end ";
        KieBase kbase = this.loadKnowledgeBaseFromString(drl);
        KieSession ksession = kbase.newKieSession();
        try {
            ksession.insert((Object)"United States");
            ksession.insert((Object)"United Kingdom");
            ksession.insert((Object)"Italy");
            Assert.assertEquals((String)"wrong number of rules fired", (long)2L, (long)ksession.fireAllRules());
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testInlineCastWithFQNAndMethodInvocation() throws Exception {
        String str = "import org.drools.mvel.compiler.Person;\nglobal java.util.List list;\nrule R1 when\n   Person( name == \"mark\", $x : address#org.drools.mvel.compiler.LongAddress.country.substring(1) )\nthen\n   list.add($x);end\n";
        KieBase kbase = this.loadKnowledgeBaseFromString(str);
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person mark1 = new Person("mark");
        mark1.setAddress(new LongAddress("uk"));
        ksession.insert((Object)mark1);
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"k", list.get(0));
        ksession.dispose();
    }
}

