/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler;

import java.util.ArrayList;
import java.util.List;
import org.drools.mvel.CommonTestMethodBase;
import org.drools.mvel.compiler.Address;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.compiler.Cheesery;
import org.drools.mvel.compiler.LongAddress;
import org.drools.mvel.compiler.Order;
import org.drools.mvel.compiler.OrderItem;
import org.drools.mvel.compiler.Person;
import org.drools.mvel.integrationtests.SerializationHelper;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.runtime.KieSession;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class NestedAccessorsTest
extends CommonTestMethodBase {
    @Test
    public void testNestedAccessor() throws Exception {
        String str = "import org.drools.mvel.compiler.*;\nrule R1 when\n   Person( name == \"mark\", cheese.(type == \"gorgonzola\", price == 10) )\nthen\nend\n";
        KieBase kbase = this.loadKnowledgeBaseFromString("import org.drools.mvel.compiler.*;\nrule R1 when\n   Person( name == \"mark\", cheese.(type == \"gorgonzola\", price == 10) )\nthen\nend\n");
        KieSession ksession = kbase.newKieSession();
        Person mark1 = new Person("mark");
        mark1.setCheese(new Cheese("gorgonzola", 10));
        ksession.insert((Object)mark1);
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        ksession.dispose();
    }

    @Test
    public void testNestedAccessorWithBinding() throws Exception {
        String str = "import org.drools.mvel.compiler.*;\nglobal StringBuilder sb\nrule R1 when\n   Person( name == \"mark\", cheese.(price == 10, $type : type) )\nthen\n   sb.append( $type );\nend\n";
        KieBase kbase = this.loadKnowledgeBaseFromString("import org.drools.mvel.compiler.*;\nglobal StringBuilder sb\nrule R1 when\n   Person( name == \"mark\", cheese.(price == 10, $type : type) )\nthen\n   sb.append( $type );\nend\n");
        KieSession ksession = kbase.newKieSession();
        StringBuilder sb = new StringBuilder();
        ksession.setGlobal("sb", (Object)sb);
        Person mark1 = new Person("mark");
        mark1.setCheese(new Cheese("gorgonzola", 10));
        ksession.insert((Object)mark1);
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        Assert.assertEquals((Object)"gorgonzola", (Object)sb.toString());
        ksession.dispose();
    }

    @Test
    public void testDoubleNestedAccessor() throws Exception {
        String str = "import org.drools.mvel.compiler.*;\nrule R1 when\n   Person( name == \"mark\", cheese.(price == 10, type.(length == 10) ) )\nthen\nend\n";
        KieBase kbase = this.loadKnowledgeBaseFromString("import org.drools.mvel.compiler.*;\nrule R1 when\n   Person( name == \"mark\", cheese.(price == 10, type.(length == 10) ) )\nthen\nend\n");
        KieSession ksession = kbase.newKieSession();
        Person mark1 = new Person("mark");
        mark1.setCheese(new Cheese("gorgonzola", 10));
        ksession.insert((Object)mark1);
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        ksession.dispose();
    }

    @Test
    public void testNestedAccessorWithInlineCast() throws Exception {
        String str = "import org.drools.mvel.compiler.*;\nrule R1 when\n   Person( name == \"mark\", address#LongAddress.(country == \"uk\", suburb == \"suburb\") )\nthen\nend\n";
        KieBase kbase = this.loadKnowledgeBaseFromString("import org.drools.mvel.compiler.*;\nrule R1 when\n   Person( name == \"mark\", address#LongAddress.(country == \"uk\", suburb == \"suburb\") )\nthen\nend\n");
        KieSession ksession = kbase.newKieSession();
        Person mark1 = new Person("mark");
        mark1.setAddress(new LongAddress("street", "suburb", "zipCode", "uk"));
        ksession.insert((Object)mark1);
        Person mark2 = new Person("mark");
        ksession.insert((Object)mark2);
        Person mark3 = new Person("mark");
        mark3.setAddress(new Address("street", "suburb", "zipCode"));
        ksession.insert((Object)mark3);
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        ksession.dispose();
    }

    @Test
    public void testNestedAccessors() throws Exception {
        KieBase kbase = SerializationHelper.serializeObject(this.loadKnowledgeBase("test_NestedAccessors.drl"));
        KieSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        Order order1 = new Order(11, "Bob");
        OrderItem item11 = new OrderItem(order1, 1);
        OrderItem item12 = new OrderItem(order1, 2);
        order1.addItem(item11);
        order1.addItem(item12);
        ksession.insert((Object)order1);
        ksession.insert((Object)item11);
        ksession.insert((Object)item12);
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        Order order2 = new Order(12, "Mark");
        Order.OrderStatus status = new Order.OrderStatus();
        status.setActive(true);
        order2.setStatus(status);
        OrderItem item21 = new OrderItem(order2, 1);
        OrderItem item22 = new OrderItem(order2, 2);
        order1.addItem(item21);
        order1.addItem(item22);
        ksession.insert((Object)order2);
        ksession.insert((Object)item21);
        ksession.insert((Object)item22);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertSame((Object)item21, list.get(0));
        Assert.assertSame((Object)item22, list.get(1));
    }

    @Test
    public void testNestedAccessors2() throws Exception {
        String rule = "package org.drools.mvel.compiler\nrule 'rule1'    salience 10\nwhen\n    Cheesery( typedCheeses[0].type == 'stilton' );\nthen\nend\nrule 'rule2'\nwhen\n    Cheesery( typedCheeses[0].price == 10 );\nthen\nend";
        KieBase kbase = this.loadKnowledgeBaseFromString("package org.drools.mvel.compiler\nrule 'rule1'    salience 10\nwhen\n    Cheesery( typedCheeses[0].type == 'stilton' );\nthen\nend\nrule 'rule2'\nwhen\n    Cheesery( typedCheeses[0].price == 10 );\nthen\nend");
        KieSession ksession = this.createKnowledgeSession(kbase);
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(ael);
        Cheesery c1 = new Cheesery();
        c1.addCheese(new Cheese("stilton", 20));
        Cheesery c2 = new Cheesery();
        c2.addCheese(new Cheese("brie", 10));
        Cheesery c3 = new Cheesery();
        c3.addCheese(new Cheese("muzzarella", 30));
        ksession.insert((Object)c1);
        ksession.insert((Object)c2);
        ksession.insert((Object)c3);
        ksession.fireAllRules();
        ArgumentCaptor captor = ArgumentCaptor.forClass(AfterMatchFiredEvent.class);
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)2))).afterMatchFired((AfterMatchFiredEvent)captor.capture());
        List values = captor.getAllValues();
        MatcherAssert.assertThat(((AfterMatchFiredEvent)values.get(0)).getMatch().getObjects().get(0), (Matcher)CoreMatchers.is((Object)c1));
        MatcherAssert.assertThat(((AfterMatchFiredEvent)values.get(1)).getMatch().getObjects().get(0), (Matcher)CoreMatchers.is((Object)c2));
        ksession.dispose();
    }
}

