/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.compiler.xml.changeset;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.io.impl.UrlResource;
import org.drools.core.xml.XmlChangeSetReader;
import org.drools.mvel.CommonTestMethodBase;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.ChangeSet;
import org.kie.internal.builder.DecisionTableConfiguration;
import org.kie.internal.builder.DecisionTableInputType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.xml.sax.SAXException;

public class ChangeSetTest
extends CommonTestMethodBase {
    @Test
    public void testXmlParser() throws SAXException, IOException {
        KnowledgeBuilderConfigurationImpl conf = new KnowledgeBuilderConfigurationImpl();
        XmlChangeSetReader xmlReader = new XmlChangeSetReader(conf.getSemanticModules());
        xmlReader.setClassLoader(ChangeSetTest.class.getClassLoader(), ChangeSetTest.class);
        String str = "";
        str = str + "<change-set ";
        str = str + "xmlns='http://drools.org/drools-5.0/change-set' ";
        str = str + "xmlns:xs='http://www.w3.org/2001/XMLSchema-instance' ";
        str = str + "xs:schemaLocation='http://drools.org/drools-5.0/change-set change-set-1.0.0.xsd' >";
        str = str + "    <add> ";
        str = str + "        <resource source='http://www.domain.com/test.drl' type='DRL' />";
        str = str + "        <resource source='http://www.domain.com/test.xls' type='DTABLE' >";
        str = str + "            <decisiontable-conf worksheet-name='sheet10' input-type='XLS' />";
        str = str + "        </resource>";
        str = str + "    </add> ";
        str = str + "</change-set>";
        StringReader reader = new StringReader(str);
        ChangeSet changeSet = xmlReader.read((Reader)reader);
        Assert.assertEquals((long)2L, (long)changeSet.getResourcesAdded().size());
        UrlResource resource = (UrlResource)((List)changeSet.getResourcesAdded()).get(0);
        Assert.assertEquals((Object)"http://www.domain.com/test.drl", (Object)resource.getURL().toString());
        Assert.assertEquals((Object)ResourceType.DRL, (Object)resource.getResourceType());
        resource = (UrlResource)((List)changeSet.getResourcesAdded()).get(1);
        Assert.assertEquals((Object)"http://www.domain.com/test.xls", (Object)resource.getURL().toString());
        Assert.assertEquals((Object)ResourceType.DTABLE, (Object)resource.getResourceType());
        DecisionTableConfiguration dtConf = (DecisionTableConfiguration)resource.getConfiguration();
        Assert.assertEquals((Object)DecisionTableInputType.XLS, (Object)dtConf.getInputType());
    }

    @Test
    public void testIntegregation() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"changeset1Test.xml", this.getClass()), ResourceType.CHANGE_SET);
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        KieSession ksession = this.createKnowledgeSession((KieBase)kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.containsAll(Arrays.asList("rule1", "rule2")));
    }

    @Test
    public void testBasicAuthentication() throws SAXException, IOException {
        KnowledgeBuilderConfigurationImpl conf = new KnowledgeBuilderConfigurationImpl();
        XmlChangeSetReader xmlReader = new XmlChangeSetReader(conf.getSemanticModules());
        xmlReader.setClassLoader(ChangeSetTest.class.getClassLoader(), ChangeSetTest.class);
        String str = "";
        str = str + "<change-set ";
        str = str + "xmlns='http://drools.org/drools-5.0/change-set' ";
        str = str + "xmlns:xs='http://www.w3.org/2001/XMLSchema-instance' ";
        str = str + "xs:schemaLocation='http://drools.org/drools-5.0/change-set change-set-1.0.0.xsd' >";
        str = str + "    <add> ";
        str = str + "        <resource source='http://localhost:8081/jboss-brms/org.kie.guvnor.Guvnor/package/defaultPackage/LATEST' type='PKG' basicAuthentication='enabled' username='admin' password='pwd'/>";
        str = str + "    </add> ";
        str = str + "</change-set>";
        StringReader reader = new StringReader(str);
        ChangeSet changeSet = xmlReader.read((Reader)reader);
        Assert.assertEquals((long)1L, (long)changeSet.getResourcesAdded().size());
        UrlResource resource = (UrlResource)((List)changeSet.getResourcesAdded()).get(0);
        Assert.assertEquals((Object)"http://localhost:8081/jboss-brms/org.kie.guvnor.Guvnor/package/defaultPackage/LATEST", (Object)resource.getURL().toString());
        Assert.assertEquals((Object)"enabled", (Object)resource.getBasicAuthentication());
        Assert.assertEquals((Object)"admin", (Object)resource.getUsername());
        Assert.assertEquals((Object)"pwd", (Object)resource.getPassword());
        Assert.assertEquals((Object)ResourceType.PKG, (Object)resource.getResourceType());
    }

    @Test(timeout=10000L)
    public void testCustomClassLoader() throws Exception {
        String absolutePath = new File("file").getAbsolutePath();
        URL url = ChangeSetTest.class.getResource(ChangeSetTest.class.getSimpleName() + ".class");
        File file = new File(url.toURI());
        File jar = null;
        while (!(jar = new File(file = file.getParentFile(), "/src/test/resources/org/drools/mvel/compiler/compiler/xml/changeset/changeset.jar")).exists()) {
        }
        URLClassLoader classLoader = URLClassLoader.newInstance(new URL[]{jar.toURI().toURL()}, this.getClass().getClassLoader());
        Resource changeSet = ResourceFactory.newClassPathResource((String)"changeset1.xml", (ClassLoader)classLoader);
        KnowledgeBuilderConfiguration conf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration(null, (ClassLoader[])new ClassLoader[]{classLoader});
        KnowledgeBuilder builder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)conf);
        builder.add(changeSet, ResourceType.CHANGE_SET);
    }
}

