/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.test;

import java.util.ArrayList;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.io.impl.ByteArrayResource;
import org.drools.mvel.CommonTestMethodBase;
import org.drools.mvel.compiler.test.Man;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;

public class PositionalTest
extends CommonTestMethodBase {
    @Test
    public void testPositional() {
        String drl = "import " + Man.class.getCanonicalName() + ";\n\nglobal java.util.List list;\nrule \"To be or not to be\"\nwhen\n    $m : Man( \"john\" , 18 , $w ; )\nthen\n    list.add($w); end";
        KnowledgeBuilder knowledgeBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        knowledgeBuilder.add((Resource)new ByteArrayResource(drl.getBytes()), ResourceType.DRL);
        System.out.println(knowledgeBuilder.getErrors().toString());
        Assert.assertFalse((boolean)knowledgeBuilder.hasErrors());
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
        kBase.addPackages(knowledgeBuilder.getKnowledgePackages());
        KieSession kSession = this.createKnowledgeSession((KieBase)kBase);
        ArrayList list = new ArrayList();
        kSession.setGlobal("list", list);
        kSession.insert((Object)new Man("john", 18, 84.2));
        kSession.fireAllRules();
        Assert.assertTrue((boolean)list.contains(84.2));
    }

    @Test(timeout=5000L)
    public void testPositionalWithNull() {
        String str = "declare Bean\n  value : String\nend\n\nrule \"Init\"\nwhen\nthen\n  insert( new Bean( null ) );\n  insert( \"test\" );\nend\n\nrule \"Bind\"\nwhen\n  $s : String(  )\n  $b : Bean( null ; )\nthen\n  modify ( $b ) { setValue( $s ); }\nend";
        KieBase kbase = this.loadKnowledgeBaseFromString(str);
        KieSession ksession = kbase.newKieSession();
        Assert.assertEquals((long)2L, (long)ksession.fireAllRules());
    }
}

