/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.util.debug;

import java.awt.Dimension;
import java.io.InputStream;
import java.util.ArrayList;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.util.debug.SessionInspector;
import org.drools.core.util.debug.StatefulKnowledgeSessionInfo;
import org.drools.mvel.CommonTestMethodBase;
import org.drools.mvel.SessionReporter;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.compiler.Cheesery;
import org.drools.mvel.compiler.Person;
import org.drools.mvel.compiler.Worker;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class SessionInspectorTest
extends CommonTestMethodBase {
    @Test
    public void testGetSessionInfo() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"org/drools/mvel/integrationtests/test_SubNetworks.drl"), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"org/drools/mvel/integrationtests/test_AccumulateWithFromChaining.drl"), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"org/drools/mvel/integrationtests/test_CollectResultsBetaConstraint.drl"), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"org/drools/mvel/integrationtests/test_QueryMemoryLeak.drl"), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        KieSession ksession = this.createKnowledgeSession((KieBase)kbase);
        ksession.setGlobal("results", new ArrayList());
        ksession.insert((Object)new Dimension(100, 50));
        ksession.insert((Object)new Dimension(130, 80));
        ksession.insert((Object)new Dimension(50, 40));
        ksession.insert((Object)new Dimension(50, 40));
        Cheesery cheesery = new Cheesery();
        cheesery.addCheese(new Cheese("brie", 10));
        cheesery.addCheese(new Cheese("brie", 10));
        cheesery.addCheese(new Cheese("brie", 10));
        cheesery.addCheese(new Cheese("brie", 10));
        cheesery.addCheese(new Cheese("muzzarella", 10));
        cheesery.addCheese(new Cheese("muzzarella", 10));
        cheesery.addCheese(new Cheese("muzzarella", 10));
        cheesery.addCheese(new Cheese("muzzarella", 10));
        cheesery.addCheese(new Cheese("muzzarella", 10));
        cheesery.addCheese(new Cheese("muzzarella", 10));
        cheesery.addCheese(new Cheese("muzzarella", 10));
        cheesery.addCheese(new Cheese("stilton", 10));
        cheesery.addCheese(new Cheese("stilton", 10));
        cheesery.addCheese(new Cheese("stilton", 10));
        cheesery.addCheese(new Cheese("stilton", 10));
        cheesery.addCheese(new Cheese("stilton", 10));
        cheesery.addCheese(new Cheese("stilton", 10));
        cheesery.addCheese(new Cheese("stilton", 10));
        ksession.insert((Object)cheesery);
        ksession.insert((Object)new Person("Bob", "muzzarella"));
        ksession.insert((Object)new Person("Mark", "brie"));
        ksession.insert((Object)new Cheese("brie", 10));
        ksession.insert((Object)new Cheese("brie", 10));
        ksession.insert((Object)new Cheese("brie", 10));
        ksession.insert((Object)new Cheese("brie", 10));
        ksession.insert((Object)new Cheese("muzzarella", 10));
        ksession.insert((Object)new Cheese("muzzarella", 10));
        ksession.insert((Object)new Cheese("muzzarella", 10));
        ksession.insert((Object)new Cheese("muzzarella", 10));
        ksession.insert((Object)new Cheese("Stilton", 10));
        ksession.insert((Object)new Cheese("Stilton", 10));
        ksession.insert((Object)new Cheese("Stilton", 10));
        ksession.insert((Object)new Double(10.0));
        ksession.insert((Object)new Double(11.0));
        ksession.insert((Object)new Double(12.0));
        ksession.insert((Object)new Double(13.0));
        ksession.insert((Object)new Double(14.0));
        ksession.insert((Object)new Integer(15));
        ksession.insert((Object)new Integer(16));
        ksession.insert((Object)new Integer(17));
        ksession.insert((Object)new Integer(18));
        FactHandle handle = ksession.insert((Object)new Worker());
        ksession.retract(handle);
        SessionInspector inspector = new SessionInspector(ksession);
        StatefulKnowledgeSessionInfo info = inspector.getSessionInfo();
        String report = SessionReporter.generateReport((String)"simple", (StatefulKnowledgeSessionInfo)info, null);
        Assert.assertNotNull((Object)report);
    }

    @Test
    public void testGetSessionInfoWithCustomTemplate() {
        if (System.getProperty("java.vendor").toUpperCase().contains("IBM")) {
            return;
        }
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"org/drools/mvel/integrationtests/test_SubNetworks.drl"), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"org/drools/mvel/integrationtests/test_AccumulateWithFromChaining.drl"), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"org/drools/mvel/integrationtests/test_CollectResultsBetaConstraint.drl"), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"org/drools/mvel/integrationtests/test_QueryMemoryLeak.drl"), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        KieSession ksession = this.createKnowledgeSession((KieBase)kbase);
        ksession.setGlobal("results", new ArrayList());
        ksession.insert((Object)new Dimension(100, 50));
        ksession.insert((Object)new Dimension(130, 80));
        ksession.insert((Object)new Dimension(50, 40));
        ksession.insert((Object)new Dimension(50, 40));
        Cheesery cheesery = new Cheesery();
        cheesery.addCheese(new Cheese("brie", 10));
        cheesery.addCheese(new Cheese("brie", 10));
        cheesery.addCheese(new Cheese("brie", 10));
        cheesery.addCheese(new Cheese("brie", 10));
        cheesery.addCheese(new Cheese("muzzarella", 10));
        cheesery.addCheese(new Cheese("muzzarella", 10));
        cheesery.addCheese(new Cheese("muzzarella", 10));
        cheesery.addCheese(new Cheese("muzzarella", 10));
        cheesery.addCheese(new Cheese("muzzarella", 10));
        cheesery.addCheese(new Cheese("muzzarella", 10));
        cheesery.addCheese(new Cheese("muzzarella", 10));
        cheesery.addCheese(new Cheese("stilton", 10));
        cheesery.addCheese(new Cheese("stilton", 10));
        cheesery.addCheese(new Cheese("stilton", 10));
        cheesery.addCheese(new Cheese("stilton", 10));
        cheesery.addCheese(new Cheese("stilton", 10));
        cheesery.addCheese(new Cheese("stilton", 10));
        cheesery.addCheese(new Cheese("stilton", 10));
        ksession.insert((Object)cheesery);
        ksession.insert((Object)new Person("Bob", "muzzarella"));
        ksession.insert((Object)new Person("Mark", "brie"));
        ksession.insert((Object)new Cheese("brie", 10));
        ksession.insert((Object)new Cheese("brie", 10));
        ksession.insert((Object)new Cheese("brie", 10));
        ksession.insert((Object)new Cheese("brie", 10));
        ksession.insert((Object)new Cheese("muzzarella", 10));
        ksession.insert((Object)new Cheese("muzzarella", 10));
        ksession.insert((Object)new Cheese("muzzarella", 10));
        ksession.insert((Object)new Cheese("muzzarella", 10));
        ksession.insert((Object)new Cheese("Stilton", 10));
        ksession.insert((Object)new Cheese("Stilton", 10));
        ksession.insert((Object)new Cheese("Stilton", 10));
        ksession.insert((Object)new Double(10.0));
        ksession.insert((Object)new Double(11.0));
        ksession.insert((Object)new Double(12.0));
        ksession.insert((Object)new Double(13.0));
        ksession.insert((Object)new Double(14.0));
        ksession.insert((Object)new Integer(15));
        ksession.insert((Object)new Integer(16));
        ksession.insert((Object)new Integer(17));
        ksession.insert((Object)new Integer(18));
        FactHandle handle = ksession.insert((Object)new Worker());
        ksession.retract(handle);
        SessionInspector inspector = new SessionInspector(ksession);
        StatefulKnowledgeSessionInfo info = inspector.getSessionInfo();
        SessionReporter.addNamedTemplate((String)"topten", (InputStream)this.getClass().getResourceAsStream("customreports.mvel"));
        String report = SessionReporter.generateReport((String)"topten", (StatefulKnowledgeSessionInfo)info, null);
        Assert.assertNotNull((Object)report);
    }
}

