/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import org.drools.compiler.compiler.DrlParser;
import org.drools.compiler.compiler.DroolsError;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.core.io.impl.InputStreamResource;
import org.drools.mvel.CommonTestMethodBase;
import org.drools.mvel.DrlDumper;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.integrationtests.SerializationHelper;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.conf.LanguageLevelOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DRLDumperTest
extends CommonTestMethodBase {
    private static Logger logger = LoggerFactory.getLogger(DRLDumperTest.class);

    @Test
    public void testDumpers() throws Exception {
        DrlParser parser = new DrlParser(LanguageLevelOption.DRL5);
        InputStreamResource resource = new InputStreamResource(this.getClass().getResourceAsStream("drl/test_Dumpers.drl"));
        PackageDescr pkg = parser.parse((Resource)resource);
        if (parser.hasErrors()) {
            for (DroolsError error : parser.getErrors()) {
                logger.warn(error.toString());
            }
            Assert.fail((String)parser.getErrors().toString());
        }
        KieBase kbase = SerializationHelper.serializeObject(this.loadKnowledgeBase(pkg));
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 12);
        ksession.insert((Object)brie);
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)"3 1", list.get(0));
        Assert.assertEquals((Object)"MAIN", list.get(1));
        Assert.assertEquals((Object)"1 1", list.get(2));
        DrlDumper drlDumper = new DrlDumper();
        String drlResult = drlDumper.dump(pkg);
        System.out.println(drlResult);
        kbase = SerializationHelper.serializeObject(this.loadKnowledgeBaseFromString(drlResult));
        ksession = kbase.newKieSession();
        list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)brie);
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)"3 1", list.get(0));
        Assert.assertEquals((Object)"MAIN", list.get(1));
        Assert.assertEquals((Object)"1 1", list.get(2));
    }
}

