/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import org.drools.mvel.CommonTestMethodBase;
import org.drools.mvel.integrationtests.SerializationHelper;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

public class DroolsFromRHSTest
extends CommonTestMethodBase {
    @Test
    public void testHalt() throws Exception {
        KieBase kbase = SerializationHelper.serializeObject(this.loadKnowledgeBase("test_halt.drl"));
        KieSession ksession = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.insert((Object)0);
        ksession.fireAllRules();
        Assert.assertEquals((long)10L, (long)results.size());
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)i, results.get(i));
        }
    }

    @Test
    public void testFireLimit() throws Exception {
        int i;
        KieBase kbase = SerializationHelper.serializeObject(this.loadKnowledgeBase("test_fireLimit.drl"));
        KieSession ksession = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.insert((Object)0);
        int count = ksession.fireAllRules();
        Assert.assertEquals((long)21L, (long)count);
        Assert.assertEquals((long)20L, (long)results.size());
        for (i = 0; i < 20; ++i) {
            Assert.assertEquals((Object)i, results.get(i));
        }
        results.clear();
        ksession.insert((Object)0);
        count = ksession.fireAllRules(10);
        Assert.assertEquals((long)10L, (long)count);
        Assert.assertEquals((long)10L, (long)results.size());
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)i, results.get(i));
        }
        count = ksession.fireAllRules();
        Assert.assertEquals((long)11L, (long)count);
        Assert.assertEquals((long)20L, (long)results.size());
        for (i = 0; i < 20; ++i) {
            Assert.assertEquals((Object)i, results.get(i));
        }
        results.clear();
        ksession.insert((Object)0);
        count = ksession.fireAllRules();
        Assert.assertEquals((long)21L, (long)count);
        Assert.assertEquals((long)20L, (long)results.size());
        for (i = 0; i < 20; ++i) {
            Assert.assertEquals((Object)i, results.get(i));
        }
        results.clear();
    }
}

