/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.io.Serializable;
import org.drools.mvel.CommonTestMethodBase;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

public class DroolsTest
extends CommonTestMethodBase {
    private static final int NUM_FACTS = 20;
    private static int counter;

    @Test
    public void test1() throws Exception {
        String str = "package org.drools.mvel.integrationtests;\n";
        str = str + "import " + DroolsTest.class.getName() + ";\n";
        str = str + "import " + DroolsTest.class.getName() + ".Foo;\n";
        str = str + "import " + DroolsTest.class.getName() + ".Bar;\n";
        str = str + "rule test\n";
        str = str + "when\n";
        str = str + "      Foo($p : id, id < " + Integer.toString(20) + ")\n";
        str = str + "      Bar(id == $p)\n";
        str = str + "then\n";
        str = str + "   DroolsTest.incCounter();\n";
        str = str + "end\n";
        counter = 0;
        KieBase kbase = this.loadKnowledgeBaseFromString(str);
        KieSession wm = this.createKnowledgeSession(kbase);
        for (int i = 0; i < 20; ++i) {
            wm.insert((Object)new Foo(i));
            wm.insert((Object)new Bar(i));
        }
        wm.fireAllRules();
        System.out.println(counter + ":" + (counter == 20 ? "passed" : "failed"));
    }

    public static void incCounter() {
        ++counter;
    }

    public static class Bar
    implements Serializable {
        private final int id;

        public Bar(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }

    public static class Foo
    implements Serializable {
        private final int id;

        public Foo(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

