/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.mvel.CommonTestMethodBase;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.KieSession;

public class DynamicRuleRemovalTest
extends CommonTestMethodBase {
    @Test
    public void testDynamicRuleRemoval() throws Exception {
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        this.addRule(kbase, "rule1");
        this.addRule(kbase, "rule2");
        this.addRule(kbase, "rule3");
        KieSession ksession = kbase.newKieSession();
        ArrayList rulesList = new ArrayList();
        ksession.setGlobal("list", rulesList);
        ksession.insert((Object)"2");
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)rulesList.size());
        Assert.assertTrue((boolean)rulesList.contains("rule1"));
        Assert.assertTrue((boolean)rulesList.contains("rule2"));
        Assert.assertTrue((boolean)rulesList.contains("rule3"));
        this.removeRule(kbase, "rule1");
        rulesList.clear();
        ksession.insert((Object)"3");
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)rulesList.size());
        Assert.assertFalse((boolean)rulesList.contains("rule1"));
        Assert.assertTrue((boolean)rulesList.contains("rule2"));
        Assert.assertTrue((boolean)rulesList.contains("rule3"));
    }

    private void addRule(InternalKnowledgeBase kbase, String ruleName) {
        String rule = this.createDRL(ruleName);
        kbase.addPackages(this.loadKnowledgePackagesFromString(rule));
    }

    private void removeRule(InternalKnowledgeBase kbase, String ruleName) {
        kbase.removeRule("org.kie.test", ruleName);
    }

    private String createDRL(String ruleName) {
        return "package org.kie.test\nglobal java.util.List list\nrule " + ruleName + "\nwhen\n   $s: String()\nthen\nlist.add( drools.getRule().getName() );\nend\n";
    }
}

