/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.marshalling.impl.ClassObjectMarshallingStrategyAcceptor;
import org.drools.core.marshalling.impl.IdentityPlaceholderResolverStrategy;
import org.drools.core.util.DroolsStreamUtils;
import org.drools.mvel.CommonTestMethodBase;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.compiler.FactA;
import org.drools.mvel.compiler.FactB;
import org.drools.mvel.compiler.Order;
import org.drools.mvel.compiler.OrderItem;
import org.drools.mvel.compiler.Person;
import org.drools.mvel.compiler.Precondition;
import org.drools.mvel.compiler.StockTick;
import org.drools.mvel.integrationtests.SerializationHelper;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.definition.KiePackage;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.io.ResourceType;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyAcceptor;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DynamicRulesTest
extends CommonTestMethodBase {
    @Test(timeout=10000L)
    public void testDynamicRuleAdditions() throws Exception {
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)SerializationHelper.serializeObject(this.loadKnowledgeBase("test_Dynamic1.drl"));
        KieSession workingMemory = this.createKnowledgeSession((KieBase)kbase);
        workingMemory.setGlobal("total", (Object)new Integer(0));
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Person bob = new Person("bob", "stilton");
        bob.setStatus("Not evaluated");
        workingMemory.insert((Object)bob);
        Cheese stilton = new Cheese("stilton", 5);
        workingMemory.insert((Object)stilton);
        Cheese cheddar = new Cheese("cheddar", 5);
        workingMemory.insert((Object)cheddar);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"stilton", list.get(0));
        Collection<KiePackage> kpkgs = SerializationHelper.serializeObject(this.loadKnowledgePackages("test_Dynamic2.drl"));
        kbase.addPackages(kpkgs);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)5L, (long)list.size());
        Assert.assertEquals((Object)"stilton", list.get(0));
        Assert.assertTrue(("cheddar".equals(list.get(1)) || "cheddar".equals(list.get(2)) ? 1 : 0) != 0);
        Assert.assertTrue(("stilton".equals(list.get(1)) || "stilton".equals(list.get(2)) ? 1 : 0) != 0);
        list.clear();
        kpkgs = SerializationHelper.serializeObject(this.loadKnowledgePackages("test_Dynamic3.drl"));
        kbase.addPackages(kpkgs);
        workingMemory.fireAllRules();
        Assert.assertEquals((String)"Rule from package 3 should have been fired", (Object)"match Person ok", (Object)bob.getStatus());
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)bob, list.get(0));
        kpkgs = SerializationHelper.serializeObject(this.loadKnowledgePackages("test_Dynamic4.drl"));
        kbase.addPackages(kpkgs);
        workingMemory.fireAllRules();
        kbase = SerializationHelper.serializeObject(kbase);
        Assert.assertEquals((String)"Rule from package 4 should have been fired", (Object)"Who likes Stilton ok", (Object)bob.getStatus());
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)bob, list.get(1));
    }

    @Test(timeout=10000L)
    public void testDynamicRuleRemovals() throws Exception {
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)SerializationHelper.serializeObject(this.loadKnowledgeBase("test_Dynamic1.drl", "test_Dynamic3.drl", "test_Dynamic4.drl"));
        Collection<KiePackage> kpkgs = SerializationHelper.serializeObject(this.loadKnowledgePackages("test_Dynamic2.drl"));
        kbase.addPackages(kpkgs);
        KieSession wm = this.createKnowledgeSession((KieBase)kbase);
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        Person bob = new Person("bob", "stilton");
        bob.setStatus("Not evaluated");
        FactHandle fh0 = wm.insert((Object)bob);
        Cheese stilton1 = new Cheese("stilton", 5);
        FactHandle fh1 = wm.insert((Object)stilton1);
        Cheese stilton2 = new Cheese("stilton", 3);
        FactHandle fh2 = wm.insert((Object)stilton2);
        Cheese stilton3 = new Cheese("stilton", 1);
        FactHandle fh3 = wm.insert((Object)stilton3);
        Cheese cheddar = new Cheese("cheddar", 5);
        FactHandle fh4 = wm.insert((Object)cheddar);
        wm.fireAllRules();
        Assert.assertEquals((long)15L, (long)list.size());
        list.clear();
        kbase.removeRule("org.drools.mvel.compiler.test", "Who likes Stilton");
        wm.update(fh0, (Object)bob);
        wm.update(fh1, (Object)stilton1);
        wm.update(fh2, (Object)stilton2);
        wm.update(fh3, (Object)stilton3);
        wm.update(fh4, (Object)cheddar);
        wm.fireAllRules();
        Assert.assertEquals((long)12L, (long)list.size());
        list.clear();
        kbase.removeRule("org.drools.mvel.compiler.test", "like cheese");
        wm.update(fh0, (Object)bob);
        wm.update(fh1, (Object)stilton1);
        wm.update(fh2, (Object)stilton2);
        wm.update(fh3, (Object)stilton3);
        wm.update(fh4, (Object)cheddar);
        wm.fireAllRules();
        Assert.assertEquals((long)8L, (long)list.size());
        list.clear();
        Cheese muzzarela = new Cheese("muzzarela", 5);
        wm.insert((Object)muzzarela);
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        list.clear();
    }

    @Test(timeout=10000L)
    public void testDynamicRuleRemovalsUnusedWorkingMemory() throws Exception {
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)SerializationHelper.serializeObject(this.loadKnowledgeBase("test_Dynamic1.drl", "test_Dynamic2.drl", "test_Dynamic3.drl", "test_Dynamic4.drl"));
        KieSession workingMemory = this.createKnowledgeSession((KieBase)kbase);
        Assert.assertEquals((long)2L, (long)kbase.getKiePackages().size());
        KiePackage knowledgePackage = null;
        for (KiePackage pkg : kbase.getKiePackages()) {
            if (!pkg.getName().equals("org.drools.mvel.compiler.test")) continue;
            knowledgePackage = pkg;
            break;
        }
        Assert.assertEquals((long)5L, (long)knowledgePackage.getRules().size());
        kbase.removeRule("org.drools.mvel.compiler.test", "Who likes Stilton");
        Assert.assertEquals((long)4L, (long)knowledgePackage.getRules().size());
        kbase.removeRule("org.drools.mvel.compiler.test", "like cheese");
        Assert.assertEquals((long)3L, (long)knowledgePackage.getRules().size());
        kbase.removeKiePackage("org.drools.mvel.compiler.test");
        Assert.assertEquals((long)1L, (long)kbase.getKiePackages().size());
    }

    @Test(timeout=10000L)
    public void testDynamicFunction() throws Exception {
        Collection<KiePackage> kpkgs = SerializationHelper.serializeObject(this.loadKnowledgePackages("test_DynamicFunction1.drl"));
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)this.loadKnowledgeBase(new String[0]);
        kbase.addPackages(kpkgs);
        kbase = SerializationHelper.serializeObject(kbase);
        KieSession workingMemory = this.createKnowledgeSession((KieBase)kbase);
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 5);
        workingMemory.insert((Object)stilton);
        workingMemory.fireAllRules();
        Assert.assertEquals((Object)new Integer(5), list.get(0));
        kbase.removeFunction("org.drools.mvel.compiler.test", "addFive");
        Cheese cheddar = new Cheese("cheddar", 5);
        workingMemory.insert((Object)cheddar);
        try {
            workingMemory.fireAllRules();
            Assert.fail((String)"Function should have been removed and NoClassDefFoundError thrown from the Consequence");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Collection<KiePackage> kpkgs2 = SerializationHelper.serializeObject(this.loadKnowledgePackages("test_DynamicFunction2.drl"));
        kbase.addPackages(kpkgs2);
        Cheese brie = new Cheese("brie", 5);
        workingMemory.insert((Object)brie);
        workingMemory.fireAllRules();
        Assert.assertEquals((Object)new Integer(6), list.get(1));
        Collection<KiePackage> kpkgs3 = SerializationHelper.serializeObject(this.loadKnowledgePackages("test_DynamicFunction3.drl"));
        kbase.addPackages(kpkgs3);
        Cheese feta = new Cheese("feta", 5);
        workingMemory.insert((Object)feta);
        workingMemory.fireAllRules();
        Assert.assertEquals((Object)new Integer(5), list.get(2));
    }

    @Test(timeout=10000L)
    public void testRemovePackage() throws Exception {
        Collection<KiePackage> kpkgs = SerializationHelper.serializeObject(this.loadKnowledgePackages("test_RemovePackage.drl"));
        String packageName = kpkgs.iterator().next().getName();
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)this.loadKnowledgeBase(new String[0]);
        kbase.addPackages(kpkgs);
        kbase = SerializationHelper.serializeObject(kbase);
        KieSession session = this.createKnowledgeSession((KieBase)kbase);
        session.insert((Object)new Precondition("genericcode", "genericvalue"));
        session.fireAllRules();
        InternalKnowledgeBase ruleBaseWM = (InternalKnowledgeBase)session.getKieBase();
        ruleBaseWM.removeKiePackage(packageName);
        kpkgs = SerializationHelper.serializeObject(this.loadKnowledgePackages("test_RemovePackage.drl"));
        ruleBaseWM.addPackages(kpkgs);
        ruleBaseWM = SerializationHelper.serializeObject(ruleBaseWM);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
        session.fireAllRules();
        ruleBaseWM.removeKiePackage(packageName);
        ruleBaseWM.addPackages(SerializationHelper.serializeObject(kpkgs));
        ruleBaseWM.removeKiePackage(packageName);
        ruleBaseWM.addPackages(SerializationHelper.serializeObject(kpkgs));
    }

    @Test(timeout=10000L)
    public void testDynamicRules() throws Exception {
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)this.loadKnowledgeBase(new String[0]);
        KieSession session = this.createKnowledgeSession((KieBase)kbase);
        Cheese a = new Cheese("stilton", 10);
        Cheese b = new Cheese("stilton", 15);
        Cheese c = new Cheese("stilton", 20);
        session.insert((Object)a);
        session.insert((Object)b);
        session.insert((Object)c);
        Collection<KiePackage> kpkgs = SerializationHelper.serializeObject(this.loadKnowledgePackages("test_DynamicRules.drl"));
        kbase.addPackages(kpkgs);
        kbase = SerializationHelper.serializeObject(kbase);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
        session.fireAllRules();
    }

    @Test(timeout=10000L)
    public void testDynamicRules2() throws Exception {
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)this.loadKnowledgeBase(new String[0]);
        KieSession session = this.createKnowledgeSession((KieBase)kbase);
        FactA a = new FactA("hello", new Integer(1), new Float(3.14));
        FactB b = new FactB("hello", new Integer(2), new Float(6.28));
        session.insert((Object)a);
        session.insert((Object)b);
        Collection<KiePackage> kpkgs = SerializationHelper.serializeObject(this.loadKnowledgePackages("test_DynamicRules2.drl"));
        kbase.addPackages(kpkgs);
        kbase = SerializationHelper.serializeObject(kbase);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
        session.fireAllRules();
    }

    @Test(timeout=10000L)
    public void testRuleBaseAddRemove() throws Exception {
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)this.loadKnowledgeBase(new String[0]);
        Collection<KiePackage> kpkgs = SerializationHelper.serializeObject(this.loadKnowledgePackages("test_Dynamic1.drl"));
        String pkgName = kpkgs.iterator().next().getName();
        kbase.addPackages(kpkgs);
        kbase.removeKiePackage(pkgName);
        kbase = SerializationHelper.serializeObject(kbase);
        kpkgs = SerializationHelper.serializeObject(this.loadKnowledgePackages("test_Dynamic1.drl"));
        pkgName = kpkgs.iterator().next().getName();
        kbase.addPackages(kpkgs);
        kbase.removeKiePackage(pkgName);
        kbase = SerializationHelper.serializeObject(kbase);
    }

    @Test(timeout=10000L)
    public void testClassLoaderSwitchsUsingConf() throws Exception {
        try {
            SubvertedClassLoader loader1 = new SubvertedClassLoader(new URL[]{this.getClass().getResource("/")}, this.getClass().getClassLoader());
            Class<?> cheeseClass = loader1.loadClass("org.drools.mvel.compiler.Cheese");
            KnowledgeBuilderConfiguration kbuilderConf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration(null, (ClassLoader[])new ClassLoader[]{loader1});
            KieBase kbase = this.loadKnowledgeBase(kbuilderConf, "test_Dynamic1.drl");
            KieSession wm = this.createKnowledgeSession(kbase);
            wm.insert(cheeseClass.newInstance());
            wm.fireAllRules();
            SubvertedClassLoader loader2 = new SubvertedClassLoader(new URL[]{this.getClass().getResource("/")}, this.getClass().getClassLoader());
            cheeseClass = loader2.loadClass("org.drools.mvel.compiler.Cheese");
            kbuilderConf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration(null, (ClassLoader[])new ClassLoader[]{loader2});
            kbase = this.loadKnowledgeBase(kbuilderConf, "test_Dynamic1.drl");
            wm = this.createKnowledgeSession(kbase);
            wm.insert(cheeseClass.newInstance());
            wm.fireAllRules();
        }
        catch (ClassCastException cce) {
            cce.printStackTrace();
            Assert.fail((String)"No ClassCastException should be raised.");
        }
    }

    @Test(timeout=10000L)
    public void testClassLoaderSwitchsUsingContext() throws Exception {
        try {
            ClassLoader original = Thread.currentThread().getContextClassLoader();
            SubvertedClassLoader loader1 = new SubvertedClassLoader(new URL[]{this.getClass().getResource("/")}, this.getClass().getClassLoader());
            Thread.currentThread().setContextClassLoader(loader1);
            Class<?> cheeseClass = loader1.loadClass("org.drools.mvel.compiler.Cheese");
            KieBase kbase = this.loadKnowledgeBase("test_Dynamic1.drl");
            KieSession wm = this.createKnowledgeSession(kbase);
            wm.insert(cheeseClass.newInstance());
            wm.fireAllRules();
            SubvertedClassLoader loader2 = new SubvertedClassLoader(new URL[]{this.getClass().getResource("/")}, this.getClass().getClassLoader());
            Thread.currentThread().setContextClassLoader(loader2);
            cheeseClass = loader2.loadClass("org.drools.mvel.compiler.Cheese");
            kbase = this.loadKnowledgeBase("test_Dynamic1.drl");
            wm = this.createKnowledgeSession(kbase);
            wm.insert(cheeseClass.newInstance());
            wm.fireAllRules();
            Thread.currentThread().setContextClassLoader(original);
        }
        catch (ClassCastException cce) {
            cce.printStackTrace();
            Assert.fail((String)"No ClassCastException should be raised.");
        }
    }

    @Test(timeout=10000L)
    public void testCollectDynamicRules() throws Exception {
        this.checkCollectWithDynamicRules("test_CollectDynamicRules1.drl");
    }

    @Test(timeout=10000L)
    public void testCollectDynamicRulesWithExistingOTN() throws Exception {
        this.checkCollectWithDynamicRules("test_CollectDynamicRules1a.drl");
    }

    private void checkCollectWithDynamicRules(String originalDrl) throws IOException, ClassNotFoundException {
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)this.loadKnowledgeBase(originalDrl);
        KieSession session = this.createKnowledgeSession((KieBase)kbase);
        ArrayList list = new ArrayList();
        session.setGlobal("results", list);
        session.insert((Object)new Cheese("stilton", 10));
        session.insert((Object)new Cheese("brie", 10));
        session.insert((Object)new Cheese("stilton", 10));
        session.insert((Object)new Cheese("muzzarela", 10));
        kbase.addPackages(this.loadKnowledgePackages("test_CollectDynamicRules2.drl"));
        session.fireAllRules();
        kbase = SerializationHelper.serializeObject(kbase);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((List)list.get(0)).size());
    }

    @Test(timeout=10000L)
    public void testDynamicNotNode() throws Exception {
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)this.loadKnowledgeBase("test_CollectDynamicRules1.drl");
        kbase = SerializationHelper.serializeObject(kbase);
        Environment env = EnvironmentFactory.newEnvironment();
        env.set("org.kie.api.marshalling.ObjectMarshallingStrategies", (Object)new ObjectMarshallingStrategy[]{new IdentityPlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT)});
        KieSession ksession = kbase.newKieSession(null, env);
        List results = new ArrayList();
        ksession.setGlobal("results", results);
        Cheese a = new Cheese("stilton", 10);
        Cheese b = new Cheese("stilton", 15);
        Cheese c = new Cheese("stilton", 20);
        ksession.insert((Object)a);
        ksession.insert((Object)b);
        ksession.insert((Object)c);
        Collection<KiePackage> kpkgs = SerializationHelper.serializeObject(this.loadKnowledgePackages("test_DynamicNotNode.drl"));
        kbase.addPackages(kpkgs);
        kbase = SerializationHelper.serializeObject(kbase);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, false);
        results = (List)ksession.getGlobal("results");
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)results.size());
        kbase.removeKiePackage("org.drools.mvel.compiler");
        ksession.retract(ksession.getFactHandle((Object)b));
        kpkgs = SerializationHelper.serializeObject(this.loadKnowledgePackages("test_DynamicNotNode.drl"));
        kbase.addPackages(kpkgs);
        kbase = SerializationHelper.serializeObject(kbase);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, false);
        results = (List)ksession.getGlobal("results");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
    }

    @Test(timeout=10000L)
    public void testDynamicRulesAddRemove() {
        try {
            InternalKnowledgeBase kbase = (InternalKnowledgeBase)this.loadKnowledgeBase("test_DynamicRulesTom.drl");
            KieSession session = this.createKnowledgeSession((KieBase)kbase);
            ArrayList results = new ArrayList();
            session.setGlobal("results", results);
            InternalFactHandle h1 = (InternalFactHandle)session.insert((Object)new Person("tom", 1));
            InternalFactHandle h2 = (InternalFactHandle)session.insert((Object)new Person("fred", 2));
            InternalFactHandle h3 = (InternalFactHandle)session.insert((Object)new Person("harry", 3));
            InternalFactHandle h4 = (InternalFactHandle)session.insert((Object)new Person("fred", 4));
            InternalFactHandle h5 = (InternalFactHandle)session.insert((Object)new Person("ed", 5));
            InternalFactHandle h6 = (InternalFactHandle)session.insert((Object)new Person("tom", 6));
            InternalFactHandle h7 = (InternalFactHandle)session.insert((Object)new Person("sreeni", 7));
            InternalFactHandle h8 = (InternalFactHandle)session.insert((Object)new Person("jill", 8));
            InternalFactHandle h9 = (InternalFactHandle)session.insert((Object)new Person("ed", 9));
            InternalFactHandle h10 = (InternalFactHandle)session.insert((Object)new Person("tom", 10));
            session.fireAllRules();
            Assert.assertEquals((long)3L, (long)results.size());
            Assert.assertTrue((boolean)results.contains(h1.getObject()));
            Assert.assertTrue((boolean)results.contains(h6.getObject()));
            Assert.assertTrue((boolean)results.contains(h10.getObject()));
            results.clear();
            kbase.addPackages(this.loadKnowledgePackages("test_DynamicRulesFred.drl"));
            session.fireAllRules();
            Assert.assertEquals((long)2L, (long)results.size());
            Assert.assertTrue((boolean)results.contains(h2.getObject()));
            Assert.assertTrue((boolean)results.contains(h4.getObject()));
            results.clear();
            kbase.removeKiePackage("tom");
            kbase.addPackages(this.loadKnowledgePackages("test_DynamicRulesEd.drl"));
            session.fireAllRules();
            Assert.assertEquals((long)2L, (long)results.size());
            Assert.assertTrue((boolean)results.contains(h5.getObject()));
            Assert.assertTrue((boolean)results.contains(h9.getObject()));
            results.clear();
            ((Person)h3.getObject()).setName("ed");
            session.update((FactHandle)h3, h3.getObject());
            session.fireAllRules();
            Assert.assertEquals((long)1L, (long)results.size());
            Assert.assertTrue((boolean)results.contains(h3.getObject()));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Should not raise any exception: " + e.getMessage()));
        }
    }

    @Test(timeout=10000L)
    public void testDynamicRuleRemovalsSubNetwork() throws Exception {
        Collection<KiePackage> kpkgs = SerializationHelper.serializeObject(this.loadKnowledgePackages("test_DynamicRulesWithSubnetwork1.drl", "test_DynamicRulesWithSubnetwork.drl"));
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)this.loadKnowledgeBase(new String[0]);
        kbase.addPackages(kpkgs);
        kpkgs = SerializationHelper.serializeObject(this.loadKnowledgePackages("test_DynamicRulesWithSubnetwork2.drl"));
        kbase.addPackages(kpkgs);
        KieSession session = this.createKnowledgeSession((KieBase)kbase);
        ArrayList list = new ArrayList();
        session.setGlobal("results", list);
        Order order = new Order();
        OrderItem item1 = new OrderItem(order, 1, "Adventure Guide Brazil", 1, 24);
        order.addItem(item1);
        FactHandle item1Fh = session.insert((Object)item1);
        OrderItem item2 = new OrderItem(order, 2, "Prehistoric Britain", 1, 15);
        order.addItem(item2);
        FactHandle item2Fh = session.insert((Object)item2);
        OrderItem item3 = new OrderItem(order, 3, "Holiday Music", 2, 9);
        order.addItem(item3);
        FactHandle item3Fh = session.insert((Object)item3);
        OrderItem item4 = new OrderItem(order, 4, "Very Best of Mick Jagger", 2, 11);
        order.addItem(item4);
        FactHandle item4Fh = session.insert((Object)item4);
        session.insert((Object)order);
        session.fireAllRules();
        Assert.assertEquals((long)11L, (long)list.size());
        kbase.removeRule("org.drools.mvel.compiler", "Apply Discount on all books");
        list.clear();
        session.update(item1Fh, (Object)item1);
        session.update(item2Fh, (Object)item2);
        session.update(item3Fh, (Object)item3);
        session.update(item4Fh, (Object)item4);
        session.fireAllRules();
        Assert.assertEquals((long)10L, (long)list.size());
        kbase.removeRule("org.drools.mvel.compiler", "like book");
        list.clear();
        session.update(item1Fh, (Object)item1);
        session.update(item2Fh, (Object)item2);
        session.update(item3Fh, (Object)item3);
        session.update(item4Fh, (Object)item4);
        session.fireAllRules();
        Assert.assertEquals((long)8L, (long)list.size());
        OrderItem item5 = new OrderItem(order, 5, "Sinatra : Vegas", 2, 5);
        FactHandle item5Fh = session.insert((Object)item5);
        session.fireAllRules();
        Assert.assertEquals((long)10L, (long)list.size());
        kbase.removeKiePackage("org.drools.mvel.compiler");
        list.clear();
        session.update(item1Fh, (Object)item1);
        session.update(item2Fh, (Object)item2);
        session.update(item3Fh, (Object)item3);
        session.update(item4Fh, (Object)item4);
        session.update(item5Fh, (Object)item5);
        session.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test(timeout=10000L)
    public void testDynamicRuleRemovalsUnusedWorkingMemorySubNetwork() throws Exception {
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)this.loadKnowledgeBase("test_DynamicRulesWithSubnetwork1.drl", "test_DynamicRulesWithSubnetwork2.drl", "test_DynamicRulesWithSubnetwork.drl");
        Assert.assertEquals((long)2L, (long)kbase.getKiePackages().size());
        Assert.assertEquals((long)4L, (long)((InternalKnowledgePackage)kbase.getPackagesMap().get("org.drools.mvel.compiler")).getRules().size());
        kbase.removeRule("org.drools.mvel.compiler", "Apply Discount on all books");
        Assert.assertEquals((long)3L, (long)((InternalKnowledgePackage)kbase.getPackagesMap().get("org.drools.mvel.compiler")).getRules().size());
        kbase.removeRule("org.drools.mvel.compiler", "like book");
        Assert.assertEquals((long)2L, (long)((InternalKnowledgePackage)kbase.getPackagesMap().get("org.drools.mvel.compiler")).getRules().size());
        kbase.removeKiePackage("org.drools.mvel.compiler");
        Assert.assertEquals((long)1L, (long)kbase.getKiePackages().size());
    }

    @Test(timeout=10000L)
    public void testRemovePackageSubNetwork() throws Exception {
        KieBase kbase = this.loadKnowledgeBase("test_DynamicRulesWithSubnetwork.drl");
        String packageName = ((KiePackage)kbase.getKiePackages().iterator().next()).getName();
        KieSession workingMemory = this.createKnowledgeSession(kbase);
        List results = new ArrayList();
        workingMemory.setGlobal("results", results);
        Order order = new Order();
        OrderItem item1 = new OrderItem(order, 1, "Adventure Guide Brazil", 1, 24);
        OrderItem item2 = new OrderItem(order, 2, "Prehistoric Britain", 1, 15);
        OrderItem item3 = new OrderItem(order, 3, "Holiday Music", 2, 9);
        OrderItem item4 = new OrderItem(order, 4, "Very Best of Mick Jagger", 2, 11);
        OrderItem item5 = new OrderItem(order, 5, "The Master and Margarita", 1, 29);
        order.addItem(item1);
        order.addItem(item2);
        order.addItem(item3);
        order.addItem(item4);
        order.addItem(item5);
        workingMemory.insert((Object)order);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)3L, (long)((List)results.get(0)).size());
        results.clear();
        InternalKnowledgeBase ruleBaseWM = (InternalKnowledgeBase)workingMemory.getKieBase();
        ruleBaseWM.removeKiePackage(packageName);
        Collection<KiePackage> kpkgs = this.loadKnowledgePackages("test_DynamicRulesWithSubnetwork.drl");
        ruleBaseWM.addPackages(SerializationHelper.serializeObject(kpkgs));
        workingMemory.fireAllRules();
        results = (List)workingMemory.getGlobal("results");
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)3L, (long)((List)results.get(0)).size());
        results.clear();
        ruleBaseWM.removeKiePackage(packageName);
        ruleBaseWM.addPackages(SerializationHelper.serializeObject(kpkgs));
        workingMemory.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)3L, (long)((List)results.get(0)).size());
        results.clear();
        ruleBaseWM.removeKiePackage(packageName);
        ruleBaseWM.addPackages(SerializationHelper.serializeObject(kpkgs));
        workingMemory.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)3L, (long)((List)results.get(0)).size());
        results.clear();
    }

    @Test(timeout=10000L)
    public void testRuleBaseAddRemoveSubNetworks() throws Exception {
        try {
            InternalKnowledgeBase kbase = (InternalKnowledgeBase)this.getKnowledgeBase();
            Collection<KiePackage> kpkgs = this.loadKnowledgePackages("test_DynamicRulesWithSubnetwork.drl");
            KiePackage kpkg = (KiePackage)kpkgs.toArray()[0];
            kbase.addPackages(kpkgs);
            kbase.removeKiePackage(kpkg.getName());
            kpkgs = this.loadKnowledgePackages("test_DynamicRulesWithSubnetwork.drl");
            kpkg = (KiePackage)kpkgs.toArray()[0];
            kbase.addPackages(kpkgs);
            kbase.removeKiePackage(kpkg.getName());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Should not raise any exception");
        }
    }

    @Test(timeout=10000L)
    public void testDynamicRuleAdditionsWithEntryPoints() throws Exception {
        Collection<KiePackage> kpkgs = this.loadKnowledgePackages("test_DynamicWithEntryPoint.drl");
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)this.getKnowledgeBase();
        KieSession ksession = this.createKnowledgeSession((KieBase)kbase);
        kbase.addPackages(kpkgs);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        EntryPoint ep = ksession.getEntryPoint("in-channel");
        ep.insert((Object)new StockTick(1L, "RHT", 20.0, 10000L));
        ep.insert((Object)new StockTick(2L, "RHT", 21.0, 15000L));
        ep.insert((Object)new StockTick(3L, "RHT", 22.0, 20000L));
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)results.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testIsolatedClassLoaderWithEnumsPkgBuilder() throws Exception {
        try {
            SubvertedClassLoader loader1 = new SubvertedClassLoader(new URL[]{this.getClass().getResource("/testEnum.jar")}, this.getClass().getClassLoader());
            loader1.loadClass("org.drools.Primitives");
            loader1.loadClass("org.drools.TestEnum");
            KnowledgeBuilderConfiguration conf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration(null, (ClassLoader[])new ClassLoader[]{loader1});
            Collection<KiePackage> kpkgs = this.loadKnowledgePackages(conf, "test_EnumSerialization.drl");
            byte[] out = DroolsStreamUtils.streamOut(kpkgs);
            KieBaseConfiguration kbaseConf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration(null, (ClassLoader[])new ClassLoader[]{loader1});
            InternalKnowledgeBase kbase = (InternalKnowledgeBase)this.getKnowledgeBase(kbaseConf);
            kbase.addPackages(kpkgs);
            KieSession ksession = this.createKnowledgeSession((KieBase)kbase);
            ArrayList list = new ArrayList();
            ksession.setGlobal("list", list);
            Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
            Assert.assertEquals((long)1L, (long)list.size());
            SubvertedClassLoader loader2 = new SubvertedClassLoader(new URL[]{this.getClass().getResource("/testEnum.jar")}, this.getClass().getClassLoader());
            loader2.loadClass("org.drools.Primitives");
            loader2.loadClass("org.drools.TestEnum");
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            Collection kpkgs2 = null;
            try {
                Thread.currentThread().setContextClassLoader(loader2);
                kpkgs2 = (Collection)DroolsStreamUtils.streamIn((byte[])out);
            }
            finally {
                Thread.currentThread().setContextClassLoader(ccl);
            }
            KieBaseConfiguration kbaseConf2 = KnowledgeBaseFactory.newKnowledgeBaseConfiguration(null, (ClassLoader[])new ClassLoader[]{loader2});
            InternalKnowledgeBase kbase2 = (InternalKnowledgeBase)this.getKnowledgeBase(kbaseConf2);
            kbase2.addPackages(kpkgs2);
            ksession = this.createKnowledgeSession((KieBase)kbase2);
            list = new ArrayList();
            ksession.setGlobal("list", list);
            Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
            Assert.assertEquals((long)1L, (long)list.size());
        }
        catch (ClassCastException cce) {
            cce.printStackTrace();
            Assert.fail((String)"No ClassCastException should be raised.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testIsolatedClassLoaderWithEnumsContextClassloader() throws Exception {
        try {
            ArrayList list;
            KieSession ksession;
            SubvertedClassLoader loader1 = new SubvertedClassLoader(new URL[]{this.getClass().getResource("/testEnum.jar")}, this.getClass().getClassLoader());
            loader1.loadClass("org.drools.Primitives");
            loader1.loadClass("org.drools.TestEnum");
            byte[] out = null;
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            Collection kpkgs2 = null;
            try {
                Thread.currentThread().setContextClassLoader(loader1);
                Collection<KiePackage> kpkgs = this.loadKnowledgePackages("test_EnumSerialization.drl");
                out = DroolsStreamUtils.streamOut(kpkgs);
                InternalKnowledgeBase kbase = (InternalKnowledgeBase)this.getKnowledgeBase();
                kbase.addPackages(kpkgs);
                ksession = this.createKnowledgeSession((KieBase)kbase);
                list = new ArrayList();
                ksession.setGlobal("list", list);
                Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
                Assert.assertEquals((long)1L, (long)list.size());
            }
            finally {
                Thread.currentThread().setContextClassLoader(ccl);
            }
            SubvertedClassLoader loader2 = new SubvertedClassLoader(new URL[]{this.getClass().getResource("/testEnum.jar")}, this.getClass().getClassLoader());
            loader2.loadClass("org.drools.Primitives");
            loader2.loadClass("org.drools.TestEnum");
            ccl = Thread.currentThread().getContextClassLoader();
            kpkgs2 = null;
            try {
                Thread.currentThread().setContextClassLoader(loader2);
                kpkgs2 = (Collection)DroolsStreamUtils.streamIn((byte[])out);
                InternalKnowledgeBase kbase2 = (InternalKnowledgeBase)this.getKnowledgeBase();
                kbase2.addPackages(kpkgs2);
                ksession = this.createKnowledgeSession((KieBase)kbase2);
                list = new ArrayList();
                ksession.setGlobal("list", list);
                Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
                Assert.assertEquals((long)1L, (long)list.size());
            }
            finally {
                Thread.currentThread().setContextClassLoader(ccl);
            }
        }
        catch (ClassCastException cce) {
            cce.printStackTrace();
            Assert.fail((String)"No ClassCastException should be raised.");
        }
    }

    @Test(timeout=10000L)
    public void testDynamicRuleRemovalsSubNetworkAndNot() throws Exception {
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)this.loadKnowledgeBase("test_DynamicRulesWithNotSubnetwork.drl");
        KieSession ksession = this.createKnowledgeSession((KieBase)kbase);
        AgendaEventListener alistener = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(alistener);
        ksession.insert((Object)new Person("toni"));
        ksession.fireAllRules();
        ((AgendaEventListener)Mockito.verify((Object)alistener, (VerificationMode)Mockito.never())).matchCreated((MatchCreatedEvent)ArgumentMatchers.any(MatchCreatedEvent.class));
        ksession.insert((Object)new Person("bob"));
        ksession.fireAllRules();
        ((AgendaEventListener)Mockito.verify((Object)alistener, (VerificationMode)Mockito.times((int)1))).matchCreated((MatchCreatedEvent)ArgumentMatchers.any(MatchCreatedEvent.class));
        ksession.insert((Object)new Person("mark"));
        ksession.fireAllRules();
        ((AgendaEventListener)Mockito.verify((Object)alistener, (VerificationMode)Mockito.times((int)1))).matchCreated((MatchCreatedEvent)ArgumentMatchers.any(MatchCreatedEvent.class));
        kbase.removeKiePackage("org.drools.mvel.compiler");
        Assert.assertEquals((long)0L, (long)kbase.getKiePackages().size());
        Collection<KiePackage> kpkgs = this.loadKnowledgePackages("test_DynamicRulesWithNotSubnetwork.drl");
        kbase.addPackages(kpkgs);
        ksession.fireAllRules();
        ((AgendaEventListener)Mockito.verify((Object)alistener, (VerificationMode)Mockito.times((int)2))).matchCreated((MatchCreatedEvent)ArgumentMatchers.any(MatchCreatedEvent.class));
    }

    @Test
    public void testSharedLIANodeRemoval() throws Exception {
        String str = "global java.util.List list;\n";
        str = str + "rule \"test\"\n";
        str = str + "when\n";
        str = str + "  exists(eval(true))\n";
        str = str + "then\n";
        str = str + " list.add(\"fired\");\n";
        str = str + "end\n";
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)this.getKnowledgeBase();
        Collection<KiePackage> kpkgs = SerializationHelper.serializeObject(this.loadKnowledgePackagesFromString(str));
        kbase.addPackages(kpkgs);
        ArrayList list = new ArrayList();
        KieSession session = this.createKnowledgeSession((KieBase)kbase);
        session.setGlobal("list", list);
        session.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        list.clear();
        KiePackage kpkg = (KiePackage)kpkgs.toArray()[0];
        kbase.removeKiePackage(kpkg.getName());
        kbase.addPackages(kpkgs);
        session = this.createKnowledgeSession((KieBase)kbase);
        session.setGlobal("list", list);
        session.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test(timeout=10000L)
    public void testDynamicRulesWithTypeDeclarations() {
        String type = "package com.sample\ndeclare type Foo\n  id : int\nend\n";
        String r1 = "package com.sample\nrule R1 when\n  not Foo()\nthen\n  insert( new Foo(1) );\nend\n";
        String r2 = "package com.sample\nrule R2 when\n  $f : Foo()\nthen\n  $f.setId( 2 );\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])type.getBytes()), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)this.getKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        KieSession ksession = kbase.newKieSession();
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(ael);
        ksession.fireAllRules();
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.never())).afterMatchFired((AfterMatchFiredEvent)ArgumentMatchers.any(AfterMatchFiredEvent.class));
        kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KieBase)kbase);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])r1.getBytes()), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        ksession.fireAllRules();
        ArgumentCaptor capt = ArgumentCaptor.forClass(AfterMatchFiredEvent.class);
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)1))).afterMatchFired((AfterMatchFiredEvent)capt.capture());
        MatcherAssert.assertThat((Object)"R1", (Matcher)CoreMatchers.is((Object)((AfterMatchFiredEvent)capt.getValue()).getMatch().getRule().getName()));
        kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KieBase)kbase);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])r2.getBytes()), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        ksession.fireAllRules();
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)2))).afterMatchFired((AfterMatchFiredEvent)capt.capture());
        MatcherAssert.assertThat((Object)"R2", (Matcher)CoreMatchers.is((Object)((AfterMatchFiredEvent)capt.getAllValues().get(2)).getMatch().getRule().getName()));
        ksession.dispose();
    }

    @Test(timeout=10000L)
    public void testJBRULES_2206() {
        KieBaseConfiguration config = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        ((RuleBaseConfiguration)config).setRuleBaseUpdateHandler(null);
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)this.getKnowledgeBase(config);
        KieSession session = this.createKnowledgeSession((KieBase)kbase);
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        session.addEventListener(ael);
        for (int i = 0; i < 5; ++i) {
            session.insert((Object)new Cheese());
        }
        kbase.addPackages(this.loadKnowledgePackages("test_JBRULES_2206_1.drl"));
        ((InternalAgenda)session.getAgenda()).evaluateEagerList();
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)2))).matchCreated((MatchCreatedEvent)ArgumentMatchers.any(MatchCreatedEvent.class));
        int fireCount = session.fireAllRules();
        Assert.assertEquals((long)2L, (long)fireCount);
        kbase.addPackages(this.loadKnowledgePackages("test_JBRULES_2206_2.drl"));
        ((InternalAgenda)session.getAgenda()).evaluateEagerList();
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)3))).matchCreated((MatchCreatedEvent)ArgumentMatchers.any(MatchCreatedEvent.class));
        fireCount = session.fireAllRules();
        Assert.assertEquals((long)1L, (long)fireCount);
        session.dispose();
    }

    @Test
    public void testSegmentMerging() {
        String drl1 = "global java.util.List list\nrule R1 when\n  $s : String()\n  $i : Integer( this == $s.length() )\n  $j : Integer( this == $i * 2 )\nthen\n  list.add( $j );\nend\n";
        String drl2 = "global java.util.List list\nrule R2 when\n  $s : String()\n  $i : Integer( this == $s.length() )\n  $j : Integer( this == $i * 3 )\nthen\n  list.add( $j );\nend\n";
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)this.getKnowledgeBase();
        kbase.addPackages(this.loadKnowledgePackagesFromString(drl1));
        KieSession ksession = this.createKnowledgeSession((KieBase)kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"test");
        ksession.insert((Object)4);
        ksession.insert((Object)8);
        ksession.insert((Object)12);
        ksession.fireAllRules();
        Assert.assertEquals((long)8L, (long)((Integer)list.get(0)).intValue());
        list.clear();
        kbase.addPackages(this.loadKnowledgePackagesFromString(drl2));
        kbase.removeRule("defaultpkg", "R1");
        ksession.fireAllRules();
        Assert.assertEquals((long)12L, (long)((Integer)list.get(0)).intValue());
    }

    public class SubvertedClassLoader
    extends URLClassLoader {
        private static final long serialVersionUID = 510L;

        public SubvertedClassLoader(URL[] urls, ClassLoader parentClassLoader) {
            super(urls, parentClassLoader);
        }

        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                try {
                    c = this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    c = super.loadClass(name, resolve);
                }
            }
            return c;
        }
    }
}

