/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.mvel.CommonTestMethodBase;
import org.drools.mvel.compiler.Triangle;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.builder.Results;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.utils.KieHelper;

public class EnumTest
extends CommonTestMethodBase {
    @Test
    public void testEnums() throws Exception {
        KieSession ksession = this.genSession("test_Enums.drl");
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)list.contains(4));
        Assert.assertTrue((boolean)list.contains(5.976E24));
        Assert.assertTrue((boolean)list.contains("Mercury"));
        ksession.dispose();
    }

    @Test
    public void testEnumsWithCompositeBuildingProcess() throws Exception {
        String drl = "package org.test; declare enum DaysOfWeek     SUNDAY, MONDAY, TUESDAY, WEDNESDAY, THURSDAY, FRIDAY, SATURDAY;\nend\ndeclare Test   field: DaysOfWeek end";
        KieHelper kieHelper = new KieHelper();
        kieHelper.addContent("package org.test; declare enum DaysOfWeek     SUNDAY, MONDAY, TUESDAY, WEDNESDAY, THURSDAY, FRIDAY, SATURDAY;\nend\ndeclare Test   field: DaysOfWeek end", ResourceType.DRL);
        Results res = kieHelper.verify();
        Assert.assertEquals((long)0L, (long)res.getMessages().size());
    }

    @Test
    public void testQueryEnum() {
        String str = "package org.kie.test;\n\ndeclare enum Ennumm\n  ONE, TWO;\nend\n\ndeclare Bean\n  fld : Ennumm\nend\n\nquery seeWhat( Ennumm $e, Bean $b )\n  $b := Bean( $e == Ennumm.ONE )\nend\n\nrule rool\nwhen\nthen\n  insert( new Bean( Ennumm.ONE ) );\nend\n\n\nrule rool2\nwhen\n  seeWhat( $ex, $bx ; )\nthen\n  System.out.println( $bx );\nend";
        String str2 = "package org.drools.mvel.compiler.test2; \ndeclare Naeb \n   fld : String \nend \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])"package org.kie.test;\n\ndeclare enum Ennumm\n  ONE, TWO;\nend\n\ndeclare Bean\n  fld : Ennumm\nend\n\nquery seeWhat( Ennumm $e, Bean $b )\n  $b := Bean( $e == Ennumm.ONE )\nend\n\nrule rool\nwhen\nthen\n  insert( new Bean( Ennumm.ONE ) );\nend\n\n\nrule rool2\nwhen\n  seeWhat( $ex, $bx ; )\nthen\n  System.out.println( $bx );\nend".getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        KnowledgeBuilder kbuilder2 = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder2.add(ResourceFactory.newByteArrayResource((byte[])"package org.drools.mvel.compiler.test2; \ndeclare Naeb \n   fld : String \nend \n".getBytes()), ResourceType.DRL);
        if (kbuilder2.hasErrors()) {
            Assert.fail((String)kbuilder2.getErrors().toString());
        }
        kbase.addPackages(kbuilder2.getKnowledgePackages());
        KieSession ksession = kbase.newKieSession();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])"package org.drools.mvel.compiler.test2; \ndeclare Naeb \n   fld : String \nend \n".getBytes()), ResourceType.DRL);
        ksession.fireAllRules();
        ksession.dispose();
    }

    @Test
    public void testInnerEnum() throws Exception {
        StringBuilder rule = new StringBuilder();
        rule.append("package org.drools.mvel.compiler\n");
        rule.append("rule X\n");
        rule.append("when\n");
        rule.append("    Triangle( type == Triangle.Type.UNCLASSIFIED )\n");
        rule.append("then\n");
        rule.append("end\n");
        KieBase kbase = this.loadKnowledgeBaseFromString(rule.toString());
        KieSession ksession = this.createKnowledgeSession(kbase);
        ksession.insert((Object)new Triangle());
        int rules = ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)rules);
        ksession.dispose();
    }
}

