/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.drools.compiler.lang.api.AbstractClassTypeDeclarationBuilder;
import org.drools.compiler.lang.api.DescrFactory;
import org.drools.compiler.lang.api.PackageDescrBuilder;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.io.impl.ByteArrayResource;
import org.drools.mvel.CommonTestMethodBase;
import org.drools.mvel.DrlDumper;
import org.drools.mvel.compiler.Cheese;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.definition.type.FactType;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.ClassObjectFilter;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.utils.KieHelper;

public class ExtendsTest
extends CommonTestMethodBase {
    @Test
    public void testExtends() throws Exception {
        KieSession ksession = this.genSession("test_Extends.drl");
        FactType person = ksession.getKieBase().getFactType("defaultpkg", "Person");
        FactType eqPair = ksession.getKieBase().getFactType("defaultpkg", "EqualityPair");
        Object p = person.newInstance();
        Assert.assertNotNull((Object)p);
        ksession.insert((Object)"Populate");
        ksession.fireAllRules();
        Assert.assertEquals((long)6L, (long)ksession.getObjects((ObjectFilter)new ClassObjectFilter(person.getFactClass())).size());
        Assert.assertEquals((long)10L, (long)ksession.getObjects((ObjectFilter)new ClassObjectFilter(eqPair.getFactClass())).size());
        ksession.dispose();
    }

    @Test
    public void testGeneratedMethods() throws Exception {
        KieSession ksession = this.genSession("test_Extends.drl");
        FactType student = ksession.getKieBase().getFactType("defaultpkg", "Student");
        Constructor constructor = student.getFactClass().getConstructor(String.class, Integer.TYPE, String.class);
        Assert.assertNotNull(constructor);
        Method equals = student.getFactClass().getMethod("equals", Object.class);
        Assert.assertNotNull((Object)equals);
        Object s1 = constructor.newInstance("John", 18, "Skool");
        Assert.assertNotNull(s1);
        Assert.assertEquals((Object)"Student( name=John, age=18, school=Skool )", (Object)s1.toString());
        Object s2 = constructor.newInstance("John", 25, "Skool");
        Assert.assertNotNull(s2);
        Assert.assertEquals((Object)"Student( name=John, age=25, school=Skool )", (Object)s2.toString());
        Assert.assertEquals((long)s1.hashCode(), (long)s2.hashCode());
        Assert.assertTrue((boolean)((Boolean)equals.invoke(s1, s2)));
        Assert.assertTrue((boolean)s1.equals(s2));
        Object s3 = constructor.newInstance("Mark", 18, "Skool");
        Assert.assertNotNull(s3);
        Assert.assertEquals((Object)"Student( name=Mark, age=18, school=Skool )", (Object)s3.toString());
        Assert.assertNotSame((Object)s1.hashCode(), (Object)s3.hashCode());
        Assert.assertNotSame((Object)s2.hashCode(), (Object)s3.hashCode());
        Assert.assertFalse((boolean)s1.equals(s3));
        Assert.assertFalse((boolean)s2.equals(s3));
        Object s4 = constructor.newInstance("John", 25, "AnotherSkool");
        Assert.assertNotNull(s4);
        Assert.assertEquals((Object)"Student( name=John, age=25, school=AnotherSkool )", (Object)s4.toString());
        Assert.assertNotSame((Object)s1.hashCode(), (Object)s4.hashCode());
        Assert.assertNotSame((Object)s2.hashCode(), (Object)s4.hashCode());
        Assert.assertNotSame((Object)s3.hashCode(), (Object)s4.hashCode());
        Assert.assertFalse((boolean)s1.equals(s4));
        Assert.assertFalse((boolean)s2.equals(s4));
        Assert.assertFalse((boolean)s3.equals(s4));
        ksession.dispose();
    }

    @Test
    public void testDeepExt() throws Exception {
        KieSession ksession = this.genSession("test_Extends.drl");
        FactType LTstudent = ksession.getKieBase().getFactType("defaultpkg", "LongTermStudent");
        Constructor constructor = LTstudent.getFactClass().getConstructor(String.class, Integer.TYPE, String.class, String.class, Integer.TYPE);
        Assert.assertNotNull(constructor);
        Object ls1 = constructor.newInstance("John", 18, "Skool", "C1245", 4);
        Object ls2 = constructor.newInstance("John", 33, "Skool", "C1421", 4);
        Assert.assertEquals(ls1, ls2);
        ksession.dispose();
    }

    @Test
    public void testIllegalExtendsLegacy() throws Exception {
        this.genSession("test_ExtLegacyIllegal.drl", 7);
    }

    @Test
    public void testExtendsLegacy() throws Exception {
        KieSession ksession = this.genSession("test_ExtLegacy.drl", 0);
        FactType leg = ksession.getKieBase().getFactType("org.drools.compiler", "BetterLegacy");
        Assert.assertNotNull((Object)leg);
        Object b = leg.newInstance();
        Assert.assertEquals((Object)3.3, (Object)leg.get(b, "doubleField"));
        Assert.assertNull((Object)leg.get(b, "objField"));
        Assert.assertEquals((Object)245, (Object)leg.get(b, "intField"));
        Assert.assertEquals((Object)"XX", (Object)leg.get(b, "strField"));
        Assert.assertEquals((Object)true, (Object)leg.get(b, "prop"));
        Assert.assertEquals((Object)"Hello", (Object)leg.get(b, "oneMoreField"));
        System.out.println(b);
    }

    @Test
    public void testExtendsAcrossFiles() throws Exception {
        KieSession ksession = new KieHelper().addResource(ResourceFactory.newClassPathResource((String)"test_Ext1.drl", this.getClass()), ResourceType.DRL).addResource(ResourceFactory.newClassPathResource((String)"test_Ext2.drl", this.getClass()), ResourceType.DRL).addResource(ResourceFactory.newClassPathResource((String)"test_Ext3.drl", this.getClass()), ResourceType.DRL).addResource(ResourceFactory.newClassPathResource((String)"test_Ext4.drl", this.getClass()), ResourceType.DRL).build(new KieBaseOption[0]).newKieSession();
        FactType person = ksession.getKieBase().getFactType("org.drools.mvel.compiler.ext.test", "Person");
        Assert.assertNotNull((Object)person);
        FactType student = ksession.getKieBase().getFactType("org.drools.mvel.compiler.ext.test", "Student");
        Assert.assertNotNull((Object)student);
        FactType worker = ksession.getKieBase().getFactType("org.drools.mvel.compiler.anothertest", "Worker");
        Assert.assertNotNull((Object)worker);
        FactType ltss = ksession.getKieBase().getFactType("defaultpkg", "SubLTStudent");
        Assert.assertNotNull((Object)ltss);
        Constructor ctor = worker.getFactClass().getConstructor(String.class, Integer.TYPE, String.class, Double.TYPE, Integer.TYPE);
        Assert.assertNotNull(ctor);
        Object w = ctor.newInstance("Adam", 20, "Carpenter", 150.0, 40);
        System.out.println(w);
        Assert.assertEquals((Object)"Adam", (Object)worker.get(w, "name"));
        ksession.fireAllRules();
    }

    @Test
    public void testFieldInit() throws Exception {
        KieSession ksession = this.genSession("test_ExtFieldInit.drl");
        FactType test = ksession.getKieBase().getFactType("org.drools.compiler", "MyBean3");
        Object x = test.newInstance();
        Assert.assertNotNull((Object)x);
        Assert.assertEquals((Object)12, (Object)test.get(x, "fieldint"));
        Assert.assertEquals((Object)"xyz", (Object)test.get(x, "fieldstr"));
        Assert.assertEquals((Object)3.23, (Object)test.get(x, "fielddbl"));
        Assert.assertEquals((Object)0, (Object)test.get(x, "field0"));
        Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)test.get(x, "field1"));
        Assert.assertEquals((Object)Float.valueOf(1.2f), (Object)test.get(x, "fieldflt"));
        short sht = 2;
        Assert.assertEquals((Object)sht, (Object)test.get(x, "fieldsht"));
        Assert.assertEquals((Object)0, (Object)test.get(x, "field2"));
        byte byt = 1;
        Assert.assertEquals((Object)byt, (Object)test.get(x, "fieldbyt"));
        Assert.assertEquals((Object)true, (Object)test.get(x, "fieldbln"));
        Assert.assertEquals((Object)Character.valueOf('x'), (Object)test.get(x, "fieldchr"));
        Assert.assertEquals((Object)9999L, (Object)test.get(x, "fieldlng"));
        System.out.println(x);
    }

    @Test
    public void testBoxedFieldInit() throws Exception {
        KieSession ksession = this.genSession("test_ExtFieldInit.drl");
        FactType test = ksession.getKieBase().getFactType("org.drools.compiler", "MyBoxBean");
        Object x = test.newInstance();
        Assert.assertNotNull((Object)x);
        Assert.assertEquals((Object)12, (Object)test.get(x, "fieldint"));
        Assert.assertEquals((Object)3.23, (Object)test.get(x, "fielddbl"));
        Assert.assertEquals((Object)Float.valueOf(1.2f), (Object)test.get(x, "fieldflt"));
        short sht = 2;
        Assert.assertEquals((Object)sht, (Object)test.get(x, "fieldsht"));
        byte byt = 1;
        Assert.assertEquals((Object)byt, (Object)test.get(x, "fieldbyt"));
        Assert.assertEquals((Object)true, (Object)test.get(x, "fieldbln"));
        Assert.assertEquals((Object)Character.valueOf('x'), (Object)test.get(x, "fieldchr"));
        Assert.assertEquals((Object)9999L, (Object)test.get(x, "fieldlng"));
        System.out.println(x);
    }

    @Test
    public void testExpressionFieldInit() throws Exception {
        KieSession ksession = this.genSession("test_ExtFieldInit.drl");
        FactType test = ksession.getKieBase().getFactType("org.drools.compiler", "MyBoxExpressionBean");
        Object x = test.newInstance();
        Assert.assertNotNull((Object)x);
        Assert.assertEquals((Object)"foobar", (Object)test.get(x, "f0"));
        Assert.assertEquals((Object)-32, (Object)test.get(x, "fieldint"));
        Assert.assertEquals((Object)4.0, (Object)test.get(x, "fielddbl"));
        Assert.assertEquals((Object)Float.valueOf(0.5f), (Object)test.get(x, "fieldflt"));
        short sht = 6;
        Assert.assertEquals((Object)sht, (Object)test.get(x, "fieldsht"));
        byte byt = 2;
        Assert.assertEquals((Object)byt, (Object)test.get(x, "fieldbyt"));
        Assert.assertEquals((Object)true, (Object)test.get(x, "fieldbln"));
        Assert.assertEquals((Object)Character.valueOf('x'), (Object)test.get(x, "fieldchr"));
        Assert.assertEquals((Object)9999L, (Object)test.get(x, "fieldlng"));
        System.out.println(x);
        FactType test2 = ksession.getKieBase().getFactType("org.drools.compiler", "MySimpleExpressionBean");
        x = test2.newInstance();
        Assert.assertNotNull((Object)x);
        Assert.assertEquals((Object)"foobar", (Object)test2.get(x, "f0"));
        Assert.assertEquals((Object)-32, (Object)test2.get(x, "fieldint"));
        Assert.assertEquals((Object)4.0, (Object)test2.get(x, "fielddbl"));
        Assert.assertEquals((Object)Float.valueOf(0.5f), (Object)test2.get(x, "fieldflt"));
        sht = 6;
        Assert.assertEquals((Object)sht, (Object)test2.get(x, "fieldsht"));
        byt = 2;
        Assert.assertEquals((Object)byt, (Object)test2.get(x, "fieldbyt"));
        Assert.assertEquals((Object)true, (Object)test2.get(x, "fieldbln"));
        Assert.assertEquals((Object)Character.valueOf('x'), (Object)test2.get(x, "fieldchr"));
        Assert.assertEquals((Object)9999L, (Object)test2.get(x, "fieldlng"));
        System.out.println(x);
    }

    @Test
    public void testHierarchy() throws Exception {
        KieSession ksession = this.genSession("test_ExtHierarchy.drl");
        ksession.setGlobal("list", new LinkedList());
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)((List)ksession.getGlobal("list")).size());
    }

    @Test
    public void testExtendOverride() {
        String drl = "package test.beans;\n\nimport java.util.List;\nimport java.util.ArrayList;\n\nglobal List ans;\n\ndeclare ArrayList\nend\ndeclare Bean extends ArrayList\n  fld : int = 4 \n  myField : String = \"xxx\" \nend\n\ndeclare Bean2 extends Bean\n  moref : double\n  myField : String\nend\nrule \"Init\"\nwhen\nthen\n  Bean b = new Bean2();\n  ans.add(b);  System.out.println(b);\t\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ByteArrayResource(drl.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        KieSession ksession = this.createKnowledgeSession((KieBase)kbase);
        ArrayList out = new ArrayList();
        ksession.setGlobal("ans", out);
        ksession.fireAllRules();
        Object x = out.get(0);
        FactType type = kbase.getFactType("test.beans", "Bean2");
        Assert.assertEquals((Object)4, (Object)type.get(x, "fld"));
        Assert.assertEquals((Object)"xxx", (Object)type.get(x, "myField"));
        Assert.assertEquals((Object)0.0, (Object)type.get(x, "moref"));
        Assert.assertTrue((boolean)(x instanceof ArrayList));
    }

    @Test
    public void testRedefineDefaults() throws Exception {
        KieSession ksession = this.genSession("test_Extends.drl");
        FactType person = ksession.getKieBase().getFactType("defaultpkg", "Person");
        FactType student = ksession.getKieBase().getFactType("defaultpkg", "Student");
        Object p = person.newInstance();
        Object s = student.newInstance();
        Assert.assertNotNull((Object)p);
        Assert.assertNotNull((Object)s);
        Assert.assertEquals((Object)99, (Object)person.get(p, "age"));
        Assert.assertEquals((Object)18, (Object)person.get(s, "age"));
        ksession.dispose();
    }

    @Test
    public void testExtendFromOtherPackage() throws Exception {
        String s1 = "package org.drools.mvel.compiler.test.pack1;\n\ndeclare Base\n  id    : int\nend\n\ndeclare Sub extends Base\n  field : int\nend\n";
        String s2 = "package org.drools.mvel.compiler.test.pack2;\n\nimport org.drools.mvel.compiler.test.pack1.Base;\nimport org.drools.mvel.compiler.test.pack1.Sub;\n\ndeclare Sub end\n\ndeclare SubChild extends Sub\n  field2 : int\nend\n\nrule \"Init\"\nwhen\nthen\n  insert( new SubChild( 1, 2, 3 ) );\nend\n\nrule \"Touch Base\"\nwhen\n  $b : Base()\nthen\n  System.out.println( $b );\nend \nrule \"Touch Base 2\"\nwhen\n  $c : Sub()\nthen\n  System.out.println( $c );\nend";
        KieSession kSession = new KieHelper().addContent(s1, ResourceType.DRL).addContent(s2, ResourceType.DRL).build(new KieBaseOption[0]).newKieSession();
        Assert.assertEquals((long)3L, (long)kSession.fireAllRules());
    }

    @Test
    public void testInheritAnnotationsInOtherPackage() throws Exception {
        String s1 = "package org.drools.mvel.compiler.test.pack1;\nglobal java.util.List list;\ndeclare Event\n@role(event)  id    : int\nend\n\nrule \"X\"\nwhen\n  $s1 : Event()\nthen\n  System.out.println( $s1 );\n  list.add( $s1.getId() );\n end";
        String s2 = "package org.drools.mvel.compiler.test.pack2;\n\nimport org.drools.mvel.compiler.test.pack1.Event;\nglobal java.util.List list;\ndeclare Event end\n\ndeclare SubEvent extends Event\nend\n\nrule \"Init\"\nwhen\nthen\n  list.add( 0 );\n  insert( new SubEvent( 1 ) );\n  insert( new SubEvent( 2 ) );\nend\n\nrule \"Seq\"\nwhen\n  $s1 : SubEvent( id == 1 )\n  $s2 : SubEvent( id == 2, this after[0,10s] $s1 )\nthen\n  list.add( 3 );\n  System.out.println( $s1 + \" after \" + $s1 );\nend \n\nrule \"Seq 2 \"\nwhen\n  $s1 : Event( id == 1 )\n  $s2 : Event( id == 2, this after[0,10s] $s1 )\nthen\n  list.add( 4 );\n  System.out.println( $s1 + \" after II \" + $s1 );\nend";
        KieSession kSession = new KieHelper().addContent(s1, ResourceType.DRL).addContent(s2, ResourceType.DRL).build(new KieBaseOption[0]).newKieSession();
        ArrayList list = new ArrayList();
        kSession.setGlobal("list", list);
        kSession.fireAllRules();
        for (Object o : kSession.getObjects()) {
            FactHandle h = kSession.getFactHandle(o);
            Assert.assertTrue((boolean)(h instanceof EventFactHandle));
        }
        System.out.println(list);
        Assert.assertEquals((long)5L, (long)list.size());
        Assert.assertTrue((boolean)list.contains(0));
        Assert.assertTrue((boolean)list.contains(1));
        Assert.assertTrue((boolean)list.contains(2));
        Assert.assertTrue((boolean)list.contains(3));
        Assert.assertTrue((boolean)list.contains(4));
    }

    @Test
    public void testInheritFromClassWithDefaults() throws Exception {
        String s1 = "package org.drools.mvel.compiler;\nglobal java.util.List list;\ndeclare Car end\n\ndeclare MyCar extends Car \n miles : int\nend\n\nrule \"Init\"\nwhen\nthen\n  MyCar c = new MyCar();\n  c.setMiles( 100 );  insert( c );\nend\nrule \"Match\"\nwhen\n  MyCar( brand == \"ferrari\", expensive == true, $miles : miles ) then\n  list.add( $miles );\nend";
        KieSession kSession = new KieHelper().addContent(s1, ResourceType.DRL).build(new KieBaseOption[0]).newKieSession();
        ArrayList list = new ArrayList();
        kSession.setGlobal("list", list);
        kSession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains(100));
    }

    @Test
    public void testExtendSelf() throws Exception {
        String s1 = "package org.drools;\nglobal java.util.List list;\n\ndeclare Bean extends Bean \n foo : int @key\nend\n";
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeBuilder kBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kBuilder.add((Resource)new ByteArrayResource(s1.getBytes()), ResourceType.DRL);
        Assert.assertTrue((boolean)kBuilder.hasErrors());
    }

    @Test
    public void testExtendCircular() throws Exception {
        String s1 = "package org.drools;\nglobal java.util.List list;\n\ndeclare Bean1 extends Bean2 \n foo : int @key\nend\ndeclare Bean2 extends Bean3 \n foo : int @key\nend\ndeclare Bean3 extends Bean1 \n foo : int @key\nend\n";
        KnowledgeBuilder kBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kBuilder.add((Resource)new ByteArrayResource(s1.getBytes()), ResourceType.DRL);
        Assert.assertTrue((boolean)kBuilder.hasErrors());
        System.out.println(kBuilder.getErrors());
        Assert.assertTrue((boolean)kBuilder.getErrors().toString().contains("circular"));
    }

    @Test
    public void testExtendsDump() {
        PackageDescrBuilder pkgd = DescrFactory.newPackage();
        ((AbstractClassTypeDeclarationBuilder)((PackageDescrBuilder)((AbstractClassTypeDeclarationBuilder)pkgd.name("org.test").newDeclare().type().name("Foo").newField("id").type("int").end()).end()).newDeclare().type().name("Bar").superType("Foo").newField("val").type("int").initialValue("42").end()).end();
        String drl = new DrlDumper().dump((PackageDescr)pkgd.getDescr());
        KieBase kb = this.loadKnowledgeBaseFromString(drl);
        FactType bar = kb.getFactType("org.test", "Bar");
        try {
            Object x = bar.newInstance();
            Assert.assertEquals((Object)42, (Object)bar.get(x, "val"));
            bar.set(x, "id", (Object)1);
            Assert.assertEquals((Object)1, (Object)bar.get(x, "id"));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDeclareInheritance() throws Exception {
        String s1 = "package org.drools;\nimport org.drools.mvel.integrationtests.ExtendsTest.*;\n\ndeclare A \n @role( event ) @typesafe( false )\nend\ndeclare C @role( event ) @typesafe( false ) end \nrule R \nwhen    $x : C( this.x == 1 ) \nthen\n   System.out.println( $x ); \nend\n";
        KnowledgeBuilder kBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kBuilder.add((Resource)new ByteArrayResource(s1.getBytes()), ResourceType.DRL);
        if (kBuilder.hasErrors()) {
            System.err.println(kBuilder.getErrors());
        }
        Assert.assertFalse((boolean)kBuilder.hasErrors());
        InternalKnowledgeBase knowledgeBase = KnowledgeBaseFactory.newKnowledgeBase();
        knowledgeBase.addPackages(kBuilder.getKnowledgePackages());
        KieSession knowledgeSession = knowledgeBase.newKieSession();
        FactHandle h = knowledgeSession.insert((Object)new X());
        Assert.assertTrue((boolean)((InternalFactHandle)h).isEvent());
    }

    @Test
    public void testDeclareExtendsJavaParent() {
        String drl = "package org.drools.test; \nimport org.drools.mvel.compiler.Person; \ndeclare Student extends Person end \n";
        KnowledgeBuilder kBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kBuilder.add((Resource)new ByteArrayResource(drl.getBytes()), ResourceType.DRL);
        if (kBuilder.hasErrors()) {
            System.err.println(kBuilder.getErrors());
        }
        Assert.assertFalse((boolean)kBuilder.hasErrors());
    }

    @Test
    public void testDeclareExtendsJavaParentOuterPackaga() {
        String drl = "package org.drools.test; \nimport org.drools.mvel.integrationtests.ExtendsTest.X; \ndeclare Student extends X end \n";
        KnowledgeBuilder kBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kBuilder.add((Resource)new ByteArrayResource(drl.getBytes()), ResourceType.DRL);
        if (kBuilder.hasErrors()) {
            System.err.println(kBuilder.getErrors());
        }
        Assert.assertFalse((boolean)kBuilder.hasErrors());
    }

    @Test
    public void testDeclareExtendsMissingJavaParent() {
        String drl = "package org.drools.test; \nimport org.drools.mvel.integrationtests.ExtendsTest.Y; \ndeclare Student extends Y end \n";
        KnowledgeBuilder kBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kBuilder.add((Resource)new ByteArrayResource(drl.getBytes()), ResourceType.DRL);
        if (kBuilder.hasErrors()) {
            System.err.println(kBuilder.getErrors());
        }
        Assert.assertTrue((boolean)kBuilder.hasErrors());
    }

    @Test
    public void testDeclareExtendsWithFullyQualifiedName() {
        String drl = "package org.drools.extends.test; \ndeclare org.drools.extends.test.Foo end \ndeclare org.drools.extends.test.Bar extends org.drools.extends.test.Foo end \n";
        KieServices kieServices = KieServices.Factory.get();
        KieFileSystem kfs = kieServices.newKieFileSystem();
        kfs.write(kieServices.getResources().newByteArrayResource(drl.getBytes()).setSourcePath("test.drl").setResourceType(ResourceType.DRL));
        KieBuilder kieBuilder = kieServices.newKieBuilder(kfs);
        kieBuilder.buildAll();
        Assert.assertFalse((boolean)kieBuilder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR}));
    }

    @Test
    public void testExtendsBasic() throws Exception {
        KieBase kbase = this.loadKnowledgeBase("extend_rule_test.drl");
        KieSession session = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Cheese mycheese = new Cheese("cheddar", 4);
        FactHandle handle = session.insert((Object)mycheese);
        session.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule 4"));
        Assert.assertTrue((boolean)list.contains("rule 2b"));
        list = new ArrayList();
        session.setGlobal("list", list);
        session.delete(handle);
        Cheese mycheese2 = new Cheese("notcheddar", 4);
        FactHandle handle2 = session.insert((Object)mycheese2);
        session.fireAllRules();
        Assert.assertEquals((Object)"rule 4", list.get(0));
        Assert.assertEquals((long)1L, (long)list.size());
        list = new ArrayList();
        session.setGlobal("list", list);
        session.delete(handle2);
        Cheese mycheese3 = new Cheese("stilton", 6);
        FactHandle handle3 = session.insert((Object)mycheese3);
        session.fireAllRules();
        Assert.assertEquals((Object)"rule 3", list.get(0));
        Assert.assertEquals((long)1L, (long)list.size());
        list = new ArrayList();
        session.setGlobal("list", list);
        session.delete(handle3);
        Cheese mycheese4 = new Cheese("notstilton", 6);
        FactHandle handle4 = session.insert((Object)mycheese4);
        session.fireAllRules();
        Assert.assertTrue((((List)session.getGlobal("list")).size() == 0 ? 1 : 0) != 0);
        list = new ArrayList();
        session.setGlobal("list", list);
        session.delete(handle4);
        Cheese mycheese5 = new Cheese("stilton", 7);
        session.insert((Object)mycheese5);
        session.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void testExtendsBasic2() {
        KieBase kbase = this.loadKnowledgeBase("test_RuleExtend.drl");
        KieSession ksession = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        Cheese stilton = new Cheese("stilton", 5);
        Cheese cheddar = new Cheese("cheddar", 7);
        Cheese brie = new Cheese("brie", 5);
        ksession.insert((Object)stilton);
        ksession.insert((Object)cheddar);
        ksession.insert((Object)brie);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((Object)"stilton", results.get(0));
        Assert.assertEquals((Object)"brie", results.get(1));
    }

    public static class X
    implements C {
        private int x = 1;

        public int getX() {
            return this.x;
        }
    }

    public static interface C
    extends B {
    }

    public static interface B
    extends A {
    }

    public static interface A {
    }
}

