/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import org.drools.compiler.compiler.DroolsParserException;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.mvel.CommonTestMethodBase;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.conf.SequentialOption;
import org.kie.api.definition.KiePackage;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.builder.conf.DefaultDialectOption;
import org.kie.internal.builder.conf.KnowledgeBuilderOption;
import org.kie.internal.conf.ShareAlphaNodesOption;
import org.kie.internal.conf.ShareBetaNodesOption;
import org.kie.internal.io.ResourceFactory;

public class FailureOnRemovalTest
extends CommonTestMethodBase {
    private static final String LS = System.getProperty("line.separator");
    private static final String PACKAGE = "failure_on_removal";
    private static final String RULE_1 = "rule_1";
    private static final String RULE_2 = "rule_2";
    private static final String RULE_3 = "rule_3";
    private static final boolean SHARE_BETA_NODES = true;
    private static final boolean NOT_SHARE_BETA_NODES = false;

    @Test
    public void testWithBetaNodeSharing() throws Exception {
        this.runTest(true);
    }

    @Test
    public void testWithoutBetaNodeSharing() throws Exception {
        this.runTest(false);
    }

    private void runTest(boolean shareBetaNodes) throws Exception {
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)this.createKnowledgeBase(shareBetaNodes);
        Collection<KiePackage> rule1 = this.compileRule(RULE_1);
        kbase.addPackages(rule1);
        Collection<KiePackage> rule2 = this.compileRule(RULE_2);
        kbase.addPackages(rule2);
        kbase.removeRule(PACKAGE, RULE_1);
        KieSession ksession = this.createKnowledgeSession((KieBase)kbase);
        int fired = ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)1L, (long)fired);
        Collection<KiePackage> rule3 = this.compileRule(RULE_3);
        kbase.addPackages(rule3);
    }

    private Collection<KiePackage> compileRule(String name) throws DroolsParserException, IOException {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)this.createKnowledgeBuilderConfiguration());
        String drl = this.getDrl(name);
        StringReader drlReader = new StringReader(drl);
        kbuilder.add(ResourceFactory.newReaderResource((Reader)drlReader), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        return kbuilder.getKnowledgePackages();
    }

    private KnowledgeBuilderConfiguration createKnowledgeBuilderConfiguration() {
        KnowledgeBuilderConfiguration kconf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration(null, (ClassLoader[])new ClassLoader[]{this.getClass().getClassLoader()});
        kconf.setOption((KnowledgeBuilderOption)DefaultDialectOption.get((String)"java"));
        return kconf;
    }

    private KieBase createKnowledgeBase(boolean shareBetaNodes) {
        KieBaseConfiguration ruleBaseConfiguration = this.createKnowledgeBaseConfiguration(shareBetaNodes);
        return KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)ruleBaseConfiguration);
    }

    private KieBaseConfiguration createKnowledgeBaseConfiguration(boolean shareBetaNodes) {
        KieBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KieBaseOption)SequentialOption.NO);
        kconf.setOption((KieBaseOption)ShareAlphaNodesOption.YES);
        kconf.setOption((KieBaseOption)(shareBetaNodes ? ShareBetaNodesOption.YES : ShareBetaNodesOption.NO));
        return kconf;
    }

    private String getDrl(String name) {
        return new StringBuffer("package ").append(PACKAGE).append(LS).append("rule '").append(name).append('\'').append(LS).append("when").append(LS).append("eval (true)").append(LS).append("then").append(LS).append("end").append(LS).toString();
    }
}

