/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.drools.core.ClockType;
import org.drools.core.audit.WorkingMemoryConsoleLogger;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.mvel.CommonTestMethodBase;
import org.drools.mvel.compiler.Address;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.compiler.Cheesery;
import org.drools.mvel.compiler.FactA;
import org.drools.mvel.compiler.FactB;
import org.drools.mvel.compiler.FactC;
import org.drools.mvel.compiler.Message;
import org.drools.mvel.compiler.Order;
import org.drools.mvel.compiler.OrderItem;
import org.drools.mvel.compiler.Person;
import org.drools.mvel.compiler.SpecialString;
import org.drools.mvel.compiler.State;
import org.drools.mvel.compiler.StockTick;
import org.drools.mvel.compiler.Triangle;
import org.drools.mvel.integrationtests.SerializationHelper;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.conf.RemoveIdentitiesOption;
import org.kie.api.definition.KiePackage;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.time.SessionPseudoClock;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirstOrderLogicTest
extends CommonTestMethodBase {
    private static Logger logger = LoggerFactory.getLogger(FirstOrderLogicTest.class);

    @Override
    protected KieSession createKnowledgeSession(KieBase kbase) {
        return kbase.newKieSession();
    }

    @Test
    public void testCollect() throws Exception {
        List results = new ArrayList();
        KieBase kbase = this.loadKnowledgeBase("test_Collect.drl");
        KieSession wm = this.createKnowledgeSession(kbase);
        wm.setGlobal("results", results);
        wm.insert((Object)new Cheese("stilton", 10));
        wm.insert((Object)new Cheese("stilton", 7));
        wm.insert((Object)new Cheese("stilton", 8));
        wm.insert((Object)new Cheese("brie", 5));
        wm.insert((Object)new Cheese("provolone", 150));
        wm = SerializationHelper.getSerialisedStatefulKnowledgeSession(wm, true);
        results = (List)wm.getGlobal("results");
        wm.insert((Object)new Cheese("provolone", 20));
        wm.insert((Object)new Person("Bob", "stilton"));
        wm.insert((Object)new Person("Mark", "provolone"));
        wm = SerializationHelper.getSerialisedStatefulKnowledgeSession(wm, true);
        results = (List)wm.getGlobal("results");
        wm.fireAllRules();
        wm = SerializationHelper.getSerialisedStatefulKnowledgeSession(wm, true);
        results = (List)wm.getGlobal("results");
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)3L, (long)((Collection)results.get(0)).size());
        Assert.assertEquals((Object)ArrayList.class.getName(), (Object)results.get(0).getClass().getName());
    }

    @Test
    public void testCollectNodeSharing() throws Exception {
        KieBase kbase = this.loadKnowledgeBase("test_collectNodeSharing.drl");
        KieSession wm = this.createKnowledgeSession(kbase);
        List results = new ArrayList();
        wm.setGlobal("results", results);
        wm = SerializationHelper.getSerialisedStatefulKnowledgeSession(wm, true);
        results = (List)wm.getGlobal("results");
        wm.insert((Object)new Cheese("stilton", 10));
        wm = SerializationHelper.getSerialisedStatefulKnowledgeSession(wm, true);
        results = (List)wm.getGlobal("results");
        wm.insert((Object)new Cheese("brie", 15));
        wm.fireAllRules();
        wm = SerializationHelper.getSerialisedStatefulKnowledgeSession(wm, true);
        results = (List)wm.getGlobal("results");
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)2L, (long)((List)results.get(0)).size());
    }

    @Test
    public void testCollectModify() throws Exception {
        KieBase kbase = this.loadKnowledgeBase("test_Collect.drl");
        KieSession wm = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 2), new Cheese("stilton", 5), new Cheese("brie", 15), new Cheese("brie", 16), new Cheese("provolone", 8)};
        Person bob = new Person("Bob", "stilton");
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        FactHandle bobHandle = wm.insert((Object)bob);
        int fireCount = 0;
        wm.fireAllRules();
        Assert.assertEquals((long)(++fireCount), (long)results.size());
        Assert.assertEquals((long)3L, (long)((Collection)results.get(fireCount - 1)).size());
        Assert.assertEquals((Object)ArrayList.class.getName(), (Object)results.get(fireCount - 1).getClass().getName());
        boolean index = true;
        cheese[1].setPrice(9);
        wm.update(cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        Assert.assertEquals((long)(++fireCount), (long)results.size());
        Assert.assertEquals((long)3L, (long)((Collection)results.get(fireCount - 1)).size());
        Assert.assertEquals((Object)ArrayList.class.getName(), (Object)results.get(fireCount - 1).getClass().getName());
        bob.setLikes("brie");
        wm.update(bobHandle, (Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((long)fireCount, (long)results.size());
        wm.retract(cheeseHandles[3]);
        wm.fireAllRules();
        Assert.assertEquals((long)fireCount, (long)results.size());
    }

    @Test
    public void testCollectResultConstraints() throws Exception {
        KieBase kbase = this.loadKnowledgeBase("test_CollectResultConstraints.drl");
        KieSession wm = this.createKnowledgeSession(kbase);
        List results = new ArrayList();
        wm.setGlobal("results", results);
        wm.insert((Object)new Cheese("stilton", 10));
        wm = SerializationHelper.getSerialisedStatefulKnowledgeSession(wm, true);
        results = (List)wm.getGlobal("results");
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)1L, (long)((Collection)results.get(0)).size());
        wm.insert((Object)new Cheese("stilton", 7));
        wm.insert((Object)new Cheese("stilton", 8));
        wm.fireAllRules();
        wm = SerializationHelper.getSerialisedStatefulKnowledgeSession(wm, true);
        results = (List)wm.getGlobal("results");
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)3L, (long)((Collection)results.get(0)).size());
        Assert.assertEquals((Object)ArrayList.class.getName(), (Object)results.get(0).getClass().getName());
    }

    @Test
    public void testExistsWithBinding() throws Exception {
        KieBase kbase = this.loadKnowledgeBase("test_ExistsWithBindings.drl");
        KieSession wm = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        wm.setGlobal("results", list);
        Cheese c = new Cheese("stilton", 10);
        Person p = new Person("Mark", "stilton");
        wm.insert((Object)c);
        wm.insert((Object)p);
        wm.fireAllRules();
        Assert.assertTrue((boolean)list.contains(c.getType()));
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testNot() throws Exception {
        KieBase kbase = this.loadKnowledgeBase("not_rule_test.drl");
        KieSession wm = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 5);
        FactHandle stiltonHandle = wm.insert((Object)stilton);
        Cheese cheddar = new Cheese("cheddar", 7);
        FactHandle cheddarHandle = wm.insert((Object)cheddar);
        wm.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        wm.retract(stiltonHandle);
        wm.fireAllRules();
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertTrue((boolean)list.contains(new Integer(5)));
        Assert.assertTrue((boolean)list.contains(new Integer(6)));
        Assert.assertTrue((boolean)list.contains(new Integer(7)));
        Assert.assertTrue((boolean)list.contains(new Integer(8)));
    }

    @Test
    public void testNotWithBindings() throws Exception {
        KieBase kbase = this.loadKnowledgeBase("not_with_bindings_rule_test.drl");
        KieSession wm = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 5);
        FactHandle stiltonHandle = wm.insert((Object)stilton);
        Cheese cheddar = new Cheese("cheddar", 7);
        FactHandle cheddarHandle = wm.insert((Object)cheddar);
        Person paul = new Person("paul", "stilton", 12);
        wm.insert((Object)paul);
        wm.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        wm.retract(stiltonHandle);
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testExists() throws Exception {
        KieBase kbase = this.loadKnowledgeBase("exists_rule_test.drl");
        KieSession wm = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        Cheese cheddar = new Cheese("cheddar", 7);
        FactHandle cheddarHandle = wm.insert((Object)cheddar);
        wm.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        Cheese stilton = new Cheese("stilton", 5);
        FactHandle stiltonHandle = wm.insert((Object)stilton);
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Cheese brie = new Cheese("brie", 5);
        FactHandle brieHandle = wm.insert((Object)brie);
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testExists2() throws Exception {
        KieBase kbase = this.loadKnowledgeBase("test_exists.drl");
        KieSession workingMemory = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese cheddar = new Cheese("cheddar", 7);
        Cheese provolone = new Cheese("provolone", 5);
        Person edson = new Person("Edson", "cheddar");
        Person bob = new Person("Bob", "muzzarela");
        workingMemory.insert((Object)cheddar);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        workingMemory.insert((Object)provolone);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        workingMemory.insert((Object)edson);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        workingMemory.insert((Object)bob);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testExists3() throws Exception {
        KieBase kbase = this.loadKnowledgeBase("test_Exists_JBRULES_2810.drl");
        KieSession ksession = this.createKnowledgeSession(kbase);
        WorkingMemoryConsoleLogger logger = new WorkingMemoryConsoleLogger((KieRuntimeEventManager)ksession);
        ksession.fireAllRules();
        ksession.dispose();
    }

    @Test
    public void testForall() throws Exception {
        KieBase kbase = this.loadKnowledgeBase("test_Forall.drl");
        KieSession workingMemory = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        State state = new State("SP");
        workingMemory.insert((Object)state);
        Person bob = new Person("Bob");
        bob.setStatus(state.getState());
        bob.setLikes("stilton");
        workingMemory.insert((Object)bob);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        workingMemory.insert((Object)new Cheese(bob.getLikes(), 10));
        workingMemory.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testForall2() throws Exception {
        KieBase kbase = this.loadKnowledgeBase("test_Forall2.drl");
        KieSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        State state = new State("SP");
        ksession.insert((Object)state);
        Person bob = new Person("Bob");
        bob.setStatus(state.getState());
        bob.setAlive(true);
        ksession.insert((Object)bob);
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        State qc = new State("QC");
        ksession.insert((Object)qc);
        Person john = new Person("John");
        john.setStatus(qc.getState());
        john.setAlive(false);
        ksession.insert((Object)john);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testRemoveIdentitiesSubNetwork() throws Exception {
        KieBaseConfiguration conf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        conf.setOption((KieBaseOption)RemoveIdentitiesOption.YES);
        KieBase kbase = this.loadKnowledgeBase(conf, "test_removeIdentitiesSubNetwork.drl");
        KieSession workingMemory = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        Person bob = new Person("bob", "stilton");
        workingMemory.insert((Object)bob);
        Person mark = new Person("mark", "stilton");
        workingMemory.insert((Object)mark);
        Cheese stilton1 = new Cheese("stilton", 6);
        FactHandle stilton1Handle = workingMemory.insert((Object)stilton1);
        Cheese stilton2 = new Cheese("stilton", 7);
        FactHandle stilton2Handle = workingMemory.insert((Object)stilton2);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        workingMemory.retract(stilton1Handle);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)mark, list.get(0));
        workingMemory.retract(stilton2Handle);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)bob, list.get(1));
    }

    @Test
    public void testCollectWithNestedFromWithParams() throws Exception {
        KieBase kbase = this.loadKnowledgeBase("test_CollectWithNestedFrom.drl");
        KieSession workingMemory = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        Person bob = new Person("bob", "stilton");
        Cheesery cheesery = new Cheesery();
        cheesery.addCheese(new Cheese("stilton", 10));
        cheesery.addCheese(new Cheese("brie", 20));
        cheesery.addCheese(new Cheese("muzzarela", 8));
        cheesery.addCheese(new Cheese("stilton", 5));
        cheesery.addCheese(new Cheese("provolone", 1));
        workingMemory.insert((Object)bob);
        workingMemory.insert((Object)cheesery);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        List cheeses = (List)results.get(0);
        Assert.assertEquals((long)2L, (long)cheeses.size());
        Assert.assertEquals((Object)bob.getLikes(), (Object)((Cheese)cheeses.get(0)).getType());
        Assert.assertEquals((Object)bob.getLikes(), (Object)((Cheese)cheeses.get(1)).getType());
    }

    @Test
    public void testCollectModifyAlphaRestriction() throws Exception {
        KieBase kbase = this.loadKnowledgeBase("test_CollectAlphaRestriction.drl");
        KieSession wm = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 2), new Cheese("stilton", 5), new Cheese("brie", 15), new Cheese("brie", 16), new Cheese("provolone", 8)};
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        int fireCount = 0;
        wm.fireAllRules();
        Assert.assertEquals((long)(++fireCount), (long)results.size());
        Assert.assertEquals((long)3L, (long)((Collection)results.get(fireCount - 1)).size());
        Assert.assertEquals((Object)ArrayList.class.getName(), (Object)results.get(fireCount - 1).getClass().getName());
        boolean index = true;
        cheese[1].setType("brie");
        wm.update(cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        Assert.assertEquals((long)(++fireCount), (long)results.size());
        Assert.assertEquals((long)2L, (long)((Collection)results.get(fireCount - 1)).size());
        Assert.assertEquals((Object)ArrayList.class.getName(), (Object)results.get(fireCount - 1).getClass().getName());
        wm.retract(cheeseHandles[2]);
        wm.fireAllRules();
        Assert.assertEquals((long)(++fireCount), (long)results.size());
        Assert.assertEquals((long)1L, (long)((Collection)results.get(fireCount - 1)).size());
        Assert.assertEquals((Object)ArrayList.class.getName(), (Object)results.get(fireCount - 1).getClass().getName());
    }

    @Test
    public void testForallSinglePattern() throws Exception {
        KieBase kbase = this.loadKnowledgeBase("test_ForallSinglePattern.drl");
        KieSession workingMemory = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        int fired = 0;
        workingMemory.fireAllRules();
        Assert.assertEquals((long)(++fired), (long)list.size());
        FactHandle stilton1 = workingMemory.insert((Object)new Cheese("stilton", 10));
        workingMemory.fireAllRules();
        Assert.assertEquals((long)fired, (long)list.size());
        FactHandle stilton2 = workingMemory.insert((Object)new Cheese("stilton", 11));
        workingMemory.fireAllRules();
        Assert.assertEquals((long)fired, (long)list.size());
        workingMemory.retract(stilton1);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)fired, (long)list.size());
        FactHandle brie = workingMemory.insert((Object)new Cheese("brie", 10));
        workingMemory.fireAllRules();
        Assert.assertEquals((long)fired, (long)list.size());
        workingMemory.retract(brie);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)(++fired), (long)list.size());
        workingMemory.retract(stilton2);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)fired, (long)list.size());
    }

    @Test
    public void testForallSinglePattern2() throws Exception {
        KieBase kbase = this.loadKnowledgeBase("test_ForallSinglePattern2.drl");
        KieSession ksession = this.createKnowledgeSession(kbase);
        ksession.insert((Object)new Triangle(3, 3, 3));
        ksession.insert((Object)new Triangle(3, 3, 3));
        int fired = ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)fired);
        ksession.dispose();
    }

    @Test
    public void testMVELCollect() throws Exception {
        KieBase kbase = this.loadKnowledgeBase("test_MVELCollect.drl");
        KieSession wm = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        wm.insert((Object)new Cheese("stilton", 10));
        wm.insert((Object)new Cheese("stilton", 7));
        wm.insert((Object)new Cheese("stilton", 8));
        wm.insert((Object)new Cheese("brie", 5));
        wm.insert((Object)new Cheese("provolone", 150));
        wm.insert((Object)new Cheese("provolone", 20));
        wm.insert((Object)new Person("Bob", "stilton"));
        wm.insert((Object)new Person("Mark", "provolone"));
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)6L, (long)((List)results.get(0)).size());
    }

    @Test
    public void testNestedCorelatedRulesWithForall() throws Exception {
        KieBase kbase = this.loadKnowledgeBase("test_NestedCorrelatedRulesWithForall.drl");
        KieSession session = this.createKnowledgeSession(kbase);
        ArrayList list1 = new ArrayList();
        ArrayList list2 = new ArrayList();
        ArrayList list3 = new ArrayList();
        ArrayList list4 = new ArrayList();
        session.setGlobal("list1", list1);
        session.setGlobal("list2", list2);
        session.setGlobal("list3", list3);
        session.setGlobal("list4", list4);
        SpecialString first42 = new SpecialString("42");
        SpecialString second42 = new SpecialString("42");
        SpecialString world = new SpecialString("World");
        session.insert((Object)world);
        session.insert((Object)first42);
        session.insert((Object)second42);
        Assert.assertTrue((boolean)list1.isEmpty());
        Assert.assertTrue((boolean)list2.isEmpty());
        Assert.assertTrue((boolean)list3.isEmpty());
        Assert.assertTrue((boolean)list4.isEmpty());
        session.fireAllRules();
        Assert.assertEquals((long)0L, (long)list1.size());
        Assert.assertEquals((long)0L, (long)list2.size());
        Assert.assertEquals((long)1L, (long)list3.size());
        Assert.assertEquals((long)0L, (long)list4.size());
    }

    @Test
    public void testFromInsideNotAndExists() throws Exception {
        KieBase kbase = this.loadKnowledgeBase("test_FromInsideNotAndExists.drl");
        KieSession workingMemory = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        Cheese cheddar = new Cheese("cheddar", 7);
        Cheese provolone = new Cheese("provolone", 5);
        Cheesery cheesery = new Cheesery();
        cheesery.addCheese(cheddar);
        cheesery.addCheese(provolone);
        FactHandle handle = workingMemory.insert((Object)cheesery);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        cheesery.addCheese(new Cheese("stilton", 10));
        cheesery.removeCheese(cheddar);
        workingMemory.update(handle, (Object)cheesery);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testOr() throws Exception {
        KieBase kbase = this.loadKnowledgeBase("test_OrNesting.drl");
        KieSession workingMemory = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        Cheese cheddar = new Cheese("cheddar", 7);
        Cheese provolone = new Cheese("provolone", 5);
        Cheese brie = new Cheese("brie", 15);
        Person mark = new Person("mark", "stilton");
        FactHandle ch = workingMemory.insert((Object)cheddar);
        FactHandle ph = workingMemory.insert((Object)provolone);
        FactHandle bh = workingMemory.insert((Object)brie);
        FactHandle markh = workingMemory.insert((Object)mark);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testOrWithVariableResolution() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_OrCEFollowedByMultipleEval.drl", FirstOrderLogicTest.class), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        KieSession ksession = this.createKnowledgeSession((KieBase)kbase);
        AgendaEventListener al = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(al);
        ksession.insert((Object)new FactA("a"));
        ksession.insert((Object)new FactB("b"));
        ksession.insert((Object)new FactC("c"));
        ksession.fireAllRules();
        ((AgendaEventListener)Mockito.verify((Object)al, (VerificationMode)Mockito.times((int)6))).afterMatchFired((AfterMatchFiredEvent)ArgumentMatchers.any(AfterMatchFiredEvent.class));
    }

    @Test
    public void testOrWithVariableResolution2() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_OrCEFollowedByMultipleEval2.drl", FirstOrderLogicTest.class), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        KieSession ksession = this.createKnowledgeSession((KieBase)kbase);
        AgendaEventListener al = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(al);
        ksession.insert((Object)new FactA("a"));
        ksession.insert((Object)new FactB("b"));
        ksession.insert((Object)new FactC("c"));
        ksession.fireAllRules();
        ((AgendaEventListener)Mockito.verify((Object)al, (VerificationMode)Mockito.times((int)8))).afterMatchFired((AfterMatchFiredEvent)ArgumentMatchers.any(AfterMatchFiredEvent.class));
    }

    @Test
    public void testCollectWithMemberOfOperators() throws Exception {
        KieBase kbase = this.loadKnowledgeBase("test_CollectMemberOfOperator.drl");
        KieSession workingMemory = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        Order order1 = new Order(1, "bob");
        OrderItem item11 = new OrderItem(order1, 1);
        OrderItem item12 = new OrderItem(order1, 2);
        Order order2 = new Order(2, "mark");
        OrderItem item21 = new OrderItem(order2, 1);
        OrderItem item22 = new OrderItem(order2, 2);
        workingMemory.insert((Object)order1);
        workingMemory.insert((Object)item11);
        workingMemory.insert((Object)item12);
        workingMemory.insert((Object)order2);
        workingMemory.insert((Object)item21);
        workingMemory.insert((Object)item22);
        workingMemory.fireAllRules();
        int index = 0;
        Assert.assertEquals((long)8L, (long)list.size());
        Assert.assertSame((Object)order1, list.get(index++));
        Assert.assertSame((Object)item11, list.get(index++));
        Assert.assertSame((Object)order2, list.get(index++));
        Assert.assertSame((Object)item21, list.get(index++));
        Assert.assertSame((Object)order1, list.get(index++));
        Assert.assertSame((Object)item11, list.get(index++));
        Assert.assertSame((Object)order2, list.get(index++));
        Assert.assertSame((Object)item21, list.get(index++));
    }

    @Test
    public void testCollectWithContainsOperators() throws Exception {
        KieBase kbase = this.loadKnowledgeBase("test_CollectContainsOperator.drl");
        KieSession workingMemory = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        Order order1 = new Order(1, "bob");
        OrderItem item11 = new OrderItem(order1, 1);
        OrderItem item12 = new OrderItem(order1, 2);
        Order order2 = new Order(2, "mark");
        OrderItem item21 = new OrderItem(order2, 1);
        OrderItem item22 = new OrderItem(order2, 2);
        workingMemory.insert((Object)order1);
        workingMemory.insert((Object)item11);
        workingMemory.insert((Object)item12);
        workingMemory.insert((Object)order2);
        workingMemory.insert((Object)item21);
        workingMemory.insert((Object)item22);
        workingMemory.fireAllRules();
        int index = 0;
        Assert.assertEquals((long)8L, (long)list.size());
        Assert.assertSame((Object)order1, list.get(index++));
        Assert.assertSame((Object)item11, list.get(index++));
        Assert.assertSame((Object)order2, list.get(index++));
        Assert.assertSame((Object)item21, list.get(index++));
        Assert.assertSame((Object)order1, list.get(index++));
        Assert.assertSame((Object)item11, list.get(index++));
        Assert.assertSame((Object)order2, list.get(index++));
        Assert.assertSame((Object)item21, list.get(index++));
    }

    @Test
    public void testForallSinglePatternWithExists() throws Exception {
        KieBase kbase = this.loadKnowledgeBase("test_ForallSinglePatternWithExists.drl");
        KieSession workingMemory = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        workingMemory.insert((Object)new Cheese("stilton", 10));
        workingMemory.insert((Object)new Cheese("brie", 10));
        workingMemory.insert((Object)new Cheese("brie", 10));
        workingMemory.insert((Object)new Order(1, "bob"));
        workingMemory.insert((Object)new Person("bob", "stilton", 10));
        workingMemory.insert((Object)new Person("mark", "stilton"));
        workingMemory.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testCollectResultBetaConstraint() throws Exception {
        KieBase kbase = this.loadKnowledgeBase("test_CollectResultsBetaConstraint.drl");
        KieSession wm = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        wm.insert((Object)new Double(10.0));
        wm.insert((Object)new Integer(2));
        wm.fireAllRules();
        Assert.assertEquals((long)0L, (long)results.size());
        wm.insert((Object)new Double(15.0));
        wm.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((Object)"collect", results.get(0));
        Assert.assertEquals((Object)"accumulate", results.get(1));
    }

    @Test
    public void testFromWithOr() throws Exception {
        KieBase kbase = this.loadKnowledgeBase("test_FromWithOr.drl");
        KieSession session = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        session.setGlobal("results", results);
        Address a1 = new Address();
        a1.setZipCode("12345");
        Address a2 = new Address();
        a2.setZipCode("54321");
        Address a3 = new Address();
        a3.setZipCode("99999");
        Person p = new Person();
        p.addAddress(a1);
        p.addAddress(a2);
        p.addAddress(a3);
        session.insert((Object)p);
        session.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(a1));
        Assert.assertTrue((boolean)results.contains(a2));
    }

    @Test
    public void testForallWithSlidingWindow() throws Exception {
        KieSessionConfiguration conf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        conf.setOption((KieSessionOption)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        KieBase kbase = this.loadKnowledgeBase("test_ForallSlidingWindow.drl");
        KieSession ksession = this.createKnowledgeSession(kbase, conf);
        SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        clock.advanceTime(60L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        int seq = 1;
        ksession.insert((Object)new StockTick(seq++, "RHT", 10.0, clock.getCurrentTime()));
        clock.advanceTime(5L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        ksession.insert((Object)new StockTick(seq++, "RHT", 10.0, clock.getCurrentTime()));
        clock.advanceTime(5L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        ksession.insert((Object)new StockTick(seq++, "IBM", 10.0, clock.getCurrentTime()));
        clock.advanceTime(10L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        ksession.insert((Object)new StockTick(seq++, "RHT", 10.0, clock.getCurrentTime()));
        clock.advanceTime(10L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        ksession.insert((Object)new StockTick(seq++, "RHT", 10.0, clock.getCurrentTime()));
        clock.advanceTime(10L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
        ksession.insert((Object)new StockTick(seq++, "RHT", 10.0, clock.getCurrentTime()));
        clock.advanceTime(10L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
        clock.advanceTime(60L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
    }

    @Test
    public void testCollectFromMVELAfterOr() throws Exception {
        KieBase kbase = this.loadKnowledgeBase("test_CollectFromMVELAfterOr.drl");
        KieSession wm = this.createKnowledgeSession(kbase);
        List results = new ArrayList();
        wm.setGlobal("results", results);
        Person jill = new Person("jill");
        Person bob = new Person("bob");
        ArrayList<Address> addresses = new ArrayList<Address>();
        addresses.add(new Address("a"));
        addresses.add(new Address("b"));
        addresses.add(new Address("c"));
        bob.setAddresses(addresses);
        wm.insert((Object)jill);
        wm.insert((Object)bob);
        wm = SerializationHelper.getSerialisedStatefulKnowledgeSession(wm, true);
        results = (List)wm.getGlobal("results");
        wm.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((long)3L, (long)((Collection)results.get(0)).size());
    }

    @Test
    public void testCollectAfterOrCE() throws Exception {
        Collection<KiePackage> pkgs = this.loadKnowledgePackages("test_OrCEFollowedByCollect.drl");
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(pkgs);
        KieSession session = this.createKnowledgeSession((KieBase)kbase);
        Cheesery bonFromage = new Cheesery();
        bonFromage.addCheese(new Cheese("cheddar"));
        bonFromage.addCheese(new Cheese("cheddar"));
        session.insert((Object)bonFromage);
        int rules = session.fireAllRules();
        Assert.assertEquals((long)2L, (long)rules);
        pkgs = SerializationHelper.serializeObject(pkgs);
        kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(pkgs);
        session = this.createKnowledgeSession((KieBase)kbase);
        session.insert((Object)bonFromage);
        rules = session.fireAllRules();
        Assert.assertEquals((long)2L, (long)rules);
    }

    @Test
    public void testLotsOfOrs() throws Exception {
        String str = "package org.drools.mvel.compiler.test\n\nimport " + FirstOrderLogicTest.class.getCanonicalName() + ".Field;\n \nrule \"test\"\n    when\n        (\n            ( \n                a : Field( name == \"a\") and\n                eval( !a.getValue().equals(\"a\") ) and\n                b : Field( name == \"b\" ) and\n                eval( b.intValue()>10 )\n           )\n           or\n           (\n                b2 : Field( name == \"b\" ) and\n                eval( b2.intValue()<10 )\n           )\n        )\n        and \n        (\n            t : Field( name == \"t\" ) and\n            eval( t.getValue().equals(\"Y\") )\n        )\n        and (\n           (\n                c : Field( name == \"c\" ) and\n                eval( c.getValue().equals(\"c\") ) and\n                d : Field( name == \"d\" ) and\n                eval( d.intValue()<5 )\n           ) \n           or \n           (\n                c : Field( name == \"c\" ) and\n                eval( c.getValue().equals(\"c\") ) and\n                d : Field( name == \"d\" ) and\n                eval( d.intValue()<20 )\n           ) \n           or \n           ( \n                c : Field( name == \"c\") and\n                eval( c.getValue().equals(\"d\") ) and\n                d : Field( name == \"d\" ) and\n                eval( d.intValue()<20 )\n           )\n        )\n    then\n        System.out.println( \"Worked!\" ); \nend";
        logger.info(str);
        KieBase kbase = this.loadKnowledgeBaseFromString(str);
        KieSession ksession = this.createKnowledgeSession(kbase);
        ksession.insert((Object)new Field("t", "Y"));
        ksession.insert((Object)new Field("a", "b"));
        ksession.insert((Object)new Field("b", "15"));
        ksession.insert((Object)new Field("c", "d"));
        ksession.insert((Object)new Field("d", "15"));
        ksession.fireAllRules();
        ksession.dispose();
    }

    @Test
    public void testOrs() throws Exception {
        String str = "package org.drools.mvel.integrationtests\nimport " + Message.class.getName() + "\nrule X\n    when\n        Message( message == 'test' )\n        Message( !fired ) or eval( !false )\n    then\nend\n";
        KieBase kbase = this.loadKnowledgeBaseFromString(str);
        KieSession ksession = this.createKnowledgeSession(kbase);
        ksession.insert((Object)new Message("test"));
        int rules = ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)rules);
        ksession.dispose();
    }

    public class Field {
        private String name;
        private String value;

        public Field(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public int intValue() {
            Integer intValue = Integer.valueOf(this.value);
            return intValue;
        }
    }
}

