/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.io.File;
import java.util.HashSet;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.mvel.CommonTestMethodBase;
import org.drools.mvel.compiler.Message;
import org.drools.mvel.expr.MVELDebugHandler;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.io.ResourceType;
import org.kie.api.logger.KieRuntimeLogger;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.logger.KnowledgeRuntimeLoggerFactory;
import org.mvel2.MVELRuntime;
import org.mvel2.debug.Debugger;
import org.mvel2.debug.Frame;

public class HelloWorldTest
extends CommonTestMethodBase {
    @Test
    public void testHelloWorld() throws Exception {
        KieBase kbase = this.readKnowledgeBase();
        KieSession ksession = this.createKnowledgeSession(kbase);
        File testTmpDir = new File("target/test-tmp/");
        testTmpDir.mkdirs();
        KieRuntimeLogger logger = KnowledgeRuntimeLoggerFactory.newFileLogger((KieRuntimeEventManager)ksession, (String)"target/test-tmp/testHelloWorld");
        ksession.getAgendaEventListeners().size();
        Message message = new Message();
        message.setMessage("Hello World");
        message.setStatus(0);
        ksession.insert((Object)message);
        ksession.fireAllRules();
        logger.close();
    }

    @Test
    public void testHelloWorldDebug() throws Exception {
        final HashSet knownVariables = new HashSet();
        MVELRuntime.resetDebugger();
        MVELDebugHandler.setDebugMode((boolean)true);
        MVELRuntime.setThreadDebugger((Debugger)new Debugger(){

            public int onBreak(Frame frame) {
                System.out.println("onBreak");
                for (String var : frame.getFactory().getKnownVariables()) {
                    knownVariables.add(var);
                }
                return 0;
            }
        });
        String source = "org.drools.integrationtests.Rule_Hello_World";
        MVELRuntime.registerBreakpoint((String)source, (int)1);
        KieBase kbase = this.readKnowledgeBase();
        KieSession ksession = this.createKnowledgeSession(kbase);
        File testTmpDir = new File("target/test-tmp/");
        testTmpDir.mkdirs();
        KieRuntimeLogger logger = KnowledgeRuntimeLoggerFactory.newFileLogger((KieRuntimeEventManager)ksession, (String)"target/test-tmp/testHelloWorldDebug");
        Message message = new Message();
        message.setMessage("Hello World");
        message.setStatus(0);
        ksession.insert((Object)message);
        ksession.fireAllRules();
        logger.close();
        Assert.assertEquals((long)6L, (long)knownVariables.size());
        Assert.assertTrue((boolean)knownVariables.contains("drools"));
        Assert.assertTrue((boolean)knownVariables.contains("myMessage"));
        Assert.assertTrue((boolean)knownVariables.contains("rule"));
        Assert.assertTrue((boolean)knownVariables.contains("kcontext"));
        Assert.assertTrue((boolean)knownVariables.contains("this"));
        Assert.assertTrue((boolean)knownVariables.contains("m"));
        Assert.assertTrue((boolean)knownVariables.contains("myMessage"));
    }

    private KieBase readKnowledgeBase() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"Sample.drl", HelloWorldTest.class), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        return kbase;
    }
}

