/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.mvel.CommonTestMethodBase;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.integrationtests.SerializationHelper;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.Channel;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class IntegrationInterfacesTest
extends CommonTestMethodBase {
    private KieBase getKnowledgeBase(String resourceName) throws IOException, ClassNotFoundException {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)resourceName, this.getClass()), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        KieBase kbase = this.getKnowledgeBase(kbuilder);
        return kbase;
    }

    private KieBase getKnowledgeBase(Reader[] readers) throws IOException, ClassNotFoundException {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        for (Reader reader : readers) {
            kbuilder.add(ResourceFactory.newReaderResource((Reader)reader), ResourceType.DRL);
        }
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        KieBase kbase = this.getKnowledgeBase(kbuilder);
        return kbase;
    }

    private KieBase getKnowledgeBase(KnowledgeBuilder kbuilder) throws IOException, ClassNotFoundException {
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        return kbase;
    }

    @Test
    public void testGlobals() throws Exception {
        KieBase kbase = this.getKnowledgeBase("globals_rule_test.drl");
        KieSession ksession = this.createKnowledgeSession(kbase);
        List list = (List)Mockito.mock(List.class);
        ksession.setGlobal("list", (Object)list);
        ksession.setGlobal("string", (Object)"stilton");
        Cheese stilton = new Cheese("stilton", 5);
        ksession.insert((Object)stilton);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        ((List)Mockito.verify((Object)list, (VerificationMode)Mockito.times((int)1))).add(new Integer(5));
    }

    @Test
    public void testGlobals2() throws Exception {
        KieBase kbase = this.getKnowledgeBase("test_globalsAsConstraints.drl");
        KieSession ksession = this.createKnowledgeSession(kbase);
        List results = (List)Mockito.mock(List.class);
        ksession.setGlobal("results", (Object)results);
        List cheeseTypes = (List)Mockito.mock(List.class);
        ksession.setGlobal("cheeseTypes", (Object)cheeseTypes);
        Mockito.when((Object)cheeseTypes.contains("stilton")).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)cheeseTypes.contains("muzzarela")).thenReturn((Object)Boolean.TRUE);
        Cheese stilton = new Cheese("stilton", 5);
        ksession.insert((Object)stilton);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        ((List)Mockito.verify((Object)results, (VerificationMode)Mockito.times((int)1))).add("memberOf");
        Cheese brie = new Cheese("brie", 5);
        ksession.insert((Object)brie);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        ((List)Mockito.verify((Object)results, (VerificationMode)Mockito.times((int)1))).add("not memberOf");
    }

    @Test
    public void testGlobalMerge() throws Exception {
        String rule1 = "package com.sample\nrule \"rule 1\"\n    salience 10\n    when\n        l : java.util.List()\n    then\n        l.add( \"rule 1 executed\" );\nend\n";
        String rule2 = "package com.sample\nglobal String str;\nrule \"rule 2\"\n    when\n        l : java.util.List()\n    then\n        l.add( \"rule 2 executed \" + str);\nend\n";
        Reader[] readers = new StringReader[]{new StringReader(rule1), new StringReader(rule2)};
        KieBase kbase = this.getKnowledgeBase(readers);
        KieSession ksession = this.createKnowledgeSession(kbase);
        ksession.setGlobal("str", (Object)"boo");
        ArrayList list = new ArrayList();
        ksession.insert(list);
        ksession.fireAllRules();
        Assert.assertEquals((Object)"rule 1 executed", list.get(0));
        Assert.assertEquals((Object)"rule 2 executed boo", list.get(1));
    }

    @Test
    public void testChannels() throws IOException, ClassNotFoundException {
        KieBase kbase = this.getKnowledgeBase("test_Channels.drl");
        KieSession ksession = this.createKnowledgeSession(kbase);
        Channel someChannel = (Channel)Mockito.mock(Channel.class);
        ksession.registerChannel("someChannel", someChannel);
        ksession.insert((Object)new Cheese("brie", 30));
        ksession.insert((Object)new Cheese("stilton", 5));
        ksession.fireAllRules();
        ((Channel)Mockito.verify((Object)someChannel)).send((Object)"brie");
        ((Channel)Mockito.verify((Object)someChannel, (VerificationMode)Mockito.never())).send((Object)"stilton");
    }
}

