/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.Collection;
import org.drools.mvel.CommonTestMethodBase;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.ReleaseId;
import org.kie.api.definition.KiePackage;
import org.kie.api.runtime.KieContainer;

public class KieBaseIncludesTest
extends CommonTestMethodBase {
    @Test
    public void testKieBaseIncludesCrossKJarDifferentPackageNames() {
        String pomContent1 = "<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\n<modelVersion>4.0.0</modelVersion>\n<groupId>org.kie</groupId>\n<artifactId>rules-1</artifactId>\n<version>1.0.0</version>\n<packaging>jar</packaging>\n<dependencies>\n<dependency>\n<groupId>org.kie</groupId>\n<artifactId>rules-2</artifactId>\n<version>1.0.0</version>\n</dependency>\n</dependencies>\n</project>\n";
        String kmoduleContent1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<kmodule xmlns=\"http://jboss.org/kie/6.0.0/kmodule\">\n<kbase name=\"kbase1\" equalsBehavior=\"equality\" default=\"true\" packages=\"rules\" includes=\"kbase2\">\n<ksession name=\"ksession1\" default=\"true\" type=\"stateful\"/>\n</kbase>\n</kmodule>";
        String drl1 = "package rules\n\nrule \"Rule in KieBase 1\"\nwhen\nthen\nSystem.out.println(\"Rule in KieBase1\");\nend";
        String kmoduleContent2 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<kmodule xmlns=\"http://jboss.org/kie/6.0.0/kmodule\">\n<kbase name=\"kbase2\" equalsBehavior=\"equality\" default=\"false\" packages=\"rules2\">\n<ksession name=\"ksession2\" default=\"false\" type=\"stateful\"/>\n</kbase>\n</kmodule>";
        String drl2 = "package rules2\n\nrule \"Rule in KieBase 2\"\nwhen\nthen\nSystem.out.println(\"Rule in KieBase2\");\nend";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "rules-1", "1.0.0");
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "rules-2", "1.0.0");
        KieFileSystem kfs2 = ks.newKieFileSystem().generateAndWritePomXML(releaseId2).write("src/main/resources/rules2/rules.drl", drl2).writeKModuleXML(kmoduleContent2);
        ks.newKieBuilder(kfs2).buildAll();
        KieFileSystem kfs1 = ks.newKieFileSystem().writePomXML(pomContent1).write("src/main/resources/rules/rules.drl", drl1).writeKModuleXML(kmoduleContent1);
        ks.newKieBuilder(kfs1).buildAll();
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieBase kieBase = kc.getKieBase();
        long nrOfRules = KieBaseIncludesTest.getNumberOfRules(kieBase);
        Assert.assertEquals((long)2L, (long)nrOfRules);
    }

    @Test
    public void testKieBaseIncludesCrossKJarSamePackageNames() {
        String pomContent1 = "<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\n<modelVersion>4.0.0</modelVersion>\n<groupId>org.kie</groupId>\n<artifactId>rules-1</artifactId>\n<version>1.0.0</version>\n<packaging>jar</packaging>\n<dependencies>\n<dependency>\n<groupId>org.kie</groupId>\n<artifactId>rules-2</artifactId>\n<version>1.0.0</version>\n</dependency>\n</dependencies>\n</project>\n";
        String kmoduleContent1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<kmodule xmlns=\"http://jboss.org/kie/6.0.0/kmodule\">\n<kbase name=\"kbase1\" equalsBehavior=\"equality\" default=\"true\" packages=\"rules\" includes=\"kbase2\">\n<ksession name=\"ksession1\" default=\"true\" type=\"stateful\"/>\n</kbase>\n</kmodule>";
        String drl1 = "package rules\n\nrule \"Rule in KieBase 1\"\nwhen\nthen\nSystem.out.println(\"Rule in KieBase1\");\nend";
        String kmoduleContent2 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<kmodule xmlns=\"http://jboss.org/kie/6.0.0/kmodule\">\n<kbase name=\"kbase2\" equalsBehavior=\"equality\" default=\"false\" packages=\"rules\">\n<ksession name=\"ksession2\" default=\"false\" type=\"stateful\"/>\n</kbase>\n</kmodule>";
        String drl2 = "package rules\n\nrule \"Rule in KieBase 2\"\nwhen\nthen\nSystem.out.println(\"Rule in KieBase2\");\nend";
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseId1 = ks.newReleaseId("org.kie", "rules-1", "1.0.0");
        ReleaseId releaseId2 = ks.newReleaseId("org.kie", "rules-2", "1.0.0");
        KieFileSystem kfs2 = ks.newKieFileSystem().generateAndWritePomXML(releaseId2).write("src/main/resources/rules/rules.drl", drl2).writeKModuleXML(kmoduleContent2);
        ks.newKieBuilder(kfs2).buildAll();
        KieFileSystem kfs1 = ks.newKieFileSystem().writePomXML(pomContent1).write("src/main/resources/rules/rules.drl", drl1).writeKModuleXML(kmoduleContent1);
        ks.newKieBuilder(kfs1).buildAll();
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieBase kieBase = kc.getKieBase();
        long nrOfRules = KieBaseIncludesTest.getNumberOfRules(kieBase);
        Assert.assertEquals((long)2L, (long)nrOfRules);
    }

    private static long getNumberOfRules(KieBase kieBase) {
        long nrOfRules = 0L;
        Collection kiePackages = kieBase.getKiePackages();
        for (KiePackage nextKiePackage : kiePackages) {
            Collection rules = nextKiePackage.getRules();
            System.out.println(rules);
            nrOfRules += (long)rules.size();
        }
        return nrOfRules;
    }
}

