/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import org.drools.mvel.CommonTestMethodBase;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;

public class KieDefaultPackageTest
extends CommonTestMethodBase {
    @Test
    public void testAllInDefaultPackage() throws Exception {
        String model_drl = "declare Smurf\nField1 : String\nend\n";
        String drl = "rule \"test\"\nwhen\nSmurf()\nthen\nend";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write("src/main/resources/model.drl", model_drl);
        kfs.write("src/main/resources/drl.drl", drl);
        KieBuilder builder = ks.newKieBuilder(kfs).buildAll();
        Assert.assertEquals((long)0L, (long)builder.getResults().getMessages().size());
    }

    @Test
    public void testInTestPackage() throws Exception {
        String javaClass = "package org.jbpm;\npublic class Test{}\n";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write("src/test/java/org/jbpm/Test.java", javaClass);
        KieBuilder builder = ks.newKieBuilder(kfs).buildAll();
        Assert.assertEquals((long)0L, (long)builder.getResults().getMessages().size());
    }

    @Test
    @Ignore(value="How do you access Type 'Smurf'? Test 1 - No import prefix")
    public void testModelInDefaultPackage1() throws Exception {
        String model_drl = "declare Smurf\nField1 : String\nend\n";
        String drl = "package org.smurf\nimport Smurf\nrule \"test\"\nwhen\nSmurf()\nthen\nend";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write("src/main/resources/model.drl", model_drl);
        kfs.write("src/main/resources/drl.drl", drl);
        KieBuilder builder = ks.newKieBuilder(kfs).buildAll();
        Assert.assertEquals((long)0L, (long)builder.getResults().getMessages().size());
    }

    @Test
    public void testModelInDefaultPackage2() throws Exception {
        String model_drl = "declare Smurf\nField1 : String\nend\n";
        String drl = "package org.smurf\nimport defaultpkg.Smurf\nrule \"test\"\nwhen\nSmurf()\nthen\nend";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write("src/main/resources/model.drl", model_drl);
        kfs.write("src/main/resources/drl.drl", drl);
        KieBuilder builder = ks.newKieBuilder(kfs).buildAll();
        Assert.assertEquals((long)0L, (long)builder.getResults().getMessages().size());
    }

    @Test
    public void testAllInExplicitPackage() throws Exception {
        String model_drl = "package org.smurf\ndeclare Smurf\nField1 : String\nend\n";
        String drl = "package org.smurf\nrule \"test\"\nwhen\nSmurf()\nthen\nend";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write("src/main/resources/model.drl", model_drl);
        kfs.write("src/main/resources/drl.drl", drl);
        KieBuilder builder = ks.newKieBuilder(kfs).buildAll();
        Assert.assertEquals((long)0L, (long)builder.getResults().getMessages().size());
    }

    @Test
    public void testAllInDifferentExplicitPackages() throws Exception {
        String model_drl = "package org.smurf\ndeclare Smurf\nField1 : String\nend\n";
        String drl = "package org.smurf.subpackage\nimport org.smurf.Smurf\nrule \"test\"\nwhen\nSmurf()\nthen\nend";
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.write("src/main/resources/model.drl", model_drl);
        kfs.write("src/main/resources/drl.drl", drl);
        KieBuilder builder = ks.newKieBuilder(kfs).buildAll();
        Assert.assertEquals((long)0L, (long)builder.getResults().getMessages().size());
    }
}

