/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.drools.compiler.kie.builder.impl.KieServicesImpl;
import org.drools.mvel.CommonTestMethodBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;

public class KieServicesTest
extends CommonTestMethodBase {
    private KieServices ks;

    @Before
    public void init() {
        this.ks = KieServices.Factory.get();
        ((KieServicesImpl)this.ks).nullKieClasspathContainer();
        ((KieServicesImpl)this.ks).nullAllContainerIds();
    }

    @After
    public void shutdown() {
        ((KieServicesImpl)this.ks).nullKieClasspathContainer();
        ((KieServicesImpl)this.ks).nullAllContainerIds();
    }

    @Test
    public void testGetKieClasspathIDs() {
        String myId = "myId";
        KieContainer c1 = this.ks.getKieClasspathContainer(myId);
        Assert.assertEquals((Object)c1, (Object)this.ks.getKieClasspathContainer());
        Assert.assertEquals((Object)c1, (Object)this.ks.getKieClasspathContainer(myId));
        try {
            this.ks.getKieClasspathContainer("invalid");
            Assert.fail((String)"this is not the containerId for the global singleton.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testNewKieClasspathIDs() {
        KieContainer c1 = this.ks.newKieClasspathContainer("id1");
        KieContainer c2 = this.ks.newKieClasspathContainer("id2");
        try {
            this.ks.newKieClasspathContainer("id2");
            Assert.fail((String)"should not allow repeated container IDs.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testNewKieContainerIDs() {
        ReleaseId releaseId = this.ks.newReleaseId("org.kie", "test-delete", "1.0.0");
        KieServicesTest.createAndDeployJar(this.ks, releaseId, this.createDRL("ruleA"));
        KieContainer c1 = this.ks.newKieContainer("id1", releaseId);
        KieContainer c2 = this.ks.newKieClasspathContainer("id2");
        try {
            this.ks.newKieContainer("id2", releaseId);
            Assert.fail((String)"should not allow repeated container IDs.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.ks.newKieClasspathContainer("id1");
            Assert.fail((String)"should not allow repeated container IDs.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testDisposeClearTheIDReference() {
        ReleaseId releaseId = this.ks.newReleaseId("org.kie", "test-delete", "1.0.0");
        KieServicesTest.createAndDeployJar(this.ks, releaseId, this.createDRL("ruleA"));
        KieContainer c1 = this.ks.newKieContainer("id1", releaseId);
        try {
            this.ks.newKieClasspathContainer("id1");
            Assert.fail((String)"should not allow repeated container IDs.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ((KieContainerImpl)c1).dispose();
        this.ks.newKieClasspathContainer("id1");
    }

    private String createDRL(String ruleName) {
        return "package org.kie.test\nglobal java.util.List list\nrule " + ruleName + "\nwhen\nthen\nlist.add( drools.getRule().getName() );\nend\n";
    }
}

