/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.WorkingMemory;
import org.drools.core.audit.WorkingMemoryConsoleLogger;
import org.drools.mvel.CommonTestMethodBase;
import org.drools.mvel.compiler.Address;
import org.drools.mvel.compiler.Person;
import org.drools.mvel.compiler.Pet;
import org.drools.mvel.integrationtests.SerializationHelper;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class MapConstraintTest
extends CommonTestMethodBase {
    @Test
    public void testMapAccess() throws Exception {
        KieBase kbase = SerializationHelper.serializeObject(this.loadKnowledgeBase("test_MapAccess.drl"));
        KieSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "Edson");
        map.put("surname", "Tirelli");
        map.put("age", "28");
        ksession.insert(map);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains(map));
    }

    @Test
    public void testMapAccessWithVariable() throws Exception {
        KieBase kbase = SerializationHelper.serializeObject(this.loadKnowledgeBase("test_MapAccessWithVariable.drl"));
        KieSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "Edson");
        map.put("surname", "Tirelli");
        map.put("age", "28");
        ksession.insert(map);
        ksession.insert((Object)"name");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains(map));
    }

    @Test
    public void testMapAccessWithVariable2() {
        String str = "package org.drools.compiler;\nimport java.util.Map;\nrule \"map access with variable\"\n    when\n        $key : String( )\n        $p1 : Person( name == 'Bob', namedAddresses[$key] != null, $na : namedAddresses[$key] )\n        $p2 : Person( name == 'Mark', namedAddresses[$key] == $na )\n    then\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])"package org.drools.compiler;\nimport java.util.Map;\nrule \"map access with variable\"\n    when\n        $key : String( )\n        $p1 : Person( name == 'Bob', namedAddresses[$key] != null, $na : namedAddresses[$key] )\n        $p2 : Person( name == 'Mark', namedAddresses[$key] == $na )\n    then\nend\n".getBytes()), ResourceType.DRL);
        Assert.assertTrue((boolean)kbuilder.hasErrors());
    }

    @Test
    public void testMapNullConstraint() throws Exception {
        KieBase kbase = this.loadKnowledgeBase("test_mapNullConstraints.drl");
        KieSession ksession = this.createKnowledgeSession(kbase);
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(ael);
        new WorkingMemoryConsoleLogger((WorkingMemory)ksession);
        HashMap<Object, Address> addresses = new HashMap<Object, Address>();
        addresses.put("home", new Address("home street"));
        Person bob = new Person("Bob");
        bob.setNamedAddresses(addresses);
        ksession.insert((Object)bob);
        ksession.fireAllRules();
        ArgumentCaptor arg = ArgumentCaptor.forClass(AfterMatchFiredEvent.class);
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)4))).afterMatchFired((AfterMatchFiredEvent)arg.capture());
        AfterMatchFiredEvent aaf = (AfterMatchFiredEvent)arg.getAllValues().get(0);
        MatcherAssert.assertThat((Object)aaf.getMatch().getRule().getName(), (Matcher)CoreMatchers.is((Object)"1. home != null"));
        aaf = (AfterMatchFiredEvent)arg.getAllValues().get(1);
        MatcherAssert.assertThat((Object)aaf.getMatch().getRule().getName(), (Matcher)CoreMatchers.is((Object)"2. not home == null"));
        aaf = (AfterMatchFiredEvent)arg.getAllValues().get(2);
        MatcherAssert.assertThat((Object)aaf.getMatch().getRule().getName(), (Matcher)CoreMatchers.is((Object)"7. work == null"));
        aaf = (AfterMatchFiredEvent)arg.getAllValues().get(3);
        MatcherAssert.assertThat((Object)aaf.getMatch().getRule().getName(), (Matcher)CoreMatchers.is((Object)"8. not work != null"));
    }

    @Test
    public void testMapAccessorWithPrimitiveKey() {
        String str = "package com.sample\nimport " + MapContainerBean.class.getCanonicalName() + ";\nrule R1 when\n  MapContainerBean( map[1] == \"one\" )\nthen\nend\nrule R2 when\n  MapContainerBean( map[1+1] == \"two\" )\nthen\nend\nrule R3 when\n  MapContainerBean( map[this.get3()] == \"three\" )\nthen\nend\nrule R4 when\n  MapContainerBean( map[4] == null )\nthen\nend\n";
        KieBase kbase = this.loadKnowledgeBaseFromString(str);
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new MapContainerBean());
        Assert.assertEquals((long)4L, (long)ksession.fireAllRules());
        ksession.dispose();
    }

    @Test
    public void testMapModel() {
        String str = "package org.drools.compiler\nimport java.util.Map\nrule \"test\"\nwhen\n    Map( type == \"Person\", name == \"Bob\" );\nthen\nend";
        KieBase kbase = this.loadKnowledgeBaseFromString("package org.drools.compiler\nimport java.util.Map\nrule \"test\"\nwhen\n    Map( type == \"Person\", name == \"Bob\" );\nthen\nend");
        KieSession ksession = this.createKnowledgeSession(kbase);
        HashMap<String, String> mark = new HashMap<String, String>();
        mark.put("type", "Person");
        mark.put("name", "Mark");
        ksession.insert(mark);
        int rules = ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)rules);
        HashMap<String, String> bob = new HashMap<String, String>();
        bob.put("type", "Person");
        bob.put("name", "Bob");
        ksession.insert(bob);
        rules = ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)rules);
    }

    @Test
    public void testListOfMaps() {
        KieBase kbase = this.loadKnowledgeBase("test_TestMapVariableRef.drl");
        KieSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        HashMap<String, String> mapOne = new HashMap<String, String>();
        HashMap<String, String> mapTwo = new HashMap<String, String>();
        mapOne.put("MSG", "testMessage");
        mapTwo.put("MSGTWO", "testMessage");
        list.add(mapOne);
        list.add(mapTwo);
        ksession.insert(list);
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testAccessingMapValues() throws Exception {
        String rule = "";
        rule = rule + "package org.drools.mvel.compiler;\n";
        rule = rule + "import org.drools.mvel.compiler.Pet;\n";
        rule = rule + "rule \"Test Rule\"\n";
        rule = rule + "  when\n";
        rule = rule + "    $pet: Pet()\n";
        rule = rule + "    Pet( \n";
        rule = rule + "      ownerName == $pet.attributes[\"key\"] \n";
        rule = rule + "    )\n";
        rule = rule + "  then\n";
        rule = rule + "    System.out.println(\"hi pet\");\n";
        rule = rule + "end";
        KieBase kbase = SerializationHelper.serializeObject(this.loadKnowledgeBaseFromString(rule));
        KieSession session = this.createKnowledgeSession(kbase);
        Assert.assertNotNull((Object)session);
        Pet pet1 = new Pet("Toni");
        pet1.getAttributes().put("key", "value");
        Pet pet2 = new Pet("Toni");
        session.insert((Object)pet1);
        session.insert((Object)pet2);
        session.fireAllRules();
    }

    public static class MapContainerBean {
        private final Map<Integer, String> map = new HashMap<Integer, String>();

        MapContainerBean() {
            this.map.put(1, "one");
            this.map.put(2, "two");
            this.map.put(3, "three");
        }

        public Map<Integer, String> getMap() {
            return this.map;
        }

        public int get3() {
            return 3;
        }
    }
}

