/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.mvel.CommonTestMethodBase;
import org.drools.mvel.compiler.Attribute;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.compiler.Message;
import org.drools.mvel.compiler.Person;
import org.drools.mvel.compiler.Primitives;
import org.drools.mvel.integrationtests.SerializationHelper;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.runtime.KieSession;

public class NullTest
extends CommonTestMethodBase {
    @Test
    public void testNullValuesIndexing() throws Exception {
        KieBase kbase = SerializationHelper.serializeObject(this.loadKnowledgeBase("test_NullValuesIndexing.drl"));
        KieSession ksession = kbase.newKieSession();
        Person bob = new Person(null, null);
        bob.setStatus("P1");
        Person pete = new Person(null, null);
        bob.setStatus("P2");
        ksession.insert((Object)bob);
        ksession.insert((Object)pete);
        ksession.fireAllRules();
        Assert.assertEquals((String)"Indexing with null values is not working correctly.", (Object)"OK", (Object)bob.getStatus());
        Assert.assertEquals((String)"Indexing with null values is not working correctly.", (Object)"OK", (Object)pete.getStatus());
    }

    @Test
    public void testNullBehaviour() throws Exception {
        KieBase kbase = this.loadKnowledgeBase("null_behaviour.drl");
        KieSession session = kbase.newKieSession();
        Person p1 = new Person("michael", "food", 40);
        Person p2 = new Person(null, "drink", 30);
        session.insert((Object)p1);
        session.insert((Object)p2);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
        session.fireAllRules();
    }

    @Test
    public void testNullConstraint() throws Exception {
        KieBase kbase = this.loadKnowledgeBase("null_constraint.drl");
        KieSession session = kbase.newKieSession();
        ArrayList foo = new ArrayList();
        session.setGlobal("messages", foo);
        Person p1 = new Person(null, "food", 40);
        Primitives p2 = new Primitives();
        p2.setArrayAttribute(null);
        session.insert((Object)p1);
        session.insert((Object)p2);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
        session.fireAllRules();
        Assert.assertEquals((long)2L, (long)((List)session.getGlobal("messages")).size());
    }

    @Test
    public void testNullBinding() throws Exception {
        KieBase kbase = SerializationHelper.serializeObject(this.loadKnowledgeBase("test_nullBindings.drl"));
        KieSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        ksession.insert((Object)new Person("bob"));
        ksession.insert((Object)new Person(null));
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"OK", list.get(0));
    }

    @Test
    public void testNullConstantLeft() {
        String str = "import org.drools.mvel.compiler.*;\nrule R1 when\n   $p : Person( null == name )\nthen\nend";
        KieBase kbase = this.loadKnowledgeBaseFromString("import org.drools.mvel.compiler.*;\nrule R1 when\n   $p : Person( null == name )\nthen\nend");
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Person(null));
        ksession.insert((Object)new Person("Mark"));
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        ksession.dispose();
    }

    @Test
    public void testNullFieldOnCompositeSink() throws Exception {
        KieBase kbase = this.loadKnowledgeBase("test_NullFieldOnCompositeSink.drl");
        KieSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Attribute());
        ksession.insert((Object)new Message());
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)((List)ksession.getGlobal("list")).size());
        Assert.assertEquals((Object)"X", ((List)ksession.getGlobal("list")).get(0));
    }

    @Test
    public void testNullHandling() throws Exception {
        KieBase kbase = this.loadKnowledgeBase("test_NullHandling.drl");
        KieSession session = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Cheese nullCheese = new Cheese(null, 2);
        session.insert((Object)nullCheese);
        Person notNullPerson = new Person("shoes butt back");
        notNullPerson.setBigDecimal(new BigDecimal("42.42"));
        session.insert((Object)notNullPerson);
        Person nullPerson = new Person("whee");
        nullPerson.setBigDecimal(null);
        session.insert((Object)nullPerson);
        session = SerializationHelper.getSerialisedStatefulKnowledgeSession(session, true);
        session.fireAllRules();
        Assert.assertEquals((long)3L, (long)((List)session.getGlobal("list")).size());
        nullPerson = new Person(null);
        session.insert((Object)nullPerson);
        session.fireAllRules();
        Assert.assertEquals((long)4L, (long)((List)session.getGlobal("list")).size());
    }

    @Test
    public void testNullHashing() throws Exception {
        KieBase kbase = SerializationHelper.serializeObject(this.loadKnowledgeBase("test_NullHashing.drl"));
        KieSession ksession = this.createKnowledgeSession(kbase);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.insert((Object)new Cheese("stilton", 15));
        ksession.insert((Object)new Cheese("", 10));
        ksession.insert((Object)new Cheese(null, 8));
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)results.size());
    }

    @Test
    public void testBindingToNullFieldWithEquality() {
        String str = "package org.drools.mvel.compiler.test; \n\nglobal java.util.List list;\ndeclare Bean\n  id    : String @key\n  field : String\nend\n\n\nrule \"Init\"\nwhen  \nthen\n  insert( new Bean( \"x\" ) );\nend\n\nrule \"Check\"\nwhen\n  $b : Bean( $fld : field )\nthen\n  System.out.println( $fld );\n  list.add( \"OK\" ); \nend";
        KieBaseConfiguration kbConf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kbConf.setOption((KieBaseOption)EqualityBehaviorOption.EQUALITY);
        KieBase kbase = this.loadKnowledgeBaseFromString(kbConf, "package org.drools.mvel.compiler.test; \n\nglobal java.util.List list;\ndeclare Bean\n  id    : String @key\n  field : String\nend\n\n\nrule \"Init\"\nwhen  \nthen\n  insert( new Bean( \"x\" ) );\nend\n\nrule \"Check\"\nwhen\n  $b : Bean( $fld : field )\nthen\n  System.out.println( $fld );\n  list.add( \"OK\" ); \nend");
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertTrue((boolean)list.contains("OK"));
        ksession.dispose();
    }

    @Test
    public void testArithmeticExpressionWithNull() {
        String str = "import " + PrimitiveBean.class.getCanonicalName() + ";\nrule R when\n   PrimitiveBean(primitive/typed > 0.7)\nthen\nend";
        KieBase kbase = this.loadKnowledgeBaseFromString(str);
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new PrimitiveBean(0.9, 1.1));
        ksession.insert((Object)new PrimitiveBean(0.9, null));
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        ksession.dispose();
    }

    public static class PrimitiveBean {
        public final double primitive;
        public final Double typed;

        public PrimitiveBean(double primitive, Double typed) {
            this.primitive = primitive;
            this.typed = typed;
        }

        public double getPrimitive() {
            return this.primitive;
        }

        public Double getTyped() {
            return this.typed;
        }
    }
}

