/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.ReteDumper;
import org.drools.core.reteoo.TerminalNode;
import org.drools.mvel.compiler.Address;
import org.drools.mvel.compiler.Person;
import org.drools.mvel.integrationtests.DynamicRulesChangesTest;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.conf.ForceEagerActivationOption;
import org.kie.internal.utils.KieHelper;

public class SegmentMemoryPrototypeTest {
    private static final String DRL = "import " + DynamicRulesChangesTest.class.getCanonicalName() + "\n global java.util.List events\nrule \"Raise the alarm when we have one or more fires\"\nwhen\n    exists DynamicRulesChangesTest.Fire()\nthen\n    insert( new DynamicRulesChangesTest.Alarm() );\n    events.add( \"Raise the alarm\" );\nend\nrule \"When there is a fire turn on the sprinkler\"\nwhen\n    $fire: DynamicRulesChangesTest.Fire($room : room)\n    $sprinkler : DynamicRulesChangesTest.Sprinkler( room == $room, on == false )\nthen\n    modify( $sprinkler ) { setOn( true ) };\n    events.add( \"Turn on the sprinkler for room \" + $room.getName() );\nend\nrule \"When the fire is gone turn off the sprinkler\"\nwhen\n    $room : DynamicRulesChangesTest.Room( )\n    $sprinkler : DynamicRulesChangesTest.Sprinkler( room == $room, on == true )\n    not DynamicRulesChangesTest.Fire( room == $room )\nthen\n    modify( $sprinkler ) { setOn( false ) };\n    events.add( \"Turn off the sprinkler for room \" + $room.getName() );\nend\nrule \"Cancel the alarm when all the fires have gone\"\nwhen\n    not DynamicRulesChangesTest.Fire()\n    $alarm : DynamicRulesChangesTest.Alarm()\nthen\n    retract( $alarm );\n    events.add( \"Cancel the alarm\" );\nend\nrule \"Status output when things are ok\"\nwhen\n    not DynamicRulesChangesTest.Fire()\n    not DynamicRulesChangesTest.Alarm()\n    not DynamicRulesChangesTest.Sprinkler( on == true )\nthen\n    events.add( \"Everything is ok\" );\nend";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSegmentMemoryPrototype() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])DRL.getBytes()), ResourceType.DRL);
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        KieSession ksession = kbase.newKieSession();
        try {
            this.checkKieSession(ksession);
        }
        finally {
            ksession.dispose();
        }
        KieSession ksession2 = kbase.newKieSession();
        try {
            this.checkKieSession(ksession2);
        }
        finally {
            ksession2.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSessionCache() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])DRL.getBytes()), ResourceType.DRL);
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addPackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        try {
            this.checkKieSession((KieSession)ksession);
        }
        finally {
            try {
                ksession.reset();
                this.checkKieSession((KieSession)ksession);
            }
            finally {
                ksession.dispose();
            }
        }
    }

    private void checkKieSession(KieSession ksession) {
        ArrayList events = new ArrayList();
        ksession.setGlobal("events", events);
        DynamicRulesChangesTest.Room room1 = new DynamicRulesChangesTest.Room("Room 1");
        ksession.insert((Object)room1);
        FactHandle fireFact1 = ksession.insert((Object)new DynamicRulesChangesTest.Fire(room1));
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)events.size());
        DynamicRulesChangesTest.Sprinkler sprinkler1 = new DynamicRulesChangesTest.Sprinkler(room1);
        ksession.insert((Object)sprinkler1);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)events.size());
        ksession.delete(fireFact1);
        ksession.fireAllRules();
        Assert.assertEquals((long)5L, (long)events.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEnsureRiaSegmentCreationUsingPrototypes() {
        String str = "import " + Person.class.getCanonicalName() + "\nimport " + Address.class.getCanonicalName() + "\nimport java.util.List;\n\nrule rule1 when\n    $personE : List()\n    Person( ) from $personE\nthen end\n\nrule rule2 when\n    $personE : List()\n    Person( $addresses : addresses ) from $personE\n    $address : Address( ) from $addresses\n    not (Address( this != $address ) from $addresses)\n    String(  )\nthen end";
        KieBase kbase = new KieHelper().addContent(str, ResourceType.DRL).build(new KieBaseOption[0]);
        KieSessionConfiguration conf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        conf.setOption((KieSessionOption)ForceEagerActivationOption.YES);
        KieSession ksession = kbase.newKieSession(conf, null);
        try {
            ksession.insert(Arrays.asList(new Person()));
            ksession.insert((Object)"test");
            Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        }
        catch (Throwable throwable) {
            ksession.dispose();
            try {
                ksession = kbase.newKieSession(conf, null);
                ksession.insert(Arrays.asList(new Person()));
                ksession.insert((Object)"test");
                Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
            }
            finally {
                ksession.dispose();
            }
            throw throwable;
        }
        ksession.dispose();
        try {
            ksession = kbase.newKieSession(conf, null);
            ksession.insert(Arrays.asList(new Person()));
            ksession.insert((Object)"test");
            Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        }
        finally {
            ksession.dispose();
        }
    }

    @Test
    public void testSessionReset() {
        String str = "import " + Person.class.getCanonicalName() + "\nimport " + Address.class.getCanonicalName() + "\nimport java.util.List;\n\nrule R1 when\n    $i : Integer()\n    String( length == $i )\n    Long()\nthen end\nrule R2 when\n    $i : Integer()\n    String( length == $i )\n    Boolean()\nthen end";
        KieBase kbase = new KieHelper().addContent(str, ResourceType.DRL).build(new KieBaseOption[0]);
        List terminalNodes = ReteDumper.collectRete((KieBase)kbase).stream().filter(TerminalNode.class::isInstance).map(TerminalNode.class::cast).collect(Collectors.toList());
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)kbase.newKieSession();
        ksession.insert((Object)4);
        ksession.insert((Object)4L);
        ksession.insert((Object)true);
        ksession.insert((Object)"test");
        Assert.assertEquals((long)2L, (long)ksession.fireAllRules());
        Assert.assertTrue((boolean)terminalNodes.stream().map(arg_0 -> ((StatefulKnowledgeSessionImpl)ksession).getNodeMemory(arg_0)).map(PathMemory.class::cast).allMatch(PathMemory::isRuleLinked));
        ksession.reset();
        Assert.assertFalse((boolean)terminalNodes.stream().map(arg_0 -> ((StatefulKnowledgeSessionImpl)ksession).getNodeMemory(arg_0)).map(PathMemory.class::cast).anyMatch(PathMemory::isRuleLinked));
        ksession.insert((Object)4);
        ksession.insert((Object)4L);
        ksession.insert((Object)"test");
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
    }
}

