/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import org.drools.mvel.CommonTestMethodBase;
import org.drools.mvel.compiler.Address;
import org.drools.mvel.compiler.Person;
import org.drools.mvel.integrationtests.SerializationHelper;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.runtime.StatelessKieSession;

public class StatelessStressTest
extends CommonTestMethodBase {
    @Ignore
    @Test
    public void testLotsOfStateless() throws Exception {
        int i;
        KieBase kbase = this.loadKnowledgeBase("thread_class_test.drl");
        int numThreads = 100;
        Thread[] ts = new Thread[numThreads];
        for (i = 0; i < numThreads; ++i) {
            Runnable run = () -> {
                long start = 0L;
                long previous = 0L;
                while (true) {
                    float f;
                    start = System.currentTimeMillis();
                    StatelessKieSession sess = kbase.newStatelessKieSession();
                    try {
                        sess = SerializationHelper.serializeObject(sess);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                    Person p = new Person();
                    p.setName("Michael");
                    Address add1 = new Address();
                    add1.setStreet("High");
                    Address add2 = new Address();
                    add2.setStreet("Low");
                    ArrayList<Address> l = new ArrayList<Address>();
                    l.add(add1);
                    l.add(add2);
                    p.setAddresses(l);
                    sess.execute((Object)p);
                    long current = System.currentTimeMillis() - start;
                    if (previous != 0L && (f = (float)(current / previous)) > 1.0f) {
                        System.err.println("SLOWDOWN");
                    }
                    previous = current;
                }
            };
            Thread t = new Thread(run);
            t.start();
            ts[i] = t;
        }
        for (i = 0; i < ts.length; ++i) {
            ts[i].join();
        }
    }
}

