/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.session;

import org.drools.core.base.RuleNameEndsWithAgendaFilter;
import org.drools.core.base.RuleNameEqualsAgendaFilter;
import org.drools.core.base.RuleNameMatchesAgendaFilter;
import org.drools.core.base.RuleNameStartsWithAgendaFilter;
import org.drools.mvel.CommonTestMethodBase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.AgendaFilter;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class AgendaFilterTest
extends CommonTestMethodBase {
    @Test
    public void testAgendaFilterRuleNameStartsWith() {
        this.testAgendaFilter((AgendaFilter)new RuleNameStartsWithAgendaFilter("B"), "Bbb");
    }

    @Test
    public void testAgendaFilterRuleNameEndsWith() {
        this.testAgendaFilter((AgendaFilter)new RuleNameEndsWithAgendaFilter("a"), "Aaa");
    }

    @Test
    public void testAgendaFilterRuleNameMatches() {
        this.testAgendaFilter((AgendaFilter)new RuleNameMatchesAgendaFilter(".*b."), "Bbb");
    }

    @Test
    public void testAgendaFilterRuleNameEquals() {
        this.testAgendaFilter((AgendaFilter)new RuleNameEqualsAgendaFilter("Aaa"), "Aaa");
    }

    private void testAgendaFilter(AgendaFilter agendaFilter, String expectedMatchingRuleName) {
        String str = "package org.drools.compiler\nrule Aaa when then end\nrule Bbb when then end\n";
        KieBase kbase = this.loadKnowledgeBaseFromString("package org.drools.compiler\nrule Aaa when then end\nrule Bbb when then end\n");
        KieSession ksession = this.createKnowledgeSession(kbase);
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(ael);
        int rules = ksession.fireAllRules(agendaFilter);
        Assert.assertEquals((long)1L, (long)rules);
        ArgumentCaptor arg = ArgumentCaptor.forClass(AfterMatchFiredEvent.class);
        ((AgendaEventListener)Mockito.verify((Object)ael)).afterMatchFired((AfterMatchFiredEvent)arg.capture());
        MatcherAssert.assertThat((Object)((AfterMatchFiredEvent)arg.getValue()).getMatch().getRule().getName(), (Matcher)CoreMatchers.is((Object)expectedMatchingRuleName));
    }
}

