/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.session;

import org.drools.mvel.CommonTestMethodBase;
import org.drools.mvel.compiler.Address;
import org.drools.mvel.compiler.Cat;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.compiler.Person;
import org.drools.mvel.compiler.Primitives;
import org.drools.mvel.integrationtests.SerializationHelper;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

public class FieldAccessTest
extends CommonTestMethodBase {
    @Test
    public void testAccessFieldsFromSubClass() throws Exception {
        String rule = "";
        rule = rule + "package org.drools.compiler;\n";
        rule = rule + "import org.drools.mvel.compiler.Person;\n";
        rule = rule + "import org.drools.mvel.compiler.Pet;\n";
        rule = rule + "import org.drools.mvel.compiler.Cat;\n";
        rule = rule + "declare Person @typesafe(false) end\n";
        rule = rule + "rule \"Test Rule\"\n";
        rule = rule + "when\n";
        rule = rule + "    Person(\n";
        rule = rule + "      pet.breed == \"Siamise\"\n";
        rule = rule + "    )\n";
        rule = rule + "then\n";
        rule = rule + "    System.out.println(\"hello person\");\n";
        rule = rule + "end";
        KieBase kbase = SerializationHelper.serializeObject(this.loadKnowledgeBaseFromString(rule));
        KieSession session = this.createKnowledgeSession(kbase);
        Person person = new Person();
        person.setPet(new Cat("Mittens"));
        session.insert((Object)person);
        session.fireAllRules();
    }

    @Test
    public void testAccessClassTypeField() {
        String str = "package org.drools.mvel.compiler\nrule r1\nwhen\n    Primitives( classAttr == null )then\nend\n";
        KieBase kbase = this.loadKnowledgeBaseFromString("package org.drools.mvel.compiler\nrule r1\nwhen\n    Primitives( classAttr == null )then\nend\n");
        KieSession ksession = this.createKnowledgeSession(kbase);
        ksession.insert((Object)new Primitives());
        int rules = ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)rules);
    }

    @Test
    public void testGenericsOption() throws Exception {
        String str = "import org.drools.mvel.compiler.*;\nrule R1 when\n   $c : Cheese( $type: type )\n   $p : Person( $name : name, addressOption.get.street == $type )\nthen\nend\n";
        KieBase kbase = this.loadKnowledgeBaseFromString("import org.drools.mvel.compiler.*;\nrule R1 when\n   $c : Cheese( $type: type )\n   $p : Person( $name : name, addressOption.get.street == $type )\nthen\nend\n");
        KieSession ksession = kbase.newKieSession();
        Person p = new Person("x");
        p.setAddress(new Address("x", "x", "x"));
        ksession.insert((Object)p);
        ksession.insert((Object)new Cheese("x"));
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        ksession.dispose();
    }
}

