/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests.session;

import java.util.ArrayList;
import org.drools.mvel.CommonTestMethodBase;
import org.drools.mvel.compiler.Person;
import org.drools.mvel.compiler.PolymorphicFact;
import org.drools.mvel.compiler.Primitives;
import org.drools.mvel.integrationtests.SerializationHelper;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.definition.type.FactType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;

public class TypeCoercionTest
extends CommonTestMethodBase {
    @Test
    public void testRuntimeTypeCoercion() throws Exception {
        KieBase kbase = SerializationHelper.serializeObject(this.loadKnowledgeBase("test_RuntimeTypeCoercion.drl"));
        KieSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        PolymorphicFact fact = new PolymorphicFact(10);
        FactHandle handle = ksession.insert((Object)fact);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)fact.getData(), list.get(0));
        fact.setData("10");
        ksession.update(handle, (Object)fact);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)fact.getData(), list.get(1));
        fact.setData(Boolean.TRUE);
        ksession.update(handle, (Object)fact);
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testRuntimeTypeCoercion2() throws Exception {
        KieBase kbase = SerializationHelper.serializeObject(this.loadKnowledgeBase("test_RuntimeTypeCoercion2.drl"));
        KieSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        Primitives fact = new Primitives();
        fact.setBooleanPrimitive(true);
        fact.setBooleanWrapper(Boolean.TRUE);
        fact.setObject(Boolean.TRUE);
        fact.setCharPrimitive('X');
        FactHandle handle = ksession.insert((Object)fact);
        ksession.fireAllRules();
        int index = 0;
        Assert.assertEquals((String)((Object)list).toString(), (long)4L, (long)list.size());
        Assert.assertEquals((Object)"boolean", list.get(index++));
        Assert.assertEquals((Object)"boolean wrapper", list.get(index++));
        Assert.assertEquals((Object)"boolean object", list.get(index++));
        Assert.assertEquals((Object)"char", list.get(index++));
        fact.setBooleanPrimitive(false);
        fact.setBooleanWrapper(null);
        fact.setCharPrimitive('\u0000');
        fact.setObject(Character.valueOf('X'));
        ksession.update(handle, (Object)fact);
        ksession.fireAllRules();
        Assert.assertEquals((long)5L, (long)list.size());
        Assert.assertEquals((Object)"char object", list.get(index++));
        fact.setObject(null);
        ksession.update(handle, (Object)fact);
        ksession.fireAllRules();
        Assert.assertEquals((long)6L, (long)list.size());
        Assert.assertEquals((Object)"null object", list.get(index));
    }

    @Test
    public void testUnwantedCoersion() throws Exception {
        String rule = "package org.drools.compiler\nimport " + InnerBean.class.getCanonicalName() + ";\nimport " + OuterBean.class.getCanonicalName() + ";\nrule \"Test.Code One\"\nwhen\n   OuterBean($code : inner.code in (\"1.50\", \"2.50\"))\nthen\n   System.out.println(\"Code compared values: 1.50, 2.50 - actual code value: \" + $code);\nend\nrule \"Test.Code Two\"\nwhen\n   OuterBean($code : inner.code in (\"1.5\", \"2.5\"))\nthen\n   System.out.println(\"Code compared values: 1.5, 2.5 - actual code value: \" + $code);\nend\nrule \"Big Test ID One\"\nwhen\n   OuterBean($id : id in (\"3.5\", \"4.5\"))\nthen\n   System.out.println(\"ID compared values: 3.5, 4.5 - actual ID value: \" + $id);\nend\nrule \"Big Test ID Two\"\nwhen\n   OuterBean($id : id in ( \"3.0\", \"4.0\"))\nthen\n   System.out.println(\"ID compared values: 3.0, 4.0 - actual ID value: \" + $id);\nend";
        KieBase kbase = this.loadKnowledgeBaseFromString(rule);
        KieSession ksession = kbase.newKieSession();
        InnerBean innerTest = new InnerBean();
        innerTest.setCode("1.500");
        ksession.insert((Object)innerTest);
        OuterBean outerTest = new OuterBean();
        outerTest.setId("3");
        outerTest.setInner(innerTest);
        ksession.insert((Object)outerTest);
        OuterBean outerTest2 = new OuterBean();
        outerTest2.setId("3.0");
        outerTest2.setInner(innerTest);
        ksession.insert((Object)outerTest2);
        int rules = ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)rules);
    }

    @Test
    public void testCoercionOfStringValueWithoutQuotes() throws Exception {
        String str = "package org.drools.mvel.compiler.test; \ndeclare A\n   field : String\nend\nrule R when\n   A( field == 12 )\nthen\nend\n";
        KieBase kbase = this.loadKnowledgeBaseFromString("package org.drools.mvel.compiler.test; \ndeclare A\n   field : String\nend\nrule R when\n   A( field == 12 )\nthen\nend\n");
        KieSession ksession = kbase.newKieSession();
        FactType typeA = kbase.getFactType("org.drools.mvel.compiler.test", "A");
        Object a = typeA.newInstance();
        typeA.set(a, "field", (Object)"12");
        ksession.insert(a);
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
    }

    @Test
    public void testPrimitiveToBoxedCoercionInMethodArgument() throws Exception {
        String str = "package org.drools.mvel.compiler.test;\nimport " + TypeCoercionTest.class.getName() + "\nimport org.drools.mvel.compiler.*\nrule R1 when\n   Person( $ag1 : age )   $p2 : Person( name == TypeCoercionTest.integer2String($ag1) )then\nend\n";
        KieBase kbase = this.loadKnowledgeBaseFromString(str);
        KieSession ksession = kbase.newKieSession();
        Person p = new Person("42", 42);
        ksession.insert((Object)p);
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
    }

    public static String integer2String(Integer value) {
        return "" + value;
    }

    @Test
    public void testStringCoercion() {
        String drl = "package org.drools.mvel.compiler.test;\nimport " + Person.class.getCanonicalName() + "\n rule R1 when\n     Person(name == \"12\")\n then end\n rule R2 when\n     Person(name == 11)\n  then\n end\n rule R3 when\n    Person(name == \"11\")\n then end\n";
        KieBase kieBase = this.loadKnowledgeBaseFromString(drl);
        KieSession kieSession = kieBase.newKieSession();
        kieSession.insert((Object)new Person("11"));
        Assert.assertEquals((long)2L, (long)kieSession.fireAllRules());
    }

    @Test
    public void testIntCoercion() {
        String drl = "package org.drools.mvel.compiler.test;\nimport " + Person.class.getCanonicalName() + "\n rule R1 when\n     Person(age == 12)\n then end\n rule R2 when\n     Person(age == \"11\")\n  then\n end\n rule R3 when\n    Person(age == 11)\n then end\n";
        KieBase kieBase = this.loadKnowledgeBaseFromString(drl);
        KieSession kieSession = kieBase.newKieSession();
        kieSession.insert((Object)new Person("Mario", 11));
        Assert.assertEquals((long)2L, (long)kieSession.fireAllRules());
    }

    @Test
    public void testCoercionInJoin() {
        String drl = " rule R1 when\n     Integer($i : intValue)\n     String(this == $i)\n then end\n";
        KieBase kieBase = this.loadKnowledgeBaseFromString(" rule R1 when\n     Integer($i : intValue)\n     String(this == $i)\n then end\n");
        KieSession kieSession = kieBase.newKieSession();
        kieSession.insert((Object)2);
        kieSession.insert((Object)"2");
        Assert.assertEquals((long)1L, (long)kieSession.fireAllRules());
    }

    @Test
    public void testCoercionInJoinOnField() {
        String drl = "import " + Person.class.getCanonicalName() + "\n rule R1 when\n     Integer($i : intValue)\n     Person(name == $i)\n then end\n";
        KieBase kieBase = this.loadKnowledgeBaseFromString(drl);
        KieSession kieSession = kieBase.newKieSession();
        kieSession.insert((Object)2);
        kieSession.insert((Object)new Person("2", 11));
        Assert.assertEquals((long)1L, (long)kieSession.fireAllRules());
    }

    public static class OuterBean {
        private InnerBean inner;
        private String id;

        public InnerBean getInner() {
            return this.inner;
        }

        public void setInner(InnerBean inner) {
            this.inner = inner;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }

    public static class InnerBean {
        private String code;

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }
    }
}

