/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.builder.KieBuilder;
import org.kie.api.definition.type.FactType;
import org.kie.api.definition.type.Key;
import org.kie.api.definition.type.Position;
import org.kie.api.definition.type.Role;

@RunWith(value=Parameterized.class)
public class AnnotationsTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public AnnotationsTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void annotationTest() {
        String drl = "package org.drools.compiler.test;\n import " + AnnPropEnum.class.getCanonicalName() + "; \n import " + Position.class.getCanonicalName() + "; \n import " + AnnotationsTest.class.getCanonicalName() + "; \nimport " + Annot.class.getCanonicalName() + "; \ndeclare AnnotatedBean \n @Deprecated \n @Annot( intProp=7          ,typeProp=String.class          ,strProp=\"hello world\"          ,enumProp=AnnPropEnum.THREE          ,dblArrProp={1.0,2.0}          ,typeArrProp={String.class, AnnotationsTest.class}          ,strArrProp={\"x1\",\"x2\"}          ,enumArrProp={AnnPropEnum.ONE, AnnPropEnum.THREE}          ) \n  \n  @role(event) \n   age : int \n name : String      @key    @Position(0)    @Deprecated \n end \n   \n\n declare SecondBean \n  @NonexistingAnnotation  \n field : String @Annot \nend \n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"annotations-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        Class clazz = kbase.getFactType("org.drools.compiler.test", "AnnotatedBean").getFactClass();
        Assert.assertNotNull((Object)clazz);
        try {
            Field fld = clazz.getDeclaredField("name");
            Assert.assertEquals((long)3L, (long)fld.getAnnotations().length);
            Assert.assertNotNull((Object)fld.getAnnotation(Deprecated.class));
            Assert.assertNotNull((Object)fld.getAnnotation(Position.class));
            Assert.assertNotNull((Object)fld.getAnnotation(Key.class));
            Position pos = fld.getAnnotation(Position.class);
            Assert.assertEquals((long)0L, (long)pos.value());
        }
        catch (NoSuchFieldException nsfe) {
            Assert.fail((String)("field name has not been generated correctly : " + nsfe.getMessage()));
        }
        Annotation[] anns = clazz.getAnnotations();
        Assert.assertEquals((long)3L, (long)anns.length);
        Assert.assertNotNull((Object)clazz.getAnnotation(Deprecated.class));
        Assert.assertNotNull((Object)clazz.getAnnotation(Annot.class));
        Assert.assertNotNull((Object)clazz.getAnnotation(Role.class));
        Annot ann = clazz.getAnnotation(Annot.class);
        Assert.assertEquals((long)7L, (long)ann.intProp());
        Assert.assertEquals(String.class, (Object)ann.typeProp());
        Assert.assertEquals((Object)"hello world", (Object)ann.strProp());
        Assert.assertEquals((Object)((Object)AnnPropEnum.THREE), (Object)((Object)ann.enumProp()));
        Assert.assertArrayEquals((double[])new double[]{1.0, 2.0}, (double[])ann.dblArrProp(), (double)1.0E-16);
        Assert.assertArrayEquals((Object[])new Class[]{String.class, AnnotationsTest.class}, (Object[])ann.typeArrProp());
        Assert.assertArrayEquals((Object[])new String[]{"x1", "x2"}, (Object[])ann.strArrProp());
        Assert.assertArrayEquals((Object[])new AnnPropEnum[]{AnnPropEnum.ONE, AnnPropEnum.THREE}, (Object[])ann.enumArrProp());
        Class clazz2 = kbase.getFactType("org.drools.compiler.test", "SecondBean").getFactClass();
        Assert.assertNotNull((Object)clazz2);
        Annotation[] anns2 = clazz2.getAnnotations();
        Assert.assertEquals((long)0L, (long)anns2.length);
        Annot ann2 = null;
        try {
            Field fld2 = clazz2.getDeclaredField("field");
            Assert.assertNotNull((Object)fld2.getAnnotation(Annot.class));
            ann2 = fld2.getAnnotation(Annot.class);
        }
        catch (NoSuchFieldException nsfe) {
            Assert.fail((String)("field name has not been generated correctly : " + nsfe.getMessage()));
        }
        Assert.assertNotNull((Object)ann2);
        Assert.assertEquals((long)0L, (long)ann2.intProp());
        Assert.assertEquals((Object)"foo", (Object)ann2.strProp());
        Assert.assertEquals((Object)((Object)AnnPropEnum.ONE), (Object)((Object)ann2.enumProp()));
        Assert.assertArrayEquals((double[])new double[]{0.4, 0.5}, (double[])ann2.dblArrProp(), (double)1.0E-16);
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c"}, (Object[])ann2.strArrProp());
        Assert.assertArrayEquals((Object[])new AnnPropEnum[]{AnnPropEnum.TWO, AnnPropEnum.THREE}, (Object[])ann2.enumArrProp());
    }

    @Test
    public void annotationErrorTest() {
        String drl = "package org.drools.compiler.test;\n declare MissingAnnotationBean \n @IgnoreMissingAnnotation1 \n name : String      @IgnoreMissingAnnotation2( noProp = 999 ) \n end \n ";
        KieBuilder kieBuilder = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{"package org.drools.compiler.test;\n declare MissingAnnotationBean \n @IgnoreMissingAnnotation1 \n name : String      @IgnoreMissingAnnotation2( noProp = 999 ) \n end \n "});
        Assertions.assertThat((List)kieBuilder.getResults().getMessages()).isEmpty();
        String drl2 = "package org.drools.compiler.test;\n import " + Annot.class.getCanonicalName() + "; \ndeclare MissingAnnotationBean \n @Annot( wrongProp1 = 1 ) \n name : String      @Annot( wrongProp2 = 2, wrongProp3 = 3 ) \n end \n ";
        KieBuilder kieBuilder2 = KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)false, (String[])new String[]{drl2});
        Assertions.assertThat((List)kieBuilder2.getResults().getMessages()).hasSize(3);
    }

    @Test
    public void testAnnotationNameClash() {
        String drl = "package org.drools.test\ndeclare Annot\n id : int  @" + Annot.class.getCanonicalName() + "( intProp = 3, typeProp = String.class, typeArrProp = {} ) \n end\nrule X\nwhen\n \nthen\n insert( new Annot( 22 ) ); end";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"annotations-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        FactType ft = kbase.getFactType("org.drools.test", "Annot");
        try {
            Object o = ft.newInstance();
            Annot a = o.getClass().getDeclaredField("id").getAnnotation(Annot.class);
            Assert.assertEquals((long)3L, (long)a.intProp());
            Assert.assertEquals(String.class, (Object)a.typeProp());
            Assert.assertEquals((long)0L, (long)a.typeArrProp().length);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testAnnotationNameClashWithRegularClass() {
        String drl = "package org.drools.test\nimport " + Duration.class.getCanonicalName() + "; declare Annot   @role( event )  @duration( durat )   durat : long end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"annotations-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        FactType ft = kbase.getFactType("org.drools.test", "Annot");
        Assert.assertNotNull((Object)ft);
    }

    @Test
    public void testAnnotationOnLHSAndMerging() {
        String drl = "package org.drools.compiler;  import " + Annot.class.getCanonicalName() + ";  rule \"test collect with annotation\"     when        ( and @Annot          String()          Integer() )     then end ";
        KieUtil.getKieBuilderFromDrls((KieBaseTestConfiguration)this.kieBaseTestConfiguration, (boolean)true, (String[])new String[]{drl});
    }

    public static @interface Simple {
        public int[] numbers();
    }

    public static class Duration {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.FIELD})
    public static @interface Annot {
        public int intProp() default 0;

        public Class typeProp() default Object.class;

        public String strProp() default "foo";

        public AnnPropEnum enumProp() default AnnPropEnum.ONE;

        public double[] dblArrProp() default {0.4, 0.5};

        public Class[] typeArrProp() default {};

        public String[] strArrProp() default {"a", "b", "c"};

        public AnnPropEnum[] enumArrProp() default {AnnPropEnum.TWO, AnnPropEnum.THREE};
    }

    public static enum AnnPropEnum {
        ONE("one"),
        TWO("two"),
        THREE("three");

        private final String value;

        private AnnPropEnum(String s) {
            this.value = s;
        }

        public String getValue() {
            return this.value;
        }
    }
}

