/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.integrationtests.operators;

import java.util.ArrayList;
import java.util.Collection;
import org.drools.testcoverage.common.model.Order;
import org.drools.testcoverage.common.model.OrderItem;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class EvalRewriteTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public EvalRewriteTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEvalRewrite() {
        String drl = "package org.drools.compiler.integrationtests.operators\nimport " + OrderItem.class.getCanonicalName() + " ;\nimport " + Order.class.getCanonicalName() + " ;\nglobal java.util.List results;\n\n\nrule \"eval rewrite\"\n    when\n        $o : OrderItem( order.number == 10 )\n    then\n        results.add( $o );\nend\n\nrule \"eval rewrite2\"\n    when\n        $o1 : OrderItem( order.number == 11, $seq : seq == 1 )\n        $o2 : OrderItem( order.number == $o1.order.number, seq != $seq )\n    then\n        results.add( $o2 );\nend\n\nrule \"eval rewrite3\"\n    when\n        $o1 : OrderItem( order.number == 12, seq == 1 )\n        $o : Order( items[(Integer) 1] == $o1 )\n    then\n        results.add( $o );\nend\n\nrule \"eval rewrite4\"\n    when\n        OrderItem( $nbr : order.number == 13, seq == 1 )\n        $o : Order( number == $nbr )\n    then\n        results.add( $o );\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"eval-rewrite-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("results", list);
            Order order1 = new Order(10, "Bob");
            OrderItem item11 = new OrderItem(order1, 1);
            OrderItem item12 = new OrderItem(order1, 2);
            order1.addItem(item11);
            order1.addItem(item12);
            Order order2 = new Order(11, "Bob");
            OrderItem item21 = new OrderItem(order2, 1);
            OrderItem item22 = new OrderItem(order2, 2);
            order2.addItem(item21);
            order2.addItem(item22);
            Order order3 = new Order(12, "Bob");
            OrderItem item31 = new OrderItem(order3, 1);
            OrderItem item32 = new OrderItem(order3, 2);
            order3.addItem(item31);
            order3.addItem(item32);
            Order order4 = new Order(13, "Bob");
            OrderItem item41 = new OrderItem(order4, 1);
            OrderItem item42 = new OrderItem(order4, 2);
            order4.addItem(item41);
            order4.addItem(item42);
            ksession.insert((Object)order1);
            ksession.insert((Object)item11);
            ksession.insert((Object)item12);
            ksession.insert((Object)order2);
            ksession.insert((Object)item21);
            ksession.insert((Object)item22);
            ksession.insert((Object)order3);
            ksession.insert((Object)item31);
            ksession.insert((Object)item32);
            ksession.insert((Object)order4);
            ksession.insert((Object)item41);
            ksession.insert((Object)item42);
            ksession.fireAllRules();
            Assert.assertEquals((long)5L, (long)list.size());
            Assert.assertTrue((boolean)list.contains(item11));
            Assert.assertTrue((boolean)list.contains(item12));
            Assert.assertTrue((boolean)list.contains(item22));
            Assert.assertTrue((boolean)list.contains(order3));
            Assert.assertTrue((boolean)list.contains(order4));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEvalRewriteMatches() {
        String drl = "package org.drools.compiler.integrationtests.operators;\nimport " + OrderItem.class.getCanonicalName() + " ;\nimport " + Order.class.getCanonicalName() + " ;\nglobal java.util.List results;\n\nrule \"eval rewrite with 'matches'\"\n    salience 20\n    when\n        $oi : OrderItem( order.number == 14, seq == 1, order.customer matches \"M\\\\w*\" )\n    then\n        results.add( $oi );\nend\n\nrule \"eval rewrite with 'not matches'\"\n    salience 10\n    when\n        $oi : OrderItem( order.number == 14, seq == 2, order.customer not matches \"B\\\\w*\" )\n    then\n        results.add( $oi );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"eval-rewrite-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("results", list);
            Order order1 = new Order(14, "Mark");
            OrderItem item11 = new OrderItem(order1, 1);
            OrderItem item12 = new OrderItem(order1, 2);
            order1.addItem(item11);
            order1.addItem(item12);
            ksession.insert((Object)order1);
            ksession.insert((Object)item11);
            ksession.insert((Object)item12);
            ksession.fireAllRules();
            Assert.assertEquals((long)2L, (long)list.size());
            Assert.assertTrue((boolean)list.contains(item11));
            Assert.assertTrue((boolean)list.contains(item12));
        }
        finally {
            ksession.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEvalRewriteWithSpecialOperators() {
        String drl = "package org.drools.compiler\nimport " + OrderItem.class.getCanonicalName() + " ;\nimport " + Order.class.getCanonicalName() + " ;\nglobal java.util.List results;\n\n// [not] in\n// [not] contains\n// [not] memberOf\n// excludes\n// [not] matches\n\nrule \"eval rewrite with 'in'\"\n    salience 100\n    when\n        Order( $id : number == 10 )\n        $o : OrderItem( order.number in ( 1, (1+1), $id ), seq == 1 )\n    then\n        results.add( $o );\nend\n\nrule \"eval rewrite with 'not in'\"\n    salience 90\n    when\n        Order( $id : number == 10 )\n        $o : OrderItem( order.number not in ( 1, (1+1), ( $id + 1 ) ), order.number == $id, seq == 2 )\n    then\n        results.add( $o );\nend\n\nrule \"eval rewrite with 'contains'\"\n    salience 80\n    when\n        $o : OrderItem( order.number == 11, seq == 1 )\n        Order( this.itemsValues contains $o )\n    then\n        results.add( $o );\nend\n\nrule \"eval rewrite with 'not contains'\"\n    salience 70\n    when\n        $o : OrderItem( order.number == 11, seq == 2 )\n        Order( number == 12, this.itemsValues not contains $o )\n    then\n        results.add( $o );\nend\n\nrule \"eval rewrite with 'memberOf'\"\n    salience 60\n    when\n        $order : Order( number == 12 )\n        $o : OrderItem( seq == 1, order.number==12, this.seq memberOf $order.itemsKeys )\n    then\n        results.add( $o );\nend\n\nrule \"eval rewrite with 'not memberOf'\"\n    salience 50\n    when\n        $order : Order( number == 11 )\n        $o : OrderItem( seq == 3, order.number==12, this.seq not memberOf $order.itemsKeys )\n    then\n        results.add( $o );\nend\n\nrule \"eval rewrite with 'excludes'\"\n    salience 30\n    when\n        $o : OrderItem( order.number == 13, seq == 1 )\n        Order( number == 12, this.itemsValues excludes $o )\n    then\n        results.add( $o );\nend\n\nrule \"eval rewrite with 'matches'\"\n    salience 20\n    when\n        $o : Order( number == 14, this.customer matches \"Mark\" )\n    then\n        results.add( $o );\nend\n\nrule \"eval rewrite with 'not matches'\"\n    salience 10\n    when\n        $o : Order( number == 14, this.customer not matches \"Bob\" )\n    then\n        results.add( $o );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"eval-rewrite-test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        try {
            ArrayList list = new ArrayList();
            ksession.setGlobal("results", list);
            Order order1 = new Order(10, "Bob");
            OrderItem item11 = new OrderItem(order1, 1);
            OrderItem item12 = new OrderItem(order1, 2);
            order1.addItem(item11);
            order1.addItem(item12);
            Order order2 = new Order(11, "Bob");
            OrderItem item21 = new OrderItem(order2, 1);
            OrderItem item22 = new OrderItem(order2, 2);
            order2.addItem(item21);
            order2.addItem(item22);
            Order order3 = new Order(12, "Bob");
            OrderItem item31 = new OrderItem(order3, 1);
            OrderItem item32 = new OrderItem(order3, 2);
            OrderItem item33 = new OrderItem(order3, 3);
            order3.addItem(item31);
            order3.addItem(item32);
            order3.addItem(item33);
            Order order4 = new Order(13, "Bob");
            OrderItem item41 = new OrderItem(order4, 1);
            OrderItem item42 = new OrderItem(order4, 2);
            order4.addItem(item41);
            order4.addItem(item42);
            Order order5 = new Order(14, "Mark");
            OrderItem item51 = new OrderItem(order5, 1);
            OrderItem item52 = new OrderItem(order5, 2);
            order5.addItem(item51);
            order5.addItem(item52);
            ksession.insert((Object)order1);
            ksession.insert((Object)item11);
            ksession.insert((Object)item12);
            ksession.insert((Object)order2);
            ksession.insert((Object)item21);
            ksession.insert((Object)item22);
            ksession.insert((Object)order3);
            ksession.insert((Object)item31);
            ksession.insert((Object)item32);
            ksession.insert((Object)item33);
            ksession.insert((Object)order4);
            ksession.insert((Object)item41);
            ksession.insert((Object)item42);
            ksession.insert((Object)order5);
            ksession.insert((Object)item51);
            ksession.insert((Object)item52);
            ksession.fireAllRules();
            Assert.assertEquals((long)9L, (long)list.size());
            int index = 0;
            Assert.assertEquals((Object)item11, list.get(index++));
            Assert.assertEquals((Object)item12, list.get(index++));
            Assert.assertEquals((Object)item21, list.get(index++));
            Assert.assertEquals((Object)item22, list.get(index++));
            Assert.assertEquals((Object)item31, list.get(index++));
            Assert.assertEquals((Object)item33, list.get(index++));
            Assert.assertEquals((Object)item41, list.get(index++));
            Assert.assertEquals((Object)order5, list.get(index++));
            Assert.assertEquals((Object)order5, list.get(index));
        }
        finally {
            ksession.dispose();
        }
    }
}

