/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.WorkingMemory;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.ClassFieldAccessorStore;
import org.drools.core.base.ClassFieldReader;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.FieldFactory;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleImpl;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleImpl;
import org.drools.core.rule.ContextEntry;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.PredicateConstraint;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.ObjectType;
import org.drools.core.spi.PredicateExpression;
import org.drools.core.spi.Tuple;
import org.drools.mvel.MVELConstraintTestUtil;
import org.drools.mvel.model.Cheese;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FieldConstraintTest {
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();

    @Before
    public void setUp() throws Exception {
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store.setEagerWire(true);
    }

    @Test
    public void testLiteralConstraint() {
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)kBase.newKieSession();
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type");
        MVELConstraintTestUtil constraint = new MVELConstraintTestUtil("type == \"cheddar\"", FieldFactory.getInstance().getFieldValue((Object)"cheddar"), (InternalReadAccessor)extractor);
        Cheese cheddar = new Cheese("cheddar", 5);
        InternalFactHandle cheddarHandle = (InternalFactHandle)ksession.insert((Object)cheddar);
        Assert.assertTrue((boolean)constraint.isAllowed(cheddarHandle, (InternalWorkingMemory)ksession));
        Cheese stilton = new Cheese("stilton", 5);
        InternalFactHandle stiltonHandle = (InternalFactHandle)ksession.insert((Object)stilton);
        Assert.assertFalse((boolean)constraint.isAllowed(stiltonHandle, (InternalWorkingMemory)ksession));
    }

    @Test
    public void testPrimitiveLiteralConstraint() {
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)kBase.newKieSession();
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "price");
        MVELConstraintTestUtil constraint = new MVELConstraintTestUtil("price == 5", FieldFactory.getInstance().getFieldValue(5), (InternalReadAccessor)extractor);
        Cheese cheddar = new Cheese("cheddar", 5);
        InternalFactHandle cheddarHandle = (InternalFactHandle)ksession.insert((Object)cheddar);
        Assert.assertTrue((boolean)constraint.isAllowed(cheddarHandle, (InternalWorkingMemory)ksession));
        Cheese stilton = new Cheese("stilton", 10);
        InternalFactHandle stiltonHandle = (InternalFactHandle)ksession.insert((Object)stilton);
        Assert.assertFalse((boolean)constraint.isAllowed(stiltonHandle, (InternalWorkingMemory)ksession));
    }

    @Test
    public void testPredicateConstraint() {
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)kBase.newKieSession();
        ClassFieldReader priceExtractor = this.store.getReader(Cheese.class, "price");
        Pattern pattern = new Pattern(0, (ObjectType)new ClassObjectType(Cheese.class));
        Declaration price1Declaration = new Declaration("price1", (InternalReadAccessor)priceExtractor, pattern);
        pattern = new Pattern(1, (ObjectType)new ClassObjectType(Cheese.class));
        Declaration price2Declaration = new Declaration("price2", (InternalReadAccessor)priceExtractor, pattern);
        PredicateExpression evaluator = new PredicateExpression(){
            private static final long serialVersionUID = 510L;

            public boolean evaluate(InternalFactHandle handle, Tuple tuple, Declaration[] previousDeclarations, Declaration[] localDeclarations, WorkingMemory workingMemory, Object context) {
                int price1 = previousDeclarations[0].getIntValue((InternalWorkingMemory)workingMemory, tuple.getObject(previousDeclarations[0]));
                int price2 = localDeclarations[0].getIntValue((InternalWorkingMemory)workingMemory, handle.getObject());
                return price2 == price1 * 2;
            }

            public Object createContext() {
                return null;
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }
        };
        PredicateConstraint constraint1 = new PredicateConstraint(evaluator, new Declaration[]{price1Declaration}, new Declaration[]{price2Declaration});
        Cheese cheddar0 = new Cheese("cheddar", 5);
        InternalFactHandle f0 = (InternalFactHandle)ksession.insert((Object)cheddar0);
        LeftTupleImpl tuple = new LeftTupleImpl(f0, null, true);
        Cheese cheddar1 = new Cheese("cheddar", 10);
        InternalFactHandle f1 = (InternalFactHandle)ksession.insert((Object)cheddar1);
        tuple = new LeftTupleImpl((LeftTuple)tuple, (RightTuple)new RightTupleImpl(f1, null), null, true);
        PredicateConstraint.PredicateContextEntry context = (PredicateConstraint.PredicateContextEntry)constraint1.createContextEntry();
        context.updateFromTuple((InternalWorkingMemory)ksession, (Tuple)tuple);
        Assert.assertTrue((boolean)constraint1.isAllowedCachedLeft((ContextEntry)context, f1));
    }
}

