/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.compiler.definitions;

import java.util.Collection;
import org.drools.core.definitions.rule.impl.GlobalImpl;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.rule.Query;
import org.kie.api.definition.type.FactField;
import org.kie.api.definition.type.FactType;

@RunWith(value=Parameterized.class)
public class KnowledgePackageMetaDataTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;
    private String drl = "package org.drools.mvel.compiler.test.definitions \nimport java.util.List; \n\nglobal Integer N; \nglobal List list; \n\nfunction void fun1() {}\n\nfunction String fun2( int j ) { return null; } \n\ndeclare Person\n  name : String\n  age  : int\nend\n\ndeclare Foo extends Person\n   bar : String\nend \n\nquery qry1() \n  Foo()\nend\n\nquery qry2( String x )\n  x := String()\nend\n\nrule \"rule1\"\nwhen\nthen\nend\n\nrule \"rule2\"\nwhen\nthen\nend";

    public KnowledgePackageMetaDataTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Test
    public void testMetaData() {
        KieBase kBase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{this.drl});
        KiePackage pack = kBase.getKiePackage("org.drools.mvel.compiler.test.definitions");
        Assert.assertNotNull((Object)pack);
        Assert.assertEquals((long)2L, (long)pack.getFunctionNames().size());
        Assert.assertTrue((boolean)pack.getFunctionNames().contains("fun1"));
        Assert.assertTrue((boolean)pack.getFunctionNames().contains("fun2"));
        Assert.assertEquals((long)2L, (long)pack.getGlobalVariables().size());
        GlobalImpl g1 = new GlobalImpl("N", "java.lang.Integer");
        GlobalImpl g2 = new GlobalImpl("list", "java.util.List");
        Assert.assertTrue((boolean)pack.getGlobalVariables().contains(g1));
        Assert.assertTrue((boolean)pack.getGlobalVariables().contains(g2));
        Assert.assertEquals((long)2L, (long)pack.getFactTypes().size());
        for (int j = 0; j < 2; ++j) {
            FactType type = (FactType)pack.getFactTypes().iterator().next();
            if (type.getName().equals("org.drools.mvel.compiler.test.definitions.Person")) {
                Assert.assertEquals((long)2L, (long)type.getFields().size());
                continue;
            }
            if (type.getName().equals("org.drools.mvel.compiler.test.definitions.Foo")) {
                Assert.assertEquals((Object)"org.drools.mvel.compiler.test.definitions.Person", (Object)type.getSuperClass());
                FactField fld = type.getField("bar");
                Assert.assertEquals((long)2L, (long)fld.getIndex());
                Assert.assertEquals(String.class, (Object)fld.getType());
                continue;
            }
            Assert.fail((String)("Unexpected fact type " + type));
        }
        Assert.assertEquals((long)2L, (long)pack.getQueries().size());
        for (Query q : pack.getQueries()) {
            Assert.assertTrue((q.getName().equals("qry1") || q.getName().equals("qry2") ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)4L, (long)pack.getRules().size());
        Assert.assertTrue((boolean)pack.getRules().containsAll(pack.getQueries()));
    }
}

