/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import java.util.Collection;
import java.util.Comparator;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.integrationtests.DroolsEventList;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.LiveQuery;
import org.kie.api.runtime.rule.Row;
import org.kie.api.runtime.rule.ViewChangedEventListener;

@RunWith(value=Parameterized.class)
public class DroolsEventListTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public DroolsEventListTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)true);
    }

    @Test
    public void testOpenQuery() throws Exception {
        String str = "";
        str = str + "package org.kie.test  \n";
        str = str + "import " + Cheese.class.getCanonicalName() + "\n";
        str = str + "query cheeses(String $type1, String $type2) \n";
        str = str + "    stilton : Cheese(type == $type1, $price : price) \n";
        str = str + "    cheddar : Cheese(type == $type2, price == stilton.price) \n";
        str = str + "end\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        Cheese stilton1 = new Cheese("stilton", 1);
        Cheese cheddar1 = new Cheese("cheddar", 1);
        Cheese stilton2 = new Cheese("stilton", 2);
        Cheese cheddar2 = new Cheese("cheddar", 2);
        Cheese stilton3 = new Cheese("stilton", 3);
        Cheese cheddar3 = new Cheese("cheddar", 3);
        FactHandle s1Fh = ksession.insert((Object)stilton1);
        FactHandle s2Fh = ksession.insert((Object)stilton2);
        FactHandle s3Fh = ksession.insert((Object)stilton3);
        FactHandle c1Fh = ksession.insert((Object)cheddar1);
        FactHandle c2Fh = ksession.insert((Object)cheddar2);
        FactHandle c3Fh = ksession.insert((Object)cheddar3);
        DroolsEventList list = new DroolsEventList();
        LiveQuery query = ksession.openLiveQuery("cheeses", new Object[]{"cheddar", "stilton"}, (ViewChangedEventListener)list);
        SortedList sorted = new SortedList((EventList)list, (Comparator)new Comparator<Row>(){

            @Override
            public int compare(Row r1, Row r2) {
                Cheese c1 = (Cheese)r1.get("stilton");
                Cheese c2 = (Cheese)r2.get("stilton");
                return c1.getPrice() - c2.getPrice();
            }
        });
        Assert.assertEquals((long)3L, (long)sorted.size());
        Assert.assertEquals((long)1L, (long)((Cheese)((Row)sorted.get(0)).get("stilton")).getPrice());
        Assert.assertEquals((long)2L, (long)((Cheese)((Row)sorted.get(1)).get("stilton")).getPrice());
        Assert.assertEquals((long)3L, (long)((Cheese)((Row)sorted.get(2)).get("stilton")).getPrice());
        stilton3.setPrice(4);
        ksession.update(s3Fh, (Object)stilton3);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)sorted.size());
        Assert.assertEquals((long)1L, (long)((Cheese)((Row)sorted.get(0)).get("stilton")).getPrice());
        Assert.assertEquals((long)2L, (long)((Cheese)((Row)sorted.get(1)).get("stilton")).getPrice());
        stilton3.setPrice(3);
        ksession.update(s3Fh, (Object)stilton3);
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)sorted.size());
        Assert.assertEquals((long)1L, (long)((Cheese)((Row)sorted.get(0)).get("stilton")).getPrice());
        Assert.assertEquals((long)2L, (long)((Cheese)((Row)sorted.get(1)).get("stilton")).getPrice());
        Assert.assertEquals((long)3L, (long)((Cheese)((Row)sorted.get(2)).get("stilton")).getPrice());
        stilton2.setPrice(4);
        ksession.update(s2Fh, (Object)stilton2);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)sorted.size());
        Assert.assertEquals((long)1L, (long)((Cheese)((Row)sorted.get(0)).get("stilton")).getPrice());
        Assert.assertEquals((long)3L, (long)((Cheese)((Row)sorted.get(1)).get("stilton")).getPrice());
        cheddar2.setPrice(4);
        ksession.update(c2Fh, (Object)cheddar2);
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)sorted.size());
        Assert.assertEquals((long)1L, (long)((Cheese)((Row)sorted.get(0)).get("stilton")).getPrice());
        Assert.assertEquals((long)3L, (long)((Cheese)((Row)sorted.get(1)).get("stilton")).getPrice());
        Assert.assertEquals((long)4L, (long)((Cheese)((Row)sorted.get(2)).get("stilton")).getPrice());
        ksession.retract(s1Fh);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)sorted.size());
        Assert.assertEquals((long)3L, (long)((Cheese)((Row)sorted.get(0)).get("stilton")).getPrice());
        Assert.assertEquals((long)4L, (long)((Cheese)((Row)sorted.get(1)).get("stilton")).getPrice());
        query.close();
        Assert.assertEquals((long)0L, (long)sorted.size());
    }
}

