/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.drools.mvel.compiler.Cheese;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieSession;

@RunWith(value=Parameterized.class)
public class FunctionsTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public FunctionsTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Test
    public void testFunction() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_FunctionInConsequence.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 5);
        ksession.insert((Object)stilton);
        ksession.fireAllRules();
        Assert.assertEquals((Object)new Integer(5), ((List)ksession.getGlobal("list")).get(0));
    }

    @Test
    public void testFunctionException() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_FunctionException.drl"});
        KieSession ksession = kbase.newKieSession();
        Cheese brie = new Cheese("brie", 12);
        ksession.insert((Object)brie);
        try {
            ksession.fireAllRules();
            Assert.fail((String)"Should throw an Exception from the Function");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"this should throw an exception", (Object)e.getCause().getMessage());
        }
    }

    @Test
    public void testFunctionWithPrimitives() throws Exception {
        KieBase kbase = KieBaseUtil.getKieBaseFromClasspathResources(this.getClass(), (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"test_FunctionWithPrimitives.drl"});
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 5);
        ksession.insert((Object)stilton);
        ksession.fireAllRules();
        Assert.assertEquals((Object)new Integer(10), list.get(0));
    }

    @Test
    public void testFunctionCallingFunctionWithEclipse() throws Exception {
        Resource[] resources = KieUtil.createResources((String)"test_functionCallingFunction.drl", this.getClass());
        HashMap<String, String> kieModuleConfigurationProperties = new HashMap<String, String>();
        kieModuleConfigurationProperties.put("drools.dialect.java.compiler", "ECLIPSE");
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromResources((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, kieModuleConfigurationProperties, (Resource[])resources);
        KieSession ksession = kbase.newKieSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)12L, (long)((Integer)list.get(0)).intValue());
    }

    @Test
    public void testJBRULES3117() {
        String str = "package org.kie\nfunction boolean isOutOfRange( Object value, int lower ) { return true; }\nfunction boolean isNotContainedInt( Object value, int[] values ) { return true; }\nrule R1\nwhen\nthen\n    boolean x = isOutOfRange( Integer.MAX_VALUE, 1 );\n    boolean y = isNotContainedInt( Integer.MAX_VALUE, new int[] { 1, 2, 3 } );\nend\n";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{str});
        KieSession ksession = kbase.newKieSession();
        int rulesFired = ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)rulesFired);
    }
}

