/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.drools.mvel.compiler.Person;
import org.drools.mvel.integrationtests.facts.AnEnum;
import org.drools.mvel.integrationtests.facts.FactWithEnum;
import org.drools.testcoverage.common.util.KieBaseTestConfiguration;
import org.drools.testcoverage.common.util.KieBaseUtil;
import org.drools.testcoverage.common.util.KieUtil;
import org.drools.testcoverage.common.util.TestParametersUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.KieBase;
import org.kie.api.builder.KieModule;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.runtime.KieSession;
import org.kie.internal.conf.ConstraintJittingThresholdOption;

@RunWith(value=Parameterized.class)
public class JittingTest {
    private final KieBaseTestConfiguration kieBaseTestConfiguration;

    public JittingTest(KieBaseTestConfiguration kieBaseTestConfiguration) {
        this.kieBaseTestConfiguration = kieBaseTestConfiguration;
    }

    @Parameterized.Parameters(name="KieBase type={0}")
    public static Collection<Object[]> getParameters() {
        return TestParametersUtil.getKieBaseCloudConfigurations((boolean)false);
    }

    @Test
    public void testJitConstraintInvokingConstructor() {
        String str = "import org.drools.mvel.compiler.Person;\nrule R1 when\n   Person( new Integer( ageAsInteger ) < 40 ) \nthen\nend";
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{"import org.drools.mvel.compiler.Person;\nrule R1 when\n   Person( new Integer( ageAsInteger ) < 40 ) \nthen\nend"});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Person("Mario", 38));
        Assert.assertEquals((long)1L, (long)ksession.fireAllRules());
        ksession.dispose();
    }

    @Test
    public void testJittingConstraintWithInvocationOnLiteral() {
        String str = "package com.sample\nimport org.drools.mvel.compiler.Person\nrule XXX when\n  Person( name.toString().toLowerCase().contains( \"mark\".toString().toLowerCase() ) )\nthen\nend\n";
        this.testJitting("package com.sample\nimport org.drools.mvel.compiler.Person\nrule XXX when\n  Person( name.toString().toLowerCase().contains( \"mark\".toString().toLowerCase() ) )\nthen\nend\n");
    }

    @Test
    public void testJittingMethodWithCharSequenceArg() {
        String str = "package com.sample\nimport org.drools.mvel.compiler.Person\nrule XXX when\n  Person( $n : name, $n.contains( \"mark\" ) )\nthen\nend\n";
        this.testJitting("package com.sample\nimport org.drools.mvel.compiler.Person\nrule XXX when\n  Person( $n : name, $n.contains( \"mark\" ) )\nthen\nend\n");
    }

    private void testJitting(String drl) {
        KieBase kbase = KieBaseUtil.getKieBaseFromKieModuleFromDrl((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieSession ksession = kbase.newKieSession();
        ksession.insert((Object)new Person("mark", 37));
        ksession.insert((Object)new Person("mario", 38));
        ksession.fireAllRules();
        ksession.dispose();
    }

    @Test
    public void testJittingEnum() {
        String drl = "import " + AnEnum.class.getCanonicalName() + ";\n rule R1 \n when \n    $enumFact: AnEnum(this == AnEnum.FIRST)\n then \n end ";
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieBase kieBase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{ConstraintJittingThresholdOption.get((int)0)});
        KieSession kieSession = kieBase.newKieSession();
        kieSession.insert((Object)AnEnum.FIRST);
        Assertions.assertThat((int)kieSession.fireAllRules()).isEqualTo(1);
    }

    @Test
    public void testJittingEnumAttribute() {
        String drl = "import " + AnEnum.class.getCanonicalName() + ";\nimport " + FactWithEnum.class.getCanonicalName() + ";\n rule R1 \n when \n    $factWithEnum: FactWithEnum(enumValue == AnEnum.FIRST) \n then \n end ";
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieBase kieBase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{ConstraintJittingThresholdOption.get((int)0)});
        KieSession kieSession = kieBase.newKieSession();
        kieSession.insert((Object)new FactWithEnum(AnEnum.FIRST));
        Assertions.assertThat((int)kieSession.fireAllRules()).isEqualTo(1);
    }

    @Test
    public void testMvelJitDivision() {
        String drl = "import " + Person.class.getName() + ";\nrule R1 when\n  Person( name == \"John\", $age1 : age )\n  Person( name == \"Paul\", age > ((2*$age1)/3) )\nthen end\n";
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieBase kieBase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{ConstraintJittingThresholdOption.get((int)0)});
        KieSession ksession = kieBase.newKieSession();
        Person john = new Person("John", 20);
        ksession.insert((Object)john);
        Person paul = new Person("Paul", 20);
        ksession.insert((Object)paul);
        int fired = ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)fired);
    }

    @Test
    public void testJitMemberOf() {
        String drl = "import java.util.ArrayList;\nimport java.util.List;\n\ndeclare Foo\n  barNames : List\nend\n\ndeclare Bar\n  name : String\nend\n\nrule \"Init\"\n  when\n    not (Foo ())\n  then\n    List list = new ArrayList<String>();    list.add(null);    insert(new Foo(list));\n    insert(new Bar(null));\nend\n\nrule \"Add name\"\n  when\n    foo : Foo()\n    bar : Bar(name memberOf foo.barNames)\n  then\nend";
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieBase kieBase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{ConstraintJittingThresholdOption.get((int)0)});
        KieSession ksession = kieBase.newKieSession();
        int fired = ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)fired);
    }

    @Test
    public void testJitMapCoercion() {
        this.checkJitMapCoercion("status < $map.get(\"key\")", true, 0);
        this.checkJitMapCoercion("$map.get(\"key\") > status", true, 0);
        this.checkJitMapCoercion("status > $map.get(\"key\")", true, 1);
        this.checkJitMapCoercion("$map.get(\"key\") < status", true, 1);
        this.checkJitMapCoercion("status < $map.get(\"key\")", false, 1);
        this.checkJitMapCoercion("$map.get(\"key\") > status", false, 1);
        this.checkJitMapCoercion("status > $map.get(\"key\")", false, 0);
        this.checkJitMapCoercion("$map.get(\"key\") < status", false, 0);
        this.checkJitMapCoercion("$map.get(\"key\") < 10", true, 1);
        this.checkJitMapCoercion("$map.get(\"key\") < \"10\"", true, 1);
        this.checkJitMapCoercion("10 > $map.get(\"key\")", true, 1);
        this.checkJitMapCoercion("\"10\" > $map.get(\"key\")", true, 1);
    }

    public void checkJitMapCoercion(String constraint, boolean useInt, int expectedFires) {
        String drl = "package com.sample\nimport " + Map.class.getCanonicalName() + ";\nimport " + Person.class.getCanonicalName() + ";\nrule R when\n  $map : Map()\n  Person( " + constraint + " )\nthen\nend";
        KieModule kieModule = KieUtil.getKieModuleFromDrls((String)"test", (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (String[])new String[]{drl});
        KieBase kieBase = KieBaseUtil.newKieBaseFromKieModuleWithAdditionalOptions((KieModule)kieModule, (KieBaseTestConfiguration)this.kieBaseTestConfiguration, (KieBaseOption[])new KieBaseOption[]{ConstraintJittingThresholdOption.get((int)0)});
        KieSession ksession = kieBase.newKieSession();
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put("key", useInt ? Integer.valueOf(5) : "a");
        ksession.insert(valueMap);
        Person person = new Person();
        person.setStatus("10");
        ksession.insert((Object)person);
        Assert.assertEquals((long)expectedFires, (long)ksession.fireAllRules());
    }
}

