/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.lang.management.ManagementFactory;
import java.net.URL;
import java.net.URLClassLoader;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.drools.compiler.kie.builder.impl.KieServicesImpl;
import org.drools.core.ClockType;
import org.drools.core.impl.InternalKieContainer;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.management.DroolsManagementAgent;
import org.drools.mvel.CommonTestMethodBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.MBeansOption;
import org.kie.api.management.GenericKieSessionMonitoringMXBean;
import org.kie.api.management.KieContainerMonitorMXBean;
import org.kie.api.management.KieSessionMonitoringMXBean;
import org.kie.api.management.StatelessKieSessionMonitoringMXBean;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.internal.runtime.conf.ForceEagerActivationOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MBeansMonitoringTest
extends CommonTestMethodBase {
    public static final Logger LOG = LoggerFactory.getLogger(MBeansMonitoringTest.class);
    public static final String KSESSION1 = "KSession1";
    public static final String KBASE1 = "KBase1";
    private static final String KBASE2 = "KBase2";
    private static final String KSESSION2 = "KSession2";
    private String mbeansprop;

    @Before
    public void setUp() throws Exception {
        ((KieServicesImpl)KieServices.Factory.get()).nullKieClasspathContainer();
        ((KieServicesImpl)KieServices.Factory.get()).nullAllContainerIds();
        this.mbeansprop = System.getProperty("kie.mbeans");
        System.setProperty("kie.mbeans", "enabled");
    }

    @After
    public void tearDown() throws Exception {
        ((KieServicesImpl)KieServices.Factory.get()).nullKieClasspathContainer();
        ((KieServicesImpl)KieServices.Factory.get()).nullAllContainerIds();
        if (this.mbeansprop != null) {
            System.setProperty("kie.mbeans", this.mbeansprop);
        } else {
            System.setProperty("kie.mbeans", MBeansOption.DISABLED.toString());
        }
    }

    @Test
    public void testKieClasspathMBeans() throws Exception {
        MBeanServer mbserver = ManagementFactory.getPlatformMBeanServer();
        KieServices ks = KieServices.Factory.get();
        KieContainer kc = ks.getKieClasspathContainer("myID");
        KieContainerMonitorMXBean c1Monitor = JMX.newMXBeanProxy(mbserver, DroolsManagementAgent.createObjectNameBy((String)"myID"), KieContainerMonitorMXBean.class);
        KieBase kb = kc.getKieBase("org.kie.monitoring.kbase1");
        KieSession statefulKieSession = kc.newKieSession("org.kie.monitoring.kbase1.ksession1");
        StatelessKieSession statelessKieSession = kc.newStatelessKieSession("org.kie.monitoring.kbase1.ksession2");
        KieSessionMonitoringMXBean statefulKieSessionMonitor = JMX.newMXBeanProxy(mbserver, DroolsManagementAgent.createObjectNameBy((String)"myID", (String)"org.kie.monitoring.kbase1", (KieSessionModel.KieSessionType)KieSessionModel.KieSessionType.STATEFUL, (String)"org.kie.monitoring.kbase1.ksession1"), KieSessionMonitoringMXBean.class);
        StatelessKieSessionMonitoringMXBean statelessKieSessionMonitor = JMX.newMXBeanProxy(mbserver, DroolsManagementAgent.createObjectNameBy((String)"myID", (String)"org.kie.monitoring.kbase1", (KieSessionModel.KieSessionType)KieSessionModel.KieSessionType.STATEFUL, (String)"org.kie.monitoring.kbase1.ksession1"), StatelessKieSessionMonitoringMXBean.class);
        Assert.assertEquals((Object)"myID", (Object)c1Monitor.getContainerId());
        Assert.assertTrue((boolean)c1Monitor.getConfiguredReleaseId().sameGAVof((ReleaseId)KieContainerMonitorMXBean.CLASSPATH_KIECONTAINER_RELEASEID));
        Assert.assertTrue((boolean)c1Monitor.getResolvedReleaseId().sameGAVof((ReleaseId)KieContainerMonitorMXBean.CLASSPATH_KIECONTAINER_RELEASEID));
        Assert.assertEquals((Object)"org.kie.monitoring.kbase1.ksession1", (Object)statefulKieSessionMonitor.getKieSessionName());
        Assert.assertEquals((Object)"org.kie.monitoring.kbase1", (Object)statefulKieSessionMonitor.getKieBaseId());
        Assert.assertEquals((Object)"org.kie.monitoring.kbase1.ksession1", (Object)statelessKieSessionMonitor.getKieSessionName());
        Assert.assertEquals((Object)"org.kie.monitoring.kbase1", (Object)statelessKieSessionMonitor.getKieBaseId());
        KieContainer kc2 = ks.newKieClasspathContainer("myID2");
        KieContainerMonitorMXBean c2Monitor = JMX.newMXBeanProxy(mbserver, DroolsManagementAgent.createObjectNameBy((String)"myID2"), KieContainerMonitorMXBean.class);
        KieBase kb2 = kc2.getKieBase("org.kie.monitoring.kbase1");
        KieSession statefulKieSession2 = kc2.newKieSession("org.kie.monitoring.kbase1.ksession1");
        StatelessKieSession statelessKieSession2 = kc2.newStatelessKieSession("org.kie.monitoring.kbase1.ksession2");
        KieSessionMonitoringMXBean statefulKieSessionMonitor2 = JMX.newMXBeanProxy(mbserver, DroolsManagementAgent.createObjectNameBy((String)"myID2", (String)"org.kie.monitoring.kbase1", (KieSessionModel.KieSessionType)KieSessionModel.KieSessionType.STATEFUL, (String)"org.kie.monitoring.kbase1.ksession1"), KieSessionMonitoringMXBean.class);
        StatelessKieSessionMonitoringMXBean statelessKieSessionMonitor2 = JMX.newMXBeanProxy(mbserver, DroolsManagementAgent.createObjectNameBy((String)"myID2", (String)"org.kie.monitoring.kbase1", (KieSessionModel.KieSessionType)KieSessionModel.KieSessionType.STATEFUL, (String)"org.kie.monitoring.kbase1.ksession1"), StatelessKieSessionMonitoringMXBean.class);
        Assert.assertEquals((Object)"myID2", (Object)c2Monitor.getContainerId());
        Assert.assertTrue((boolean)c2Monitor.getConfiguredReleaseId().sameGAVof((ReleaseId)KieContainerMonitorMXBean.CLASSPATH_KIECONTAINER_RELEASEID));
        Assert.assertTrue((boolean)c2Monitor.getResolvedReleaseId().sameGAVof((ReleaseId)KieContainerMonitorMXBean.CLASSPATH_KIECONTAINER_RELEASEID));
        Assert.assertEquals((Object)"org.kie.monitoring.kbase1.ksession1", (Object)statefulKieSessionMonitor2.getKieSessionName());
        Assert.assertEquals((Object)"org.kie.monitoring.kbase1", (Object)statefulKieSessionMonitor2.getKieBaseId());
        Assert.assertEquals((Object)"org.kie.monitoring.kbase1.ksession1", (Object)statelessKieSessionMonitor2.getKieSessionName());
        Assert.assertEquals((Object)"org.kie.monitoring.kbase1", (Object)statelessKieSessionMonitor2.getKieBaseId());
        kc.dispose();
        kc2.dispose();
    }

    @Test
    public void testEventOffset() throws Exception {
        String drl = "package org.drools.mvel.compiler.test\nimport org.drools.mvel.compiler.StockTick\ndeclare StockTick\n    @role(event)\n    @expires(10s)\nend\nrule X\nwhen\n    StockTick()\nthen\nend";
        KieServices ks = KieServices.Factory.get();
        KieModuleModel kproj = ks.newKieModuleModel();
        KieBaseModel kieBaseModel1 = kproj.newKieBaseModel(KBASE1).setDefault(true).setEventProcessingMode(EventProcessingOption.STREAM);
        KieSessionModel ksession1 = kieBaseModel1.newKieSessionModel(KSESSION1).setDefault(true).setType(KieSessionModel.KieSessionType.STATEFUL).setClockType(ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        ReleaseId releaseId1 = ks.newReleaseId("org.kie.test", "mbeans", "1.0.0");
        MBeansMonitoringTest.createKJar(ks, kproj, releaseId1, null, drl);
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieBase kiebase = kc.getKieBase(KBASE1);
        MBeanServer mbserver = ManagementFactory.getPlatformMBeanServer();
        ObjectName kbOn = DroolsManagementAgent.createObjectNameFor((InternalKnowledgeBase)((InternalKnowledgeBase)kiebase));
        mbserver.invoke(kbOn, "startInternalMBeans", new Object[0], new String[0]);
        Object expOffset = mbserver.getAttribute(new ObjectName(kbOn + ",group=EntryPoints,EntryPoint=DEFAULT,ObjectType=org.drools.mvel.compiler.StockTick"), "ExpirationOffset");
        Assert.assertEquals((long)10001L, (long)((Number)expOffset).longValue());
    }

    @Test
    public void testContainerMBeans() throws Exception {
        String drl = "package org.drools.mvel.compiler.test\nimport org.drools.compiler.StockTick\ndeclare StockTick\n    @role(event)\n    @expires(10s)\nend\nrule X\nwhen\n    StockTick()\nthen\nend";
        KieServices ks = KieServices.Factory.get();
        KieModuleModel kproj = ks.newKieModuleModel();
        KieBaseModel kieBaseModel1 = kproj.newKieBaseModel(KBASE1).setDefault(true).setEventProcessingMode(EventProcessingOption.STREAM);
        KieSessionModel ksessionModel1 = kieBaseModel1.newKieSessionModel(KSESSION1).setDefault(true).setType(KieSessionModel.KieSessionType.STATEFUL).setClockType(ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        ReleaseId releaseId1 = ks.newReleaseId("org.kie.test", "mbeans", "1.0.0");
        MBeansMonitoringTest.createKJar(ks, kproj, releaseId1, null, drl);
        KieContainer kc = ks.newKieContainer(releaseId1);
        KieBase kiebase = kc.getKieBase(KBASE1);
        kc.newKieSession(KSESSION1);
        kiebase.newKieSession();
        String kc1ID = ((InternalKieContainer)kc).getContainerId();
        MBeanServer mbserver = ManagementFactory.getPlatformMBeanServer();
        LOG.debug("{}", mbserver.queryNames(new ObjectName("org.kie:kcontainerId=" + ObjectName.quote(kc1ID) + ",*"), null));
        ReleaseId verRelease = ks.newReleaseId("org.kie.test", "mbeans", "RELEASE");
        KieContainer kc2 = ks.newKieContainer("Matteo", verRelease);
        kc2.newKieSession(KSESSION1);
        KieContainerMonitorMXBean c1Monitor = JMX.newMXBeanProxy(mbserver, DroolsManagementAgent.createObjectNameBy((String)kc1ID), KieContainerMonitorMXBean.class);
        Assert.assertEquals((Object)releaseId1.toExternalForm(), (Object)c1Monitor.getConfiguredReleaseIdStr());
        Assert.assertEquals((Object)releaseId1.toExternalForm(), (Object)c1Monitor.getResolvedReleaseIdStr());
        Assert.assertTrue((boolean)c1Monitor.getConfiguredReleaseId().sameGAVof(releaseId1));
        Assert.assertTrue((boolean)c1Monitor.getResolvedReleaseId().sameGAVof(releaseId1));
        Assert.assertEquals((Object)releaseId1.getVersion(), (Object)c1Monitor.getConfiguredReleaseId().getVersion());
        Assert.assertEquals((Object)releaseId1.getVersion(), (Object)c1Monitor.getResolvedReleaseId().getVersion());
        KieContainerMonitorMXBean c2Monitor = JMX.newMXBeanProxy(mbserver, DroolsManagementAgent.createObjectNameBy((String)"Matteo"), KieContainerMonitorMXBean.class);
        Assert.assertEquals((Object)verRelease.toExternalForm(), (Object)c2Monitor.getConfiguredReleaseIdStr());
        Assert.assertEquals((Object)releaseId1.toExternalForm(), (Object)c2Monitor.getResolvedReleaseIdStr());
        Assert.assertTrue((boolean)c2Monitor.getConfiguredReleaseId().sameGAVof(verRelease));
        Assert.assertTrue((boolean)c2Monitor.getResolvedReleaseId().sameGAVof(releaseId1));
        Assert.assertEquals((Object)verRelease.getVersion(), (Object)c2Monitor.getConfiguredReleaseId().getVersion());
        Assert.assertEquals((Object)releaseId1.getVersion(), (Object)c2Monitor.getResolvedReleaseId().getVersion());
        Assert.assertEquals((long)3L, (long)mbserver.queryNames(new ObjectName("org.kie:kcontainerId=" + ObjectName.quote(kc1ID) + ",*"), null).size());
        kc.dispose();
        Assert.assertEquals((long)0L, (long)mbserver.queryNames(new ObjectName("org.kie:kcontainerId=" + ObjectName.quote(kc1ID) + ",*"), null).size());
        Assert.assertEquals((long)3L, (long)mbserver.queryNames(new ObjectName("org.kie:kcontainerId=" + ObjectName.quote("Matteo") + ",*"), null).size());
    }

    @Test
    public void testAggregatedAndDispose() throws Exception {
        String drl = "package org.drools.mvel.integrationtests\nrule ND\nwhen\n    String() \n    not ( Double() ) \nthen\n    // do nothing. \nend\nrule ND2\nsalience 1\nwhen\n    $s : String() \n    not ( Double() ) \nthen\n    try { Thread.sleep(10); } catch (Exception e) { }\n    insert( new Double(0) );\n    retract( $s );\nend\n";
        KieServices ks = KieServices.Factory.get();
        KieModuleModel kproj = ks.newKieModuleModel();
        KieBaseModel kieBaseModel1 = kproj.newKieBaseModel(KBASE1).setDefault(true).setEventProcessingMode(EventProcessingOption.STREAM);
        KieSessionModel ksessionModel1 = kieBaseModel1.newKieSessionModel(KSESSION1).setDefault(true).setType(KieSessionModel.KieSessionType.STATEFUL).setClockType(ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        KieBaseModel kieBaseModel2 = kproj.newKieBaseModel(KBASE2).setDefault(false);
        KieSessionModel ksessionModel2 = kieBaseModel2.newKieSessionModel(KSESSION2).setDefault(true).setType(KieSessionModel.KieSessionType.STATELESS);
        ReleaseId releaseId1 = ks.newReleaseId("org.kie.test", "mbeans", "1.0.0");
        MBeansMonitoringTest.createKJar(ks, kproj, releaseId1, null, drl);
        String containerId = "myContainerId";
        KieContainer kc = ks.newKieContainer(containerId, releaseId1);
        KieBase kiebase = kc.getKieBase(KBASE1);
        KieSessionConfiguration sessionConf = ks.newKieSessionConfiguration();
        sessionConf.setOption((KieSessionOption)ForceEagerActivationOption.YES);
        KieSession ksession = kc.newKieSession(KSESSION1, sessionConf);
        MBeanServer mbserver = ManagementFactory.getPlatformMBeanServer();
        KieSessionMonitoringMXBean aggrMonitor = JMX.newMXBeanProxy(mbserver, DroolsManagementAgent.createObjectNameBy((String)containerId, (String)KBASE1, (KieSessionModel.KieSessionType)KieSessionModel.KieSessionType.STATEFUL, (String)KSESSION1), KieSessionMonitoringMXBean.class);
        long tft = 0L;
        this.print((GenericKieSessionMonitoringMXBean)aggrMonitor);
        this.checkAgendaTotals((GenericKieSessionMonitoringMXBean)aggrMonitor, 0L, 0L, 0L);
        this.checkTotalFactCount(aggrMonitor, 0);
        tft = this.checkTotalFiringTimeGEQ((GenericKieSessionMonitoringMXBean)aggrMonitor, tft);
        this.checkTotalSessions((GenericKieSessionMonitoringMXBean)aggrMonitor, 1);
        Assert.assertNull((Object)aggrMonitor.getStatsForRule("ND"));
        Assert.assertNull((Object)aggrMonitor.getStatsForRule("ND2"));
        Assert.assertFalse((boolean)aggrMonitor.getStatsByRule().containsKey("ND"));
        Assert.assertFalse((boolean)aggrMonitor.getStatsByRule().containsKey("ND2"));
        ksession.insert((Object)"Ciao");
        ksession.fireAllRules();
        this.print((GenericKieSessionMonitoringMXBean)aggrMonitor);
        this.checkAgendaTotals((GenericKieSessionMonitoringMXBean)aggrMonitor, 2L, 1L, 1L);
        this.checkTotalFactCount(aggrMonitor, 1);
        tft = this.checkTotalFiringTimeGEQ((GenericKieSessionMonitoringMXBean)aggrMonitor, tft + 1L);
        this.checkTotalSessions((GenericKieSessionMonitoringMXBean)aggrMonitor, 1);
        this.checkStatsForRule((GenericKieSessionMonitoringMXBean)aggrMonitor, "ND", 1L, 1L, 0L);
        this.checkStatsForRule((GenericKieSessionMonitoringMXBean)aggrMonitor, "ND2", 1L, 0L, 1L);
        this.checkStatsByRule((GenericKieSessionMonitoringMXBean)aggrMonitor, "ND", 1L, 1L, 0L);
        this.checkStatsByRule((GenericKieSessionMonitoringMXBean)aggrMonitor, "ND2", 1L, 0L, 1L);
        ksession.fireAllRules();
        this.print((GenericKieSessionMonitoringMXBean)aggrMonitor);
        this.checkAgendaTotals((GenericKieSessionMonitoringMXBean)aggrMonitor, 2L, 1L, 1L);
        this.checkTotalFactCount(aggrMonitor, 1);
        tft = this.checkTotalFiringTimeGEQ((GenericKieSessionMonitoringMXBean)aggrMonitor, tft);
        this.checkTotalSessions((GenericKieSessionMonitoringMXBean)aggrMonitor, 1);
        this.checkStatsForRule((GenericKieSessionMonitoringMXBean)aggrMonitor, "ND", 1L, 1L, 0L);
        this.checkStatsForRule((GenericKieSessionMonitoringMXBean)aggrMonitor, "ND2", 1L, 0L, 1L);
        this.checkStatsByRule((GenericKieSessionMonitoringMXBean)aggrMonitor, "ND", 1L, 1L, 0L);
        this.checkStatsByRule((GenericKieSessionMonitoringMXBean)aggrMonitor, "ND2", 1L, 0L, 1L);
        LOG.debug("---");
        KieSession ksession2 = kc.newKieSession(KSESSION1, sessionConf);
        ksession2.insert((Object)"Ciao");
        ksession2.fireAllRules();
        this.print((GenericKieSessionMonitoringMXBean)aggrMonitor);
        this.checkAgendaTotals((GenericKieSessionMonitoringMXBean)aggrMonitor, 4L, 2L, 2L);
        this.checkTotalFactCount(aggrMonitor, 2);
        tft = this.checkTotalFiringTimeGEQ((GenericKieSessionMonitoringMXBean)aggrMonitor, tft + 1L);
        this.checkTotalSessions((GenericKieSessionMonitoringMXBean)aggrMonitor, 2);
        this.checkStatsForRule((GenericKieSessionMonitoringMXBean)aggrMonitor, "ND", 2L, 2L, 0L);
        this.checkStatsForRule((GenericKieSessionMonitoringMXBean)aggrMonitor, "ND2", 2L, 0L, 2L);
        this.checkStatsByRule((GenericKieSessionMonitoringMXBean)aggrMonitor, "ND", 2L, 2L, 0L);
        this.checkStatsByRule((GenericKieSessionMonitoringMXBean)aggrMonitor, "ND2", 2L, 0L, 2L);
        ksession.dispose();
        this.checkTotalSessions((GenericKieSessionMonitoringMXBean)aggrMonitor, 1);
        this.checkTotalFactCount(aggrMonitor, 1);
        ksession2.dispose();
        this.checkTotalSessions((GenericKieSessionMonitoringMXBean)aggrMonitor, 0);
        this.checkTotalFactCount(aggrMonitor, 0);
        LOG.debug("--- NOW for the STATELESS ---");
        tft = 0L;
        StatelessKieSession stateless = kc.newStatelessKieSession(KSESSION2, sessionConf);
        StatelessKieSessionMonitoringMXBean aggrMonitor2 = JMX.newMXBeanProxy(mbserver, DroolsManagementAgent.createObjectNameBy((String)containerId, (String)KBASE2, (KieSessionModel.KieSessionType)KieSessionModel.KieSessionType.STATELESS, (String)KSESSION2), StatelessKieSessionMonitoringMXBean.class);
        this.print((GenericKieSessionMonitoringMXBean)aggrMonitor2);
        this.checkAgendaTotals((GenericKieSessionMonitoringMXBean)aggrMonitor2, 0L, 0L, 0L);
        this.checkRuleRuntimeTotals(aggrMonitor2, 0, 0);
        tft = this.checkTotalFiringTimeGEQ((GenericKieSessionMonitoringMXBean)aggrMonitor2, tft);
        this.checkTotalSessions((GenericKieSessionMonitoringMXBean)aggrMonitor2, 0);
        Assert.assertNull((Object)aggrMonitor2.getStatsForRule("ND"));
        Assert.assertNull((Object)aggrMonitor2.getStatsForRule("ND2"));
        Assert.assertFalse((boolean)aggrMonitor2.getStatsByRule().containsKey("ND"));
        Assert.assertFalse((boolean)aggrMonitor2.getStatsByRule().containsKey("ND2"));
        stateless.execute((Object)"Ciao");
        this.print((GenericKieSessionMonitoringMXBean)aggrMonitor2);
        this.checkAgendaTotals((GenericKieSessionMonitoringMXBean)aggrMonitor2, 2L, 1L, 1L);
        this.checkRuleRuntimeTotals(aggrMonitor2, 2, 1);
        tft = this.checkTotalFiringTimeGEQ((GenericKieSessionMonitoringMXBean)aggrMonitor2, tft + 1L);
        this.checkTotalSessions((GenericKieSessionMonitoringMXBean)aggrMonitor2, 1);
        this.checkStatsForRule((GenericKieSessionMonitoringMXBean)aggrMonitor2, "ND", 1L, 1L, 0L);
        this.checkStatsForRule((GenericKieSessionMonitoringMXBean)aggrMonitor2, "ND2", 1L, 0L, 1L);
        this.checkStatsByRule((GenericKieSessionMonitoringMXBean)aggrMonitor2, "ND", 1L, 1L, 0L);
        this.checkStatsByRule((GenericKieSessionMonitoringMXBean)aggrMonitor2, "ND2", 1L, 0L, 1L);
        stateless.execute((Object)"Ciao");
        this.print((GenericKieSessionMonitoringMXBean)aggrMonitor2);
        this.checkAgendaTotals((GenericKieSessionMonitoringMXBean)aggrMonitor2, 4L, 2L, 2L);
        this.checkRuleRuntimeTotals(aggrMonitor2, 4, 2);
        tft = this.checkTotalFiringTimeGEQ((GenericKieSessionMonitoringMXBean)aggrMonitor2, tft + 1L);
        this.checkTotalSessions((GenericKieSessionMonitoringMXBean)aggrMonitor2, 2);
        this.checkStatsForRule((GenericKieSessionMonitoringMXBean)aggrMonitor2, "ND", 2L, 2L, 0L);
        this.checkStatsForRule((GenericKieSessionMonitoringMXBean)aggrMonitor2, "ND2", 2L, 0L, 2L);
        this.checkStatsByRule((GenericKieSessionMonitoringMXBean)aggrMonitor2, "ND", 2L, 2L, 0L);
        this.checkStatsByRule((GenericKieSessionMonitoringMXBean)aggrMonitor2, "ND2", 2L, 0L, 2L);
        StatelessKieSession stateless2 = kc.newStatelessKieSession(KSESSION2, sessionConf);
        LOG.debug(stateless + " " + stateless2);
        this.checkTotalSessions((GenericKieSessionMonitoringMXBean)aggrMonitor2, 2);
        stateless2.execute((Object)"Ciao");
        this.print((GenericKieSessionMonitoringMXBean)aggrMonitor2);
        this.checkAgendaTotals((GenericKieSessionMonitoringMXBean)aggrMonitor2, 6L, 3L, 3L);
        this.checkRuleRuntimeTotals(aggrMonitor2, 6, 3);
        tft = this.checkTotalFiringTimeGEQ((GenericKieSessionMonitoringMXBean)aggrMonitor2, tft + 1L);
        this.checkTotalSessions((GenericKieSessionMonitoringMXBean)aggrMonitor2, 3);
        this.checkStatsForRule((GenericKieSessionMonitoringMXBean)aggrMonitor2, "ND", 3L, 3L, 0L);
        this.checkStatsForRule((GenericKieSessionMonitoringMXBean)aggrMonitor2, "ND2", 3L, 0L, 3L);
        this.checkStatsByRule((GenericKieSessionMonitoringMXBean)aggrMonitor2, "ND", 3L, 3L, 0L);
        this.checkStatsByRule((GenericKieSessionMonitoringMXBean)aggrMonitor2, "ND2", 3L, 0L, 3L);
        KieContainer kc2 = ks.newKieContainer("kc2", releaseId1);
        Assert.assertEquals((long)5L, (long)mbserver.queryNames(new ObjectName("org.kie:kcontainerId=" + ObjectName.quote(containerId) + ",*"), null).size());
        kc.dispose();
        Assert.assertEquals((long)0L, (long)mbserver.queryNames(new ObjectName("org.kie:kcontainerId=" + ObjectName.quote(containerId) + ",*"), null).size());
        Assert.assertEquals((long)1L, (long)mbserver.queryNames(new ObjectName("org.kie:kcontainerId=" + ObjectName.quote("kc2") + ",*"), null).size());
    }

    private void checkStatsByRule(GenericKieSessionMonitoringMXBean mb, String ruleName, long mCreated, long mCancelled, long mFired) {
        Assert.assertEquals((long)mCreated, (long)((GenericKieSessionMonitoringMXBean.IAgendaStatsData)mb.getStatsByRule().get(ruleName)).getMatchesCreated());
        Assert.assertEquals((long)mCancelled, (long)((GenericKieSessionMonitoringMXBean.IAgendaStatsData)mb.getStatsByRule().get(ruleName)).getMatchesCancelled());
        Assert.assertEquals((long)mFired, (long)((GenericKieSessionMonitoringMXBean.IAgendaStatsData)mb.getStatsByRule().get(ruleName)).getMatchesFired());
    }

    private void checkStatsForRule(GenericKieSessionMonitoringMXBean mb, String ruleName, long mCreated, long mCancelled, long mFired) {
        Assert.assertEquals((long)mCreated, (long)mb.getStatsForRule(ruleName).getMatchesCreated());
        Assert.assertEquals((long)mCancelled, (long)mb.getStatsForRule(ruleName).getMatchesCancelled());
        Assert.assertEquals((long)mFired, (long)mb.getStatsForRule(ruleName).getMatchesFired());
    }

    private void print(GenericKieSessionMonitoringMXBean mb) {
        LOG.debug("total match created  : {}", (Object)mb.getTotalMatchesCreated());
        LOG.debug("total match cancelled: {}", (Object)mb.getTotalMatchesCancelled());
        LOG.debug("total match fired    : {}", (Object)mb.getTotalMatchesFired());
        if (mb instanceof StatelessKieSessionMonitoringMXBean) {
            StatelessKieSessionMonitoringMXBean c = (StatelessKieSessionMonitoringMXBean)mb;
            LOG.debug("inserted and deleted : +{} -{}", (Object)c.getTotalObjectsInserted(), (Object)c.getTotalObjectsDeleted());
        } else if (mb instanceof KieSessionMonitoringMXBean) {
            KieSessionMonitoringMXBean c = (KieSessionMonitoringMXBean)mb;
            LOG.debug("total tact count     : {}", (Object)c.getTotalFactCount());
        }
        LOG.debug("{} ms .", (Object)mb.getTotalFiringTime());
    }

    private long checkTotalFiringTimeGEQ(GenericKieSessionMonitoringMXBean mb, long amount) {
        Assert.assertTrue((mb.getTotalFiringTime() >= amount ? 1 : 0) != 0);
        return mb.getTotalFiringTime();
    }

    private void checkTotalSessions(GenericKieSessionMonitoringMXBean mb, int totalSessions) {
        Assert.assertEquals((long)totalSessions, (long)mb.getTotalSessions());
    }

    private void checkTotalFactCount(KieSessionMonitoringMXBean mb, int factCount) {
        Assert.assertEquals((long)factCount, (long)mb.getTotalFactCount());
    }

    private void checkRuleRuntimeTotals(StatelessKieSessionMonitoringMXBean mb, int inserted, int deleted) {
        Assert.assertEquals((long)inserted, (long)mb.getTotalObjectsInserted());
        Assert.assertEquals((long)deleted, (long)mb.getTotalObjectsDeleted());
    }

    private void checkAgendaTotals(GenericKieSessionMonitoringMXBean mb, long mCreated, long mCancelled, long mFired) {
        Assert.assertEquals((long)mCreated, (long)mb.getTotalMatchesCreated());
        Assert.assertEquals((long)mCancelled, (long)mb.getTotalMatchesCancelled());
        Assert.assertEquals((long)mFired, (long)mb.getTotalMatchesFired());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadKjarFromClasspath() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{this.getClass().getResource("/kie-project-simple-1.0.0.jar")});
        Thread.currentThread().setContextClassLoader(urlClassLoader);
        MBeanServer mbserver = ManagementFactory.getPlatformMBeanServer();
        try {
            KieServices ks = KieServices.Factory.get();
            KieRepository kieRepository = ks.getRepository();
            ReleaseId releaseId = ks.newReleaseId("org.test", "kie-project-simple", "1.0.0");
            KieModule kieModule = kieRepository.getKieModule(releaseId);
            Assert.assertNotNull((Object)kieModule);
            Assert.assertEquals((Object)releaseId, (Object)kieModule.getReleaseId());
            ks.newKieContainer("myID", releaseId);
            KieContainerMonitorMXBean c1Monitor = JMX.newMXBeanProxy(mbserver, DroolsManagementAgent.createObjectNameBy((String)"myID"), KieContainerMonitorMXBean.class);
            Assert.assertTrue((boolean)c1Monitor.getConfiguredReleaseId().sameGAVof(releaseId));
            Assert.assertTrue((boolean)c1Monitor.getResolvedReleaseId().sameGAVof(releaseId));
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }
}

