/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.integrationtests;

import java.util.ArrayList;
import java.util.Collection;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.mvel.CommonTestMethodBase;
import org.drools.mvel.compiler.Cheese;
import org.drools.mvel.integrationtests.SerializationHelper;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.KieSession;

public class MergePackageTest
extends CommonTestMethodBase {
    @Test
    public void testMergingDifferentPackages2() throws Exception {
        try {
            Collection<KiePackage> kpkgs1 = this.loadKnowledgePackages("test_RuleNameClashes1.drl");
            KiePackage kpkg1 = kpkgs1.stream().filter(pkg -> pkg.getName().equals("org.drools.package1")).findFirst().get();
            Assert.assertEquals((long)1L, (long)kpkg1.getRules().size());
            Collection<KiePackage> kpkgs2 = this.loadKnowledgePackages("test_RuleNameClashes2.drl");
            KiePackage kpkg2 = kpkgs2.stream().filter(pkg -> pkg.getName().equals("org.drools.package2")).findFirst().get();
            Assert.assertEquals((long)1L, (long)kpkg2.getRules().size());
            InternalKnowledgeBase kbase = (InternalKnowledgeBase)this.loadKnowledgeBase(new String[0]);
            kbase.addPackages(kpkgs1);
            kbase.addPackages(kpkgs2);
            kbase = SerializationHelper.serializeObject(kbase);
            KieSession ksession = this.createKnowledgeSession((KieBase)kbase);
            ArrayList results = new ArrayList();
            ksession.setGlobal("results", results);
            ksession.insert((Object)new Cheese("stilton", 10));
            ksession.insert((Object)new Cheese("brie", 5));
            ksession.fireAllRules();
            Assert.assertEquals((String)((Object)results).toString(), (long)2L, (long)results.size());
            Assert.assertTrue((boolean)results.contains("p1.r1"));
            Assert.assertTrue((boolean)results.contains("p2.r1"));
        }
        catch (KnowledgeBuilderImpl.PackageMergeException e) {
            Assert.fail((String)("Should not raise exception when merging different packages into the same rulebase: " + e.getMessage()));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("unexpected exception: " + e.getMessage()));
        }
    }

    @Test
    public void testMergePackageWithSameRuleNames() throws Exception {
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)SerializationHelper.serializeObject(this.loadKnowledgeBase("test_MergePackageWithSameRuleNames1.drl"));
        Collection<KiePackage> kpkgs = this.loadKnowledgePackages("test_MergePackageWithSameRuleNames2.drl");
        kbase.addPackages(kpkgs);
        KieSession ksession = this.createKnowledgeSession((KieBase)kbase);
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)"rule1 for the package2", results.get(0));
    }

    @Test
    public void testMergingDifferentPackages() throws Exception {
        try {
            Collection<KiePackage> kpkgs = this.loadKnowledgePackages("test_RuleNameClashes1.drl", "test_RuleNameClashes2.drl");
            Assert.assertEquals((long)3L, (long)kpkgs.size());
            for (KiePackage kpkg : kpkgs) {
                if (!kpkg.getName().equals("org.drools.package1")) continue;
                Assert.assertEquals((Object)"rule 1", (Object)((Rule)kpkg.getRules().iterator().next()).getName());
            }
        }
        catch (KnowledgeBuilderImpl.PackageMergeException e) {
            Assert.fail((String)("unexpected exception: " + e.getMessage()));
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            Assert.fail((String)("unexpected exception: " + e.getMessage()));
        }
    }
}

